/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.registryclient.central;

import io.github.resilience4j.retry.annotation.Retry;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.tractusx.irs.component.assetadministrationshell.AssetAdministrationShellDescriptor;
import org.eclipse.tractusx.irs.component.assetadministrationshell.IdentifierKeyValuePair;
import org.eclipse.tractusx.irs.data.StringMapper;
import org.eclipse.tractusx.irs.registryclient.central.DigitalTwinRegistryClient;
import org.eclipse.tractusx.irs.registryclient.decentral.LookupShellsResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpMethod;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class DigitalTwinRegistryClientImpl
implements DigitalTwinRegistryClient {
    private static final String PLACEHOLDER_AAS_IDENTIFIER = "aasIdentifier";
    private static final String PLACEHOLDER_ASSET_IDS = "assetIds";
    private final RestTemplate restTemplate;
    private final String descriptorEndpoint;
    private final String shellLookupEndpoint;

    public DigitalTwinRegistryClientImpl(RestTemplate restTemplate, @Value(value="${digitalTwinRegistry.descriptorEndpoint:}") String descriptorEndpoint, @Value(value="${digitalTwinRegistry.shellLookupEndpoint:}") String shellLookupEndpoint) {
        this.restTemplate = restTemplate;
        this.descriptorEndpoint = descriptorEndpoint;
        this.shellLookupEndpoint = shellLookupEndpoint;
        this.ensureUrlContainsPlaceholders(descriptorEndpoint, "digitalTwinRegistry.descriptorEndpoint", PLACEHOLDER_AAS_IDENTIFIER);
    }

    private static void require(String descriptorEndpoint, String configPath, String placeholder) {
        if (!descriptorEndpoint.contains(DigitalTwinRegistryClientImpl.wrap(placeholder))) {
            throw new IllegalStateException("Configuration value for '" + configPath + "' must contain the URL placeholder '" + placeholder + "'!");
        }
    }

    private static String wrap(String placeholderIdType) {
        return "{" + placeholderIdType + "}";
    }

    private static String encodeWithBase64(String aasIdentifier) {
        return Base64.getEncoder().encodeToString(aasIdentifier.getBytes(StandardCharsets.UTF_8));
    }

    private void ensureUrlContainsPlaceholders(String descriptorEndpoint, String configPath, String ... placeholders) {
        if (StringUtils.isNotBlank((CharSequence)descriptorEndpoint)) {
            for (String placeholder : placeholders) {
                DigitalTwinRegistryClientImpl.require(descriptorEndpoint, configPath, placeholder);
            }
        }
    }

    @Override
    @Retry(name="registry")
    public AssetAdministrationShellDescriptor getAssetAdministrationShellDescriptor(String aasIdentifier) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)this.descriptorEndpoint);
        Map<String, String> values = Map.of(PLACEHOLDER_AAS_IDENTIFIER, DigitalTwinRegistryClientImpl.encodeWithBase64(aasIdentifier));
        return (AssetAdministrationShellDescriptor)this.restTemplate.getForObject(uriBuilder.build(values), AssetAdministrationShellDescriptor.class);
    }

    @Override
    @Retry(name="registry")
    public LookupShellsResponse getAllAssetAdministrationShellIdsByAssetLink(List<IdentifierKeyValuePair> assetIds) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)this.shellLookupEndpoint);
        uriBuilder.uriVariables(Map.of(PLACEHOLDER_ASSET_IDS, StringMapper.mapToString(assetIds)));
        return (LookupShellsResponse)this.restTemplate.exchange(uriBuilder.build().toUri(), HttpMethod.GET, null, LookupShellsResponse.class).getBody();
    }
}

