/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.registryclient.decentral;

import io.github.resilience4j.retry.annotation.Retry;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.eclipse.edc.spi.types.domain.edr.EndpointDataReference;
import org.eclipse.tractusx.irs.component.assetadministrationshell.AssetAdministrationShellDescriptor;
import org.eclipse.tractusx.irs.component.assetadministrationshell.IdentifierKeyValuePair;
import org.eclipse.tractusx.irs.registryclient.decentral.LookupShellsResponse;
import org.eclipse.tractusx.irs.registryclient.util.SerializationHelper;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class DecentralDigitalTwinRegistryClient {
    private static final String PLACEHOLDER_AAS_IDENTIFIER = "aasIdentifier";
    private static final String PLACEHOLDER_ASSET_IDS = "assetIds";
    private final RestTemplate edcRestTemplate;
    private final String shellDescriptorTemplate;
    private final String lookupShellsTemplate;
    private final SerializationHelper serializationHelper = new SerializationHelper();

    public DecentralDigitalTwinRegistryClient(RestTemplate edcRestTemplate, @Value(value="${digitalTwinRegistry.shellDescriptorTemplate:}") String shellDescriptorTemplate, @Value(value="${digitalTwinRegistry.lookupShellsTemplate:}") String lookupShellsTemplate) {
        this.edcRestTemplate = edcRestTemplate;
        this.shellDescriptorTemplate = shellDescriptorTemplate;
        this.lookupShellsTemplate = lookupShellsTemplate;
    }

    @Retry(name="registry")
    public AssetAdministrationShellDescriptor getAssetAdministrationShellDescriptor(EndpointDataReference endpointDataReference, String aasIdentifier) {
        String descriptorEndpoint = endpointDataReference.getEndpoint() + this.shellDescriptorTemplate;
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)descriptorEndpoint);
        Map<String, String> values = Map.of(PLACEHOLDER_AAS_IDENTIFIER, this.encodeWithBase64(aasIdentifier));
        return (AssetAdministrationShellDescriptor)this.edcRestTemplate.exchange(uriBuilder.build(values), HttpMethod.GET, new HttpEntity(null, (MultiValueMap)this.headers(endpointDataReference)), AssetAdministrationShellDescriptor.class).getBody();
    }

    @Retry(name="registry")
    public LookupShellsResponse getAllAssetAdministrationShellIdsByAssetLink(EndpointDataReference endpointDataReference, IdentifierKeyValuePair assetIds) {
        String shellLookupEndpoint = endpointDataReference.getEndpoint() + this.lookupShellsTemplate;
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)shellLookupEndpoint);
        uriBuilder.uriVariables(Map.of(PLACEHOLDER_ASSET_IDS, this.encodeWithBase64(assetIds)));
        return (LookupShellsResponse)this.edcRestTemplate.exchange(uriBuilder.build().toUri(), HttpMethod.GET, new HttpEntity(null, (MultiValueMap)this.headers(endpointDataReference)), LookupShellsResponse.class).getBody();
    }

    private String encodeWithBase64(String aasIdentifier) {
        return Base64.getEncoder().encodeToString(aasIdentifier.getBytes(StandardCharsets.UTF_8));
    }

    private String encodeWithBase64(IdentifierKeyValuePair assetIds) {
        return Base64.getEncoder().encodeToString(this.serializationHelper.serialize(assetIds));
    }

    private HttpHeaders headers(EndpointDataReference dataReference) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(List.of(MediaType.APPLICATION_JSON));
        String authKey = dataReference.getAuthKey();
        if (authKey != null) {
            headers.add(authKey, dataReference.getAuthCode());
        }
        return headers;
    }
}

