/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.registryclient.decentral;

import lombok.Generated;
import org.eclipse.tractusx.irs.component.assetadministrationshell.AssetAdministrationShellDescriptor;
import org.eclipse.tractusx.irs.registryclient.decentral.exception.CreateDtrShellException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class DigitalTwinRegistryCreateShellService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DigitalTwinRegistryCreateShellService.class);
    private final RestTemplate restTemplate;
    private final String createShellUrl;

    public AssetAdministrationShellDescriptor createShell(AssetAdministrationShellDescriptor assetAdministrationShellDescriptor) throws CreateDtrShellException {
        try {
            ResponseEntity createdShellResponse = this.restTemplate.postForEntity(this.createShellUrl, (Object)new HttpEntity((Object)assetAdministrationShellDescriptor, (MultiValueMap)this.headers()), AssetAdministrationShellDescriptor.class, new Object[0]);
            HttpStatusCode responseCode = createdShellResponse.getStatusCode();
            if (responseCode.value() == HttpStatus.CREATED.value()) {
                return (AssetAdministrationShellDescriptor)createdShellResponse.getBody();
            }
        }
        catch (RestClientException e) {
            throw new CreateDtrShellException(e);
        }
        throw new CreateDtrShellException("Failed to create shell %s".formatted(assetAdministrationShellDescriptor.getGlobalAssetId()));
    }

    private HttpHeaders headers() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        return headers;
    }

    @Generated
    public DigitalTwinRegistryCreateShellService(RestTemplate restTemplate, String createShellUrl) {
        this.restTemplate = restTemplate;
        this.createShellUrl = createShellUrl;
    }
}

