/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.registryclient.decentral;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.eclipse.edc.spi.types.domain.edr.EndpointDataReference;
import org.eclipse.tractusx.irs.registryclient.decentral.EdcEndpointReferenceRetriever;
import org.eclipse.tractusx.irs.registryclient.decentral.EdcRetrieverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

public class EndpointDataForConnectorsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EndpointDataForConnectorsService.class);
    private static final String TOOK_MS = "{} took {} ms";
    private final EdcEndpointReferenceRetriever edcSubmodelFacade;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CompletableFuture<EndpointDataReference>> createFindEndpointDataForConnectorsFutures(List<String> edcUrls, String bpn) {
        StopWatch watch = new StopWatch();
        String msg = "Creating futures to get EndpointDataReferences for endpoints: %s".formatted(edcUrls);
        watch.start(msg);
        log.info(msg);
        List<Object> futures = Collections.emptyList();
        try {
            List<Object> list = futures = edcUrls.stream().flatMap(edcUrl -> this.createGetEndpointReferencesForAssetFutures((String)edcUrl, bpn).stream()).toList();
            return list;
        }
        finally {
            log.info("Created {} futures", (Object)futures.size());
            watch.stop();
            log.info(TOOK_MS, (Object)watch.getLastTaskName(), (Object)watch.getLastTaskTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CompletableFuture<EndpointDataReference>> createGetEndpointReferencesForAssetFutures(String edcUrl, String bpn) {
        StopWatch watch = new StopWatch();
        String msg = "Trying to retrieve EndpointDataReference for connector '%s'".formatted(edcUrl);
        watch.start(msg);
        log.info(msg);
        try {
            List<CompletableFuture<EndpointDataReference>> list = this.edcSubmodelFacade.getEndpointReferencesForAsset(edcUrl, bpn);
            return list;
        }
        catch (EdcRetrieverException e) {
            log.warn("Exception occurred when retrieving EndpointDataReference from connector '{}'", (Object)edcUrl, (Object)e);
            List<CompletableFuture<EndpointDataReference>> list = List.of(CompletableFuture.failedFuture(new EdcRetrieverException.Builder(e).withBpn(bpn).withEdcUrl(edcUrl).build()));
            return list;
        }
        finally {
            watch.stop();
            log.info(TOOK_MS, (Object)watch.getLastTaskName(), (Object)watch.getLastTaskTimeMillis());
        }
    }

    @Generated
    public EndpointDataForConnectorsService(EdcEndpointReferenceRetriever edcSubmodelFacade) {
        this.edcSubmodelFacade = edcSubmodelFacade;
    }
}

