/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.registryclient.discovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.tractusx.irs.registryclient.discovery.DiscoveryEndpoint;
import org.eclipse.tractusx.irs.registryclient.discovery.DiscoveryFinderClient;
import org.eclipse.tractusx.irs.registryclient.discovery.DiscoveryFinderRequest;
import org.eclipse.tractusx.irs.registryclient.discovery.EdcDiscoveryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.annotation.Scheduled;

public class ConnectorEndpointsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConnectorEndpointsService.class);
    private static final String DSP_PATH = "/api/v1/dsp";
    private final DiscoveryFinderClient discoveryFinderClient;
    private static final String CONNECTOR_ENDPOINT_SERVICE_CACHE_NAME = "connector_endpoint_service_cache";
    private final String discoveryType;

    @Cacheable(value={"connector_endpoint_service_cache"})
    public List<String> fetchConnectorEndpoints(String bpn) {
        if (StringUtils.isBlank((CharSequence)bpn)) {
            log.warn("BPN was null, cannot search for any connector endpoints. Returning empty list.");
            return List.of();
        }
        log.info("Requesting connector endpoints for BPN {}", (Object)bpn);
        DiscoveryFinderRequest onlyBpn = new DiscoveryFinderRequest(List.of(this.discoveryType));
        List<DiscoveryEndpoint> discoveryEndpoints = this.discoveryFinderClient.findDiscoveryEndpoints(onlyBpn).endpoints();
        List<String> endpoints = discoveryEndpoints.stream().flatMap(discoveryEndpoint -> this.discoveryFinderClient.findConnectorEndpoints(discoveryEndpoint.endpointAddress(), List.of(bpn)).stream().filter(edcDiscoveryResult -> edcDiscoveryResult.bpn().equals(bpn)).map(EdcDiscoveryResult::connectorEndpoint)).flatMap(Collection::stream).map(ConnectorEndpointsService::ensureStandardDspEndpoint).toList();
        List<String> endPointsWithoutDuplicates = ConnectorEndpointsService.removeDuplicates(endpoints);
        log.info("Discovered the following endpoints for BPN '{}': '{}'", (Object)bpn, (Object)String.join((CharSequence)", ", endPointsWithoutDuplicates));
        return endPointsWithoutDuplicates;
    }

    private static List<String> removeDuplicates(List<String> urls) {
        LinkedHashSet<String> uniqueUrls = new LinkedHashSet<String>(urls);
        return new ArrayList<String>(uniqueUrls);
    }

    private static String ensureStandardDspEndpoint(String url) {
        Object processedUrl = url;
        if (!((String)processedUrl).endsWith(DSP_PATH)) {
            if (((String)processedUrl).endsWith("/")) {
                processedUrl = ((String)processedUrl).substring(0, ((String)processedUrl).length() - 1);
            }
            processedUrl = (String)processedUrl + DSP_PATH;
        }
        return processedUrl;
    }

    @CacheEvict(value={"connector_endpoint_service_cache"}, allEntries=true)
    @Scheduled(fixedRateString="${irs-edc-client.connectorEndpointService.cacheTTL}")
    public void evictCachesValues() {
        log.debug("Clearing \"{}\" cache.", (Object)CONNECTOR_ENDPOINT_SERVICE_CACHE_NAME);
    }

    @Generated
    public DiscoveryFinderClient getDiscoveryFinderClient() {
        return this.discoveryFinderClient;
    }

    @Generated
    public String getDiscoveryType() {
        return this.discoveryType;
    }

    @Generated
    public ConnectorEndpointsService(DiscoveryFinderClient discoveryFinderClient, String discoveryType) {
        this.discoveryFinderClient = discoveryFinderClient;
        this.discoveryType = discoveryType;
    }
}

