/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.extras.pack200.mojo;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.tycho.extras.pack200.Pack200Archiver;

@Mojo(name="normalize", defaultPhase=LifecyclePhase.PACKAGE)
public class Pack200NormalizeMojo
extends AbstractMojo {
    @Parameter(property="project", required=true)
    private MavenProject project;
    @Parameter(property="project.build.directory", required=true)
    private File buildDirectory;
    @Parameter(alias="jarName", property="project.build.finalName", required=true)
    private String finalName;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="false")
    private boolean fork;
    @Parameter
    private List<String> supportedProjectTypes = Arrays.asList("eclipse-plugin", "eclipse-test-plugin", "jar");
    @Parameter(property="plugin.artifacts")
    private List<Artifact> pluginArtifacts;
    @Component
    private Pack200Archiver pack200;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || !this.supportedProjectTypes.contains(this.project.getPackaging())) {
            return;
        }
        File jarFile = this.project.getArtifact().getFile();
        if (!jarFile.isFile()) {
            throw new MojoExecutionException("Must at least execute ``package'' phase");
        }
        try {
            File packFile = File.createTempFile(jarFile.getName(), ".pack", this.buildDirectory);
            try {
                if (this.pack200.normalize(this.pluginArtifacts, jarFile, packFile, this.fork)) {
                    File normalizedFile = new File(this.buildDirectory, this.finalName + ".jar");
                    if (normalizedFile.exists()) {
                        normalizedFile.delete();
                    }
                    this.pack200.unpack(this.pluginArtifacts, packFile, normalizedFile, this.fork);
                    this.project.getArtifact().setFile(normalizedFile);
                }
            }
            finally {
                if (!packFile.delete()) {
                    throw new MojoExecutionException("Could not delete temporary file " + packFile.getAbsolutePath());
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not pack200 normalize jar file " + jarFile.getAbsolutePath(), (Exception)e);
        }
    }
}

