/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.extras.pack200.mojo;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.tycho.extras.pack200.Pack200Archiver;

@Mojo(name="pack", defaultPhase=LifecyclePhase.PACKAGE)
public class Pack200PackMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="project.build.directory", required=true)
    private File buildDirectory;
    @Parameter
    private List<String> supportedProjectTypes = Arrays.asList("eclipse-plugin", "eclipse-test-plugin", "jar");
    @Parameter(property="plugin.artifacts")
    private List<Artifact> pluginArtifacts;
    @Parameter(defaultValue="false")
    private boolean fork;
    @Component
    private Pack200Archiver pack200;
    @Component
    protected MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.supportedProjectTypes.contains(this.project.getPackaging())) {
            return;
        }
        File jarFile = this.project.getArtifact().getFile();
        if (!jarFile.isFile()) {
            throw new MojoExecutionException("Must at least execute ``package'' phase");
        }
        try {
            File packFile = new File(this.buildDirectory, jarFile.getName() + ".pack.gz");
            if (this.pack200.pack(this.pluginArtifacts, jarFile, packFile, this.fork)) {
                this.projectHelper.attachArtifact(this.project, "jar.pack.gz", "pack200", packFile);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not pack200 pack jar file " + jarFile.getAbsolutePath(), (Exception)e);
        }
    }
}

