/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.pomless;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.ModelParseException;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.pomless.AbstractTychoMapping;
import org.eclipse.tycho.pomless.PomReference;
import org.sonatype.maven.polyglot.mapping.Mapping;

@Component(role=Mapping.class, hint="tycho-aggregator")
public class TychoAggregatorMapping
extends AbstractTychoMapping {
    private static final String TYCHO_AUTOMATIC_GENERATED_FILE_HEADER_PREFIX = "## tycho automatic module detection";
    private static final String TYCHO_AUTOMATIC_GENERATED_FILE_HEADER = "## tycho automatic module detection " + UUID.randomUUID().toString();
    private static final String TYCHO_POM = "pom.tycho";
    private static final Set<String> COMMON_NAMES = new HashSet<String>(Arrays.asList(System.getProperty("tycho.pomless.aggregator.names", "bundles,plugins,tests,features,sites,products,releng").split(",")));

    @Override
    protected boolean isValidLocation(String location) {
        return location.endsWith(TYCHO_POM);
    }

    @Override
    protected File getPrimaryArtifact(File dir) {
        File file = new File(dir, TYCHO_POM);
        if (file.exists() && this.isCurrent(file)) {
            return file;
        }
        if (COMMON_NAMES.contains(dir.getName().toLowerCase())) {
            this.logger.debug("Scanning folder " + dir + " for modules");
            File[] subFolders = dir.listFiles(File::isDirectory);
            if (subFolders != null) {
                TreeSet<String> modules = new TreeSet<String>();
                for (File subfolder : subFolders) {
                    PomReference reference = this.locatePomReference(subfolder, null);
                    if (reference == null) continue;
                    String name = subfolder.getName();
                    modules.add(name);
                    this.logger.debug("Found pom " + reference.getPomFile().getName() + " in subfolder " + name);
                }
                if (!modules.isEmpty()) {
                    file.deleteOnExit();
                    try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.getPrimaryArtifactCharset()));){
                        writer.write(TYCHO_AUTOMATIC_GENERATED_FILE_HEADER);
                        writer.newLine();
                        for (String module : modules) {
                            writer.write(module);
                            writer.newLine();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException("writing modules file failed", e);
                    }
                    return file;
                }
            }
        } else {
            this.logger.debug("Skip folder " + dir + " because it does not match any common name " + COMMON_NAMES);
        }
        return null;
    }

    @Override
    protected String getPackaging() {
        return "pom";
    }

    @Override
    protected void initModel(Model model, Reader artifactReader, File artifactFile) throws ModelParseException, IOException {
        this.logger.debug("Generate aggregator pom for " + artifactFile);
        try (BufferedReader reader = new BufferedReader(artifactReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#") || line.trim().isEmpty()) continue;
                this.logger.debug("Adding module " + line);
                model.getModules().add(line);
            }
            model.setArtifactId(artifactFile.getParentFile().getName());
            model.setName("[aggregator] " + model.getArtifactId());
        }
    }

    @Override
    public float getPriority() {
        return -10.0f;
    }

    private boolean isCurrent(File file) {
        boolean bl;
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.getPrimaryArtifactCharset()), TYCHO_AUTOMATIC_GENERATED_FILE_HEADER.length() * 2);
        try {
            String readLine = reader.readLine();
            bl = readLine == null || !readLine.startsWith(TYCHO_AUTOMATIC_GENERATED_FILE_HEADER_PREFIX) || readLine.equals(TYCHO_AUTOMATIC_GENERATED_FILE_HEADER);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return true;
            }
        }
        reader.close();
        return bl;
    }
}

