/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.pomless;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.io.ModelParseException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.tycho.pomless.AbstractXMLTychoMapping;
import org.sonatype.maven.polyglot.mapping.Mapping;
import org.w3c.dom.Element;

@Component(role=Mapping.class, hint="eclipse-repository")
public class TychoRepositoryMapping
extends AbstractXMLTychoMapping {
    private static final String ARCHIVE_PRODUCTS_ID = "archive-products";
    private static final String MATERIALIZE_PRODUCTS_ID = "materialize-products";
    private static final String[] PRODUCT_EXECUTIONS = new String[]{"archive-products", "materialize-products"};
    private static final String PRODUCT_NAME_PREFIX = "[product] ";
    private static final String PRODUCT_NAME_ATTRIBUTE = "name";
    private static final String PRODUCT_VERSION_ATTRIBUTE = "version";
    private static final String PRODUCT_UID_ATTRIBUTE = "uid";
    private static final String CATEGORY_XML = "category.xml";
    private static final String PRODUCT_EXTENSION = ".product";
    public static final String PACKAGING = "eclipse-repository";
    private static final String UPDATE_SITE_SUFFIX = ".eclipse-repository";

    @Override
    protected String getPackaging() {
        return PACKAGING;
    }

    @Override
    protected void initModel(Model model, Reader artifactReader, File artifactFile) throws ModelParseException, IOException {
        File projectRoot;
        File[] products;
        if (artifactFile.getName().endsWith(PRODUCT_EXTENSION) && (products = TychoRepositoryMapping.listProducts(projectRoot = artifactFile.getParentFile())).length > 1) {
            model.setArtifactId(projectRoot.getName());
            Plugin directorPlugin = TychoRepositoryMapping.createDirectorPlugin(model);
            ArrayList<String> names = new ArrayList<String>();
            for (File file : products) {
                Element productXml = TychoRepositoryMapping.parseXML(new FileReader(file, this.getPrimaryArtifactCharset()), file.toURI().toASCIIString());
                String baseName = FilenameUtils.getBaseName((String)file.getName());
                String name = TychoRepositoryMapping.getXMLAttributeValue(productXml, PRODUCT_NAME_ATTRIBUTE);
                if (name == null) {
                    names.add(baseName);
                } else {
                    names.add(name);
                }
                TychoRepositoryMapping.addProduct(directorPlugin, productXml, baseName);
            }
            model.setName(PRODUCT_NAME_PREFIX + String.join((CharSequence)", ", names));
            return;
        }
        super.initModel(model, artifactReader, artifactFile);
    }

    @Override
    protected void initModelFromXML(Model model, Element xml, File artifactFile) throws ModelParseException, IOException {
        if (artifactFile.getName().endsWith(PRODUCT_EXTENSION)) {
            String name;
            model.setArtifactId(TychoRepositoryMapping.getRequiredXMLAttributeValue(xml, PRODUCT_UID_ATTRIBUTE));
            String version = TychoRepositoryMapping.getXMLAttributeValue(xml, PRODUCT_VERSION_ATTRIBUTE);
            if (version != null) {
                model.setVersion(TychoRepositoryMapping.getPomVersion(version));
            }
            if ((name = TychoRepositoryMapping.getXMLAttributeValue(xml, PRODUCT_NAME_ATTRIBUTE)) != null) {
                model.setName(PRODUCT_NAME_PREFIX + name);
            } else {
                model.setName(PRODUCT_NAME_PREFIX + model.getArtifactId());
            }
            TychoRepositoryMapping.addProduct(TychoRepositoryMapping.createDirectorPlugin(model), xml, null);
        } else {
            this.initFromCategory(model, xml, artifactFile);
        }
    }

    private void initFromCategory(Model model, Element xml, File categoryXml) {
        Object name = categoryXml.getParentFile().getName();
        if (!((String)name).endsWith(UPDATE_SITE_SUFFIX)) {
            name = (String)name + UPDATE_SITE_SUFFIX;
        }
        model.setArtifactId((String)name);
        model.setName("[updatesite] " + (String)name);
    }

    @Override
    protected boolean isValidLocation(String location) {
        return location.endsWith(PRODUCT_EXTENSION) || location.endsWith(CATEGORY_XML);
    }

    @Override
    protected File getPrimaryArtifact(File projectRoot) {
        File category;
        File[] productFiles = TychoRepositoryMapping.listProducts(projectRoot);
        if (productFiles.length > 0) {
            for (File file : productFiles) {
                if (!file.isFile()) continue;
                return file;
            }
        }
        if ((category = new File(projectRoot, CATEGORY_XML)).exists()) {
            return category;
        }
        return null;
    }

    public static void addProduct(Plugin directorPlugin, Element productXml, String attachId) throws ModelParseException {
        Map map = directorPlugin.getExecutionsAsMap();
        for (String executionId : PRODUCT_EXECUTIONS) {
            Xpp3Dom products;
            PluginExecution pluginExecution = map.computeIfAbsent(executionId, required -> {
                throw new IllegalArgumentException(required + " PluginExecution is missing");
            });
            Xpp3Dom config = (Xpp3Dom)pluginExecution.getConfiguration();
            if (config == null) {
                config = new Xpp3Dom("configuration");
                pluginExecution.setConfiguration((Object)config);
            }
            if ((products = config.getChild("products")) == null) {
                products = new Xpp3Dom("products");
                config.addChild(products);
            }
            Xpp3Dom product = new Xpp3Dom("product");
            Xpp3Dom id = new Xpp3Dom("id");
            id.setValue(TychoRepositoryMapping.getRequiredXMLAttributeValue(productXml, PRODUCT_UID_ATTRIBUTE));
            product.addChild(id);
            if (attachId != null) {
                Xpp3Dom attach = new Xpp3Dom("attachId");
                attach.setValue(attachId);
                product.addChild(attach);
            }
            products.addChild(product);
        }
    }

    public static Plugin createDirectorPlugin(Model model) {
        Build build = model.getBuild();
        if (build == null) {
            build = new Build();
            model.setBuild(build);
        }
        Plugin plugin = new Plugin();
        plugin.setArtifactId("tycho-p2-director-plugin");
        plugin.setGroupId("org.eclipse.tycho");
        build.addPlugin(plugin);
        PluginExecution materialize = new PluginExecution();
        materialize.setId(MATERIALIZE_PRODUCTS_ID);
        materialize.setGoals(Arrays.asList(MATERIALIZE_PRODUCTS_ID));
        plugin.addExecution(materialize);
        PluginExecution archive = new PluginExecution();
        archive.setId(ARCHIVE_PRODUCTS_ID);
        archive.setGoals(Arrays.asList(ARCHIVE_PRODUCTS_ID));
        plugin.addExecution(archive);
        return plugin;
    }

    public static File[] listProducts(File projectRoot) {
        File[] productFiles = projectRoot.listFiles((dir, name) -> name.endsWith(PRODUCT_EXTENSION) && !name.startsWith(".polyglot"));
        if (productFiles == null) {
            return new File[0];
        }
        return productFiles;
    }
}

