/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.pomless;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.ModelParseException;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.pomless.AbstractXMLTychoMapping;
import org.sonatype.maven.polyglot.mapping.Mapping;
import org.w3c.dom.Element;

@Component(role=Mapping.class, hint="eclipse-target-definition")
public class TychoTargetMapping
extends AbstractXMLTychoMapping {
    private static final String NAME_PREFIX = "[target] ";
    private static final String TARGET_EXTENSION = ".target";
    public static final String PACKAGING = "eclipse-target-definition";

    @Override
    protected String getPackaging() {
        return PACKAGING;
    }

    @Override
    protected boolean isValidLocation(String location) {
        return location.endsWith(TARGET_EXTENSION);
    }

    @Override
    protected File getPrimaryArtifact(File dir) {
        File file = new File(dir, dir.getName() + TARGET_EXTENSION);
        if (file.exists()) {
            return file;
        }
        File[] listFiles = dir.listFiles(file1 -> file1.getName().endsWith(TARGET_EXTENSION) && !file1.getName().startsWith(".polyglot.") && file1.isFile());
        if (listFiles != null && listFiles.length > 0) {
            if (listFiles.length == 1) {
                return listFiles[0];
            }
            String sb = Arrays.stream(listFiles).map(File::getName).collect(Collectors.joining(", "));
            throw new IllegalArgumentException("only one .target file is allowed per target project, or target must be named like the folder (<foldername>.target), the following targets where found: " + sb);
        }
        return null;
    }

    @Override
    protected void initModelFromXML(Model model, Element xml, File artifactFile) throws ModelParseException, IOException {
        String fileName = artifactFile.getName();
        String artifactId = fileName.substring(0, fileName.length() - TARGET_EXTENSION.length());
        model.setArtifactId(artifactId);
        String name = TychoTargetMapping.getXMLAttributeValue(xml, "name");
        if (name != null) {
            model.setName(NAME_PREFIX + name);
        } else {
            model.setName(NAME_PREFIX + artifactId);
        }
    }
}

