/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.pomless;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.io.ModelParseException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.tycho.pomless.AbstractTychoMapping;
import org.sonatype.maven.polyglot.mapping.Mapping;

@Component(role=Mapping.class, hint="eclipse-plugin")
public class TychoBundleMapping
extends AbstractTychoMapping {
    private static final String NAME_PREFIX = "[bundle] ";
    private static final String NAME_PREFIX_TEST = "[test-bundle] ";
    public static final String META_INF_DIRECTORY = "META-INF";
    public static final String MANIFEST_MF = "MANIFEST.MF";
    public static final String PACKAGING = "eclipse-plugin";
    private static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private static final String PACKAGING_TEST = "eclipse-test-plugin";

    @Override
    protected String getPackaging() {
        return PACKAGING;
    }

    public float getPriority() {
        return 40.0f;
    }

    @Override
    protected boolean isValidLocation(Path polyglotFile) {
        return TychoBundleMapping.getFileName(polyglotFile).equals(META_INF_DIRECTORY) && Files.isRegularFile(polyglotFile.resolve(MANIFEST_MF), new LinkOption[0]);
    }

    @Override
    protected File getPrimaryArtifact(File dir) {
        File metaInfDirectory = new File(dir, META_INF_DIRECTORY);
        if (new File(metaInfDirectory, MANIFEST_MF).isFile()) {
            return metaInfDirectory;
        }
        return null;
    }

    @Override
    protected void initModel(Model model, Reader artifactReader, Path artifactFile) throws IOException {
        Path bndFile;
        String description;
        String prefix;
        Path bundleRoot = artifactFile.getParent();
        Path manifestFile = artifactFile.resolve(MANIFEST_MF);
        Attributes manifestHeaders = this.readManifestHeaders(manifestFile);
        String bundleSymbolicName = this.getBundleSymbolicName(manifestHeaders, manifestFile);
        model.setArtifactId(bundleSymbolicName);
        String bundleVersion = this.getRequiredHeaderValue("Bundle-Version", manifestHeaders, manifestFile);
        model.setVersion(this.getPomVersion(bundleVersion));
        if (this.isTestBundle(bundleSymbolicName, bundleRoot)) {
            model.setPackaging(PACKAGING_TEST);
            prefix = NAME_PREFIX_TEST;
        } else {
            prefix = NAME_PREFIX;
        }
        Path l10nFile = TychoBundleMapping.getBundleLocalizationPropertiesFile(manifestHeaders, manifestFile);
        Supplier<Properties> properties = TychoBundleMapping.getPropertiesSupplier(l10nFile);
        String bundleName = TychoBundleMapping.getManifestAttributeValue(manifestHeaders, "Bundle-Name", properties);
        model.setName(prefix + (bundleName != null ? bundleName : bundleSymbolicName));
        String vendorName = TychoBundleMapping.getManifestAttributeValue(manifestHeaders, "Bundle-Vendor", properties);
        if (vendorName != null) {
            Organization organization = new Organization();
            organization.setName(vendorName);
            model.setOrganization(organization);
        }
        if ((description = TychoBundleMapping.getManifestAttributeValue(manifestHeaders, "Bundle-Description", properties)) != null) {
            model.setDescription(description);
        }
        if (Files.isRegularFile(bndFile = bundleRoot.resolve("bnd.bnd"), new LinkOption[0])) {
            TychoBundleMapping.createBndPlugin(model);
        }
    }

    @Override
    protected Properties getEnhancementProperties(Path file) throws IOException {
        if (TychoBundleMapping.getFileName(file).equals(META_INF_DIRECTORY) && Files.isDirectory(file, new LinkOption[0])) {
            return TychoBundleMapping.getBuildProperties(file.getParent());
        }
        return super.getEnhancementProperties(file);
    }

    private static Plugin createBndPlugin(Model model) {
        Build build = model.getBuild();
        if (build == null) {
            build = new Build();
            model.setBuild(build);
        }
        Plugin plugin = new Plugin();
        plugin.setGroupId("biz.aQute.bnd");
        plugin.setArtifactId("bnd-maven-plugin");
        build.addPlugin(plugin);
        PluginExecution process = new PluginExecution();
        process.setId("bnd-process");
        process.setGoals(Arrays.asList("bnd-process"));
        plugin.addExecution(process);
        Xpp3Dom config = new Xpp3Dom("configuration");
        process.setConfiguration((Object)config);
        Xpp3Dom packagingTypes = new Xpp3Dom("packagingTypes");
        packagingTypes.setValue(model.getPackaging());
        config.addChild(packagingTypes);
        Xpp3Dom manifestPath = new Xpp3Dom("manifestPath");
        manifestPath.setValue("${project.build.directory}/BND.MF");
        config.addChild(manifestPath);
        return plugin;
    }

    private Attributes readManifestHeaders(Path manifestFile) throws IOException {
        Manifest manifest = new Manifest();
        try (InputStream stream = Files.newInputStream(manifestFile, new OpenOption[0]);){
            manifest.read(stream);
        }
        return manifest.getMainAttributes();
    }

    private String getBundleSymbolicName(Attributes headers, Path manifestFile) throws ModelParseException {
        String symbolicName = this.getRequiredHeaderValue(BUNDLE_SYMBOLIC_NAME, headers, manifestFile);
        int semicolonIndex = symbolicName.indexOf(59);
        if (semicolonIndex > 0) {
            symbolicName = symbolicName.substring(0, semicolonIndex);
        }
        return symbolicName;
    }

    private String getRequiredHeaderValue(String headerKey, Attributes headers, Path manifestFile) throws ModelParseException {
        String value = headers.getValue(headerKey);
        if (value == null) {
            throw new ModelParseException("Required header " + headerKey + " missing in " + manifestFile, -1, -1);
        }
        return value;
    }

    private boolean isTestBundle(String bundleSymbolicName, Path bundleRoot) throws IOException {
        Properties buildProperties = TychoBundleMapping.getBuildProperties(bundleRoot);
        String packagingProperty = buildProperties.getProperty("pom.model.packaging");
        if (PACKAGING.equalsIgnoreCase(packagingProperty)) {
            return false;
        }
        if (PACKAGING_TEST.equalsIgnoreCase(packagingProperty)) {
            return true;
        }
        return bundleSymbolicName.endsWith(".tests") || bundleSymbolicName.endsWith(".test");
    }

    private static String getManifestAttributeValue(Attributes headers, String attributeName, Supplier<Properties> localizationProperties) {
        String rawValue = headers.getValue(attributeName);
        String localizedValue = TychoBundleMapping.localizedValue(rawValue, localizationProperties);
        return localizedValue != null && !localizedValue.isBlank() ? localizedValue : null;
    }

    private static Path getBundleLocalizationPropertiesFile(Attributes headers, Path manifestFile) {
        String location = headers.getValue("Bundle-Localization");
        if (location == null || location.isEmpty()) {
            location = "OSGI-INF/l10n/bundle";
        }
        return manifestFile.getParent().getParent().resolve(location + ".properties");
    }
}

