/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.pomless;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;

public class MavenConfiguation {
    private Class<?> xpp3DomClass;
    private Object xpp3;

    MavenConfiguation(Object xpp3, String elementName) {
        ClassLoader loader = MavenXpp3Writer.class.getClassLoader();
        try {
            this.xpp3DomClass = loader.loadClass("org.codehaus.plexus.util.xml.Xpp3Dom");
            if (xpp3 == null) {
                xpp3 = this.xpp3DomClass.getConstructor(String.class).newInstance(elementName);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("can't create Xpp3Dom instance!", e);
        }
        this.xpp3 = xpp3;
    }

    public Object getXpp3() {
        return this.xpp3;
    }

    public MavenConfiguation addChild(String child) {
        MavenConfiguation childConfiguation = new MavenConfiguation(null, child);
        try {
            Method method = this.xpp3DomClass.getMethod("addChild", this.xpp3DomClass);
            method.invoke(this.getXpp3(), childConfiguation.getXpp3());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("can't add Xpp3Dom child!", e);
        }
        return childConfiguation;
    }

    public MavenConfiguation getChild(String child) {
        try {
            Method method = this.xpp3DomClass.getMethod("getChild", String.class);
            Object existing = method.invoke(this.getXpp3(), child);
            if (existing == null) {
                return this.addChild(child);
            }
            return new MavenConfiguation(existing, child);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("can't add Xpp3Dom child!", e);
        }
    }

    public void setValue(String value) {
        try {
            Method method = this.xpp3DomClass.getMethod("setValue", String.class);
            method.invoke(this.getXpp3(), value);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("can't add Xpp3Dom child!", e);
        }
    }

    public String toString() {
        return this.getXpp3().toString();
    }
}

