/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.pomless;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.maven.model.Model;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.pomless.AbstractTychoMapping;
import org.eclipse.tycho.pomless.PomReference;
import org.sonatype.maven.polyglot.mapping.Mapping;

@Component(role=Mapping.class, hint="tycho-aggregator")
public class TychoAggregatorMapping
extends AbstractTychoMapping {
    private static final String TYCHO_AUTOMATIC_GENERATED_FILE_HEADER_PREFIX = "## tycho automatic module detection";
    private static final String TYCHO_AUTOMATIC_GENERATED_FILE_HEADER = "## tycho automatic module detection " + UUID.randomUUID().toString();
    private static final String TYCHO_POM = "pom.tycho";
    private static final Set<String> COMMON_NAMES = Set.of(System.getProperty("tycho.pomless.aggregator.names", "bundles,plugins,tests,features,sites,products,releng").split(","));

    @Override
    protected String getPackaging() {
        return "pom";
    }

    public float getPriority() {
        return -10.0f;
    }

    @Override
    protected boolean isValidLocation(Path location) {
        return TychoAggregatorMapping.getFileName(location).equals(TYCHO_POM);
    }

    @Override
    protected File getPrimaryArtifact(File dir) {
        File file = new File(dir, TYCHO_POM);
        if (file.exists() && this.isCurrent(file)) {
            return file;
        }
        if (COMMON_NAMES.contains(dir.getName().toLowerCase())) {
            this.logger.debug("Scanning folder " + dir + " for modules");
            TreeSet<String> modules = new TreeSet<String>();
            try (DirectoryStream<Path> subFolders2 = Files.newDirectoryStream(dir.toPath(), x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
                for (Path subfolder : subFolders2) {
                    PomReference reference = this.locatePomReference(subfolder, null);
                    if (reference == null) continue;
                    String name = TychoAggregatorMapping.getFileName(subfolder);
                    modules.add(name);
                    this.logger.debug("Found pom " + reference.getPomFile().getName() + " in subfolder " + name);
                }
            }
            catch (IOException subFolders2) {
                // empty catch block
            }
            if (!modules.isEmpty()) {
                file.deleteOnExit();
                Stream<String> lines = Stream.concat(Stream.of(TYCHO_AUTOMATIC_GENERATED_FILE_HEADER), modules.stream());
                try {
                    Files.write(file.toPath(), lines::iterator, this.getPrimaryArtifactCharset(), new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException("writing modules file failed", e);
                }
                return file;
            }
        } else {
            this.logger.debug("Skip folder " + dir + " because it does not match any common name " + COMMON_NAMES);
        }
        return null;
    }

    @Override
    protected void initModel(Model model, Reader artifactReader, Path artifactFile) throws IOException {
        this.logger.debug("Generate aggregator pom for " + artifactFile);
        try (BufferedReader reader = new BufferedReader(artifactReader);){
            Stream<String> lines = reader.lines().filter(l -> !l.startsWith("#") && !l.isBlank()).map(String::strip);
            Iterator iterator = lines.iterator();
            while (iterator.hasNext()) {
                String line = (String)iterator.next();
                this.logger.debug("Adding module " + line);
                model.getModules().add(line);
            }
            model.setArtifactId(TychoAggregatorMapping.getFileName(artifactFile.getParent()));
            model.setName("[aggregator] " + model.getArtifactId());
        }
    }

    private boolean isCurrent(File file) {
        boolean bl;
        block8: {
            Stream<String> lines = Files.lines(file.toPath(), this.getPrimaryArtifactCharset());
            try {
                String firstLine = lines.findFirst().orElse(null);
                boolean bl2 = bl = firstLine == null || !firstLine.startsWith(TYCHO_AUTOMATIC_GENERATED_FILE_HEADER_PREFIX) || firstLine.equals(TYCHO_AUTOMATIC_GENERATED_FILE_HEADER);
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return true;
                }
            }
            lines.close();
        }
        return bl;
    }
}

