/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.pomless;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.cli.internal.extension.model.CoreExtension;
import org.apache.maven.cli.internal.extension.model.io.xpp3.CoreExtensionsXpp3Reader;
import org.apache.maven.execution.MavenSession;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="TychoPomlessLifecycleParticipant")
public class TychoPomlessLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    @Requirement
    protected Logger logger;

    public void afterSessionStart(MavenSession session) throws MavenExecutionException {
        File moduleProjectDirectory = session.getRequest().getMultiModuleProjectDirectory();
        if (moduleProjectDirectory != null) {
            File extensionsFile = new File(moduleProjectDirectory, ".mvn/extensions.xml");
            try (FileInputStream is = new FileInputStream(extensionsFile);){
                List extensions = new CoreExtensionsXpp3Reader().read((InputStream)is).getExtensions();
                for (CoreExtension coreExtension : extensions) {
                    if (!"org.eclipse.tycho.extras".equals(coreExtension.getGroupId()) || !"tycho-pomless".equals(coreExtension.getArtifactId())) continue;
                    this.logger.warn("org.eclipse.tycho.extras:tycho-pomless build extension will be replaced in a future version of Tycho by the new org.eclipse.tycho:tycho-build extension.");
                    this.logger.warn("You can simply change your .mvn/extensions.xml to reference the new extension right now:");
                    this.logger.warn("<extension>");
                    this.logger.warn("   <groupId>org.eclipse.tycho</groupId>");
                    this.logger.warn("   <artifactId>tycho-build</artifactId>");
                    this.logger.warn("   <version>" + coreExtension.getVersion() + "</version>");
                    this.logger.warn("</extension>");
                    break;
                }
            }
            catch (IOException | XmlPullParserException throwable) {
                // empty catch block
            }
        }
    }
}

