/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versionbump;

import de.pdark.decentxml.Element;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Period;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.tycho.core.MarkdownBuilder;
import org.eclipse.tycho.p2resolver.TargetDefinitionVariableResolver;
import org.eclipse.tycho.targetplatform.TargetDefinition;
import org.eclipse.tycho.versionbump.UpdateTargetMojo;

@Named
public class InstallableUnitLocationUpdater {
    private static final String EMPTY_VERSION = "0.0.0";
    private static final Pattern DEFAULT_VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)");
    private static final Pattern DEFAULT_DATE_PATTERN = Pattern.compile("(\\d{4}-\\d{2})");
    private static final Period DEFAULT_PERIOD = Period.ofMonths(3).plusDays(7L);
    private static final SimpleDateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM");
    private static final String VERSION_PATTERN_PREFIX = "versionPattern";
    private static final String DATE_PATTERN_PREFIX = "datePattern";
    @Inject
    private TargetDefinitionVariableResolver varResolver;
    @Inject
    private IProvisioningAgent agent;

    boolean update(Element iuLocation, UpdateTargetMojo context) throws MojoFailureException, URISyntaxException, ProvisionException {
        Log log = context.getLog();
        ResolvedRepository location = this.getResolvedLocation(iuLocation);
        log.info((CharSequence)("Check " + location.getLocation() + " for updates..."));
        List<IU> units = iuLocation.getChildren("unit").stream().map(unit -> new IU(unit.getAttributeValue("id"), this.getUnitVersion((Element)unit), (Element)unit)).toList();
        IMetadataRepositoryManager repositoryManager = (IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.class);
        URI currentLocation = new URI(location.location());
        IMetadataRepository currentRepository = null;
        MetadataRepositoryUpdate updateRepository = this.getMetadataRepository(location, context, units, repositoryManager);
        boolean updated = updateRepository.updateLocation(location);
        ArrayList<VersionUpdate> updates = new ArrayList<VersionUpdate>();
        for (Element unit2 : iuLocation.getChildren("unit")) {
            String id = unit2.getAttributeValue("id");
            String currentVersion = this.getUnitVersion(unit2);
            if (this.isVersionRange(currentVersion)) continue;
            IInstallableUnit latestUnit = updateRepository.update().query(QueryUtil.createLatestQuery((IQuery)QueryUtil.createIUQuery((String)id)), null).stream().findFirst().orElse(null);
            if (latestUnit != null) {
                Version version;
                if (EMPTY_VERSION.equals(currentVersion) && !context.isUpdateEmptyVersion()) continue;
                String newVersion = latestUnit.getVersion().toString();
                if (newVersion.equals(currentVersion)) {
                    log.debug((CharSequence)("unit '" + id + "' is already up-to date"));
                    continue;
                }
                if (currentRepository == null) {
                    currentRepository = repositoryManager.loadRepository(currentLocation, null);
                }
                try {
                    version = Version.create((String)currentVersion);
                }
                catch (IllegalArgumentException iae) {
                    log.error((CharSequence)("Can't parse current version '" + currentVersion + "' for IU '" + id + "'"));
                    continue;
                }
                IInstallableUnit currentIU = currentRepository.query(QueryUtil.createIUQuery((String)id, (Version)version), null).stream().findFirst().orElse(null);
                VersionUpdate update = new VersionUpdate(id, currentVersion, currentIU, latestUnit);
                if (!update.hasVersionChange() || !InstallableUnitLocationUpdater.isCompatibleChange(update, context)) continue;
                log.info((CharSequence)("Update version of unit '" + id + "' from " + update.getPreviousVersion() + " > " + newVersion));
                updates.add(update);
                updated = true;
                unit2.setAttribute("version", newVersion);
                continue;
            }
            log.warn((CharSequence)("Resolution result does not contain root installable unit '" + id + "' update is skipped!"));
        }
        MarkdownBuilder builder = context.builder;
        if (updates.isEmpty()) {
            if (updateRepository.hasUpdate(currentLocation)) {
                builder.h3("The location " + location.location() + " was updated:");
                builder.addListItem("Location changed to " + String.valueOf(updateRepository.uri()));
                builder.newLine();
            }
            return updated;
        }
        if (updateRepository.hasUpdate(currentLocation)) {
            builder.h3("The location " + location.location() + " was updated:");
            builder.addListItem("Location changed to " + String.valueOf(updateRepository.uri()));
        } else {
            builder.h3("The content of the location " + location.location() + " was updated:");
        }
        for (VersionUpdate versionUpdate : updates) {
            InstallableUnitLocationUpdater.describeUpdate(versionUpdate, builder);
        }
        builder.newLine();
        return updated;
    }

    private boolean isVersionRange(String version) {
        return version != null && (version.startsWith("[") || version.startsWith("("));
    }

    private String getUnitVersion(Element unit) {
        String value = unit.getAttributeValue("version");
        if (value == null || value.isBlank()) {
            return EMPTY_VERSION;
        }
        return value;
    }

    private MetadataRepositoryUpdate getMetadataRepository(ResolvedRepository location, UpdateTargetMojo context, List<IU> units, IMetadataRepositoryManager repositoryManager) throws URISyntaxException, ProvisionException {
        Log log = context.getLog();
        log.debug((CharSequence)("Look for updates of location " + location.getLocation()));
        String raw = location.getLocation();
        URI uri = new URI(raw);
        List<String> discovery = context.getUpdateSiteDiscovery();
        for (String strategy : discovery) {
            Matcher matcher;
            SimpleDateFormat format;
            Period period;
            Pattern pattern;
            String substring;
            String trim = strategy.trim();
            if (trim.equals("parent")) {
                Collection<URI> children;
                Object str = uri.toASCIIString();
                if (!((String)str).endsWith("/")) {
                    str = (String)str + "/";
                }
                URI parentURI = new URI((String)str + "../");
                try {
                    children = InstallableUnitLocationUpdater.getChildren(repositoryManager.loadRepository(parentURI, null));
                }
                catch (ProvisionException e) {
                    log.debug((CharSequence)("No parent repository found for location " + String.valueOf(uri) + " using " + String.valueOf(parentURI) + ": " + String.valueOf((Object)e)));
                    continue;
                }
                MetadataRepositoryUpdate bestLocation = this.findBestLocation(context, units, location, repositoryManager, children);
                if (bestLocation == null) continue;
                return bestLocation;
            }
            if (trim.startsWith(VERSION_PATTERN_PREFIX)) {
                substring = trim.substring(VERSION_PATTERN_PREFIX.length());
                pattern = substring.isEmpty() ? DEFAULT_VERSION_PATTERN : Pattern.compile(substring.substring(1));
                log.debug((CharSequence)("Using Pattern " + String.valueOf(pattern) + " to find version increments..."));
                Collection<URI> fromPattern = InstallableUnitLocationUpdater.findUpdatesitesFromPattern(raw, pattern, repositoryManager, arg_0 -> ((Log)log).debug(arg_0));
                if (fromPattern.isEmpty()) {
                    log.debug((CharSequence)("Nothing found to match the pattern " + String.valueOf(pattern) + " for location " + raw));
                    continue;
                }
                HashSet<URI> repositories = new HashSet<URI>();
                for (URI repoURI : fromPattern) {
                    log.debug((CharSequence)("Check location " + String.valueOf(repoURI) + "..."));
                    try {
                        repositories.addAll(InstallableUnitLocationUpdater.expandRepository(repoURI, repositoryManager));
                    }
                    catch (ProvisionException e) {
                        log.debug((CharSequence)("No repository found for location " + String.valueOf(repoURI) + ": " + String.valueOf((Object)e)));
                    }
                }
                MetadataRepositoryUpdate bestLocation = this.findBestLocation(context, units, location, repositoryManager, repositories);
                if (bestLocation == null) continue;
                return bestLocation;
            }
            if (!trim.startsWith(DATE_PATTERN_PREFIX)) continue;
            substring = trim.substring(DATE_PATTERN_PREFIX.length());
            if (substring.isEmpty()) {
                pattern = DEFAULT_DATE_PATTERN;
                period = DEFAULT_PERIOD;
                format = DEFAULT_DATE_FORMAT;
            } else {
                String[] parameters = substring.substring(1).split(":");
                pattern = Pattern.compile(parameters[0]);
                if (parameters.length > 1) {
                    format = new SimpleDateFormat(parameters[1]);
                    period = parameters.length > 2 ? Period.parse(parameters[2]) : DEFAULT_PERIOD;
                } else {
                    period = DEFAULT_PERIOD;
                    format = DEFAULT_DATE_FORMAT;
                }
            }
            if (!(matcher = pattern.matcher(raw)).find()) continue;
            try {
                String currentDateString = matcher.group(1);
                Date currentDate = format.parse(currentDateString);
                Date nextDate = Date.from(currentDate.toInstant().atOffset(ZoneOffset.UTC).plus(period).toInstant());
                String nextDateString = format.format(nextDate);
                String nextURL = matcher.replaceAll(nextDateString);
                log.debug((CharSequence)("Check location " + nextURL + " for updates with " + currentDateString + " > " + nextDateString + "..."));
                try {
                    MetadataRepositoryUpdate bestLocation = this.findBestLocation(context, units, location, repositoryManager, List.of(new URI(nextURL)));
                    if (bestLocation == null) continue;
                    return bestLocation;
                }
                catch (URISyntaxException e) {
                    log.warn((CharSequence)("Can't parse resulting URL " + nextURL + " as a URI: " + String.valueOf(e)));
                }
            }
            catch (ParseException e) {
                log.warn((CharSequence)("Can't parse matched pattern " + String.valueOf(pattern) + " as a date: " + String.valueOf(e)));
            }
        }
        return new MetadataRepositoryUpdate(null, repositoryManager.loadRepository(uri, null));
    }

    private MetadataRepositoryUpdate findBestLocation(UpdateTargetMojo context, List<IU> units, ResolvedRepository location, IMetadataRepositoryManager repositoryManager, Collection<URI> children) throws ProvisionException {
        List<IU> bestUnits = units;
        URI bestURI = null;
        for (URI child : children) {
            List<IU> find = InstallableUnitLocationUpdater.findBestUnits(bestUnits, repositoryManager, child, context);
            if (find == null) continue;
            bestUnits = find;
            bestURI = child;
        }
        if (bestURI != null) {
            return new MetadataRepositoryUpdate(bestURI, repositoryManager.loadRepository(bestURI, null));
        }
        return null;
    }

    private static Collection<URI> getChildren(IMetadataRepository repository) {
        try {
            Method method = repository.getClass().getDeclaredMethod("getChildren", new Class[0]);
            Object object = method.invoke((Object)repository, new Object[0]);
            if (object instanceof Collection) {
                Collection c = (Collection)object;
                return c;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return List.of();
    }

    private static boolean isCompatibleChange(VersionUpdate update, UpdateTargetMojo context) {
        return !update.isMajorChange() || context.isAllowMajorUpdates();
    }

    private static Collection<URI> expandRepository(URI uri, IMetadataRepositoryManager repositoryManager) throws ProvisionException {
        IMetadataRepository repository = repositoryManager.loadRepository(uri, null);
        Collection<URI> children = InstallableUnitLocationUpdater.getChildren(repository);
        if (children.isEmpty()) {
            return List.of(uri);
        }
        ArrayList<URI> result = new ArrayList<URI>();
        for (URI child : children) {
            result.addAll(InstallableUnitLocationUpdater.expandRepository(child, repositoryManager));
        }
        return result;
    }

    private static List<IU> findBestUnits(List<IU> units, IMetadataRepositoryManager repositoryManager, URI child, UpdateTargetMojo context) {
        IMetadataRepository childRepository;
        try {
            childRepository = repositoryManager.loadRepository(child, null);
        }
        catch (ProvisionException e) {
            context.getLog().debug((CharSequence)("Skip child " + String.valueOf(child) + " because it can not be loaded: " + String.valueOf((Object)e)));
            return null;
        }
        ArrayList<IU> list = new ArrayList<IU>();
        boolean hasLarger = false;
        for (IU iu : units) {
            IInstallableUnit unit = childRepository.query(QueryUtil.createLatestQuery((IQuery)QueryUtil.createIUQuery((String)iu.id())), null).stream().findFirst().orElse(null);
            if (unit == null) {
                context.getLog().debug((CharSequence)("Skip child " + String.valueOf(child) + " because unit " + iu.id() + " can't be found in the repository"));
                return null;
            }
            int cmp = unit.getVersion().compareTo((Object)Version.create((String)iu.version()));
            if (cmp < 0) {
                context.getLog().debug((CharSequence)("Skip child " + String.valueOf(child) + " because version of unit " + iu.id() + " in repository (" + String.valueOf(unit.getVersion()) + ") is smaller than current largest version (" + iu.version() + ")."));
                return null;
            }
            if (cmp > 0) {
                hasLarger = true;
            }
            list.add(new IU(iu.id(), unit.getVersion().toString(), iu.element()));
        }
        if (hasLarger) {
            return list;
        }
        context.getLog().debug((CharSequence)("Skip child " + String.valueOf(child) + " because it has not produced any version updates"));
        return null;
    }

    private ResolvedRepository getResolvedLocation(Element iuLocation) {
        Element element = iuLocation.getChild("repository");
        String attribute = element.getAttributeValue("location");
        String resolved = this.varResolver.resolve(attribute);
        return new ResolvedRepository(element.getAttributeValue("id"), resolved, element);
    }

    private static Collection<URI> findUpdatesitesFromPattern(String input, Pattern pattern, IMetadataRepositoryManager repositoryManager, Consumer<String> debug) {
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            int i;
            int count = matcher.groupCount();
            int[] versions = new int[count];
            String[] prefix = new String[count];
            int offset = 0;
            for (int i2 = 0; i2 < count; ++i2) {
                int g = i2 + 1;
                String group = matcher.group(g);
                int start = matcher.start(g);
                int end = matcher.end(g);
                prefix[i2] = input.substring(offset, start);
                offset = end;
                try {
                    versions[i2] = Integer.parseInt(group);
                    continue;
                }
                catch (RuntimeException e) {
                    versions[i2] = -1;
                }
            }
            LinkedHashSet<URI> uris = new LinkedHashSet<URI>();
            for (i = 0; i < versions.length; ++i) {
                if (versions[i] >= 0) continue;
                InstallableUnitLocationUpdater.buildVersionString(versions, prefix, repositoryManager, debug).ifPresent(uris::add);
                break;
            }
            for (i = versions.length - 1; i >= 0; --i) {
                Optional<URI> versionRepo;
                int v = versions[i];
                if (v <= -1) continue;
                int[] copy = (int[])versions.clone();
                for (int j = i + 1; j < versions.length; ++j) {
                    if (copy[j] <= 0) continue;
                    copy[j] = 0;
                }
                do {
                    int n = i;
                    copy[n] = copy[n] + 1;
                } while (!(versionRepo = InstallableUnitLocationUpdater.buildVersionString(copy, prefix, repositoryManager, debug)).isEmpty() && uris.add(versionRepo.get()));
            }
            return uris;
        }
        return List.of();
    }

    private static Optional<URI> buildVersionString(int[] versions, String[] prefix, IMetadataRepositoryManager repositoryManager, Consumer<String> debug) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < versions.length; ++i) {
            sb.append(prefix[i]);
            int v = versions[i];
            if (v <= -1) continue;
            sb.append(v);
        }
        String string = sb.toString();
        try {
            URI uri = new URI(string);
            try {
                repositoryManager.loadRepository(uri, null);
                return Optional.of(uri);
            }
            catch (ProvisionException e) {
                debug.accept("Candidate URI '" + String.valueOf(uri) + "' can not be loaded: " + e.getMessage());
                return Optional.empty();
            }
        }
        catch (URISyntaxException e) {
            debug.accept("Resulting candidate string '" + string + "' can not be parsed as a valid location uri: " + e.getMessage());
            return Optional.empty();
        }
    }

    private static void describeUpdate(VersionUpdate versionUpdate, MarkdownBuilder builder) {
        IInstallableUnit update = versionUpdate.update();
        builder.addListItem(String.format("Unit %s was updated from %s to %s", versionUpdate.id(), versionUpdate.getPreviousVersion(), update.getVersion()));
        IInstallableUnit current = versionUpdate.current();
        if (current != null && !current.getId().endsWith(".feature.group")) {
            Collection currentRequirements = current.getRequirements();
            for (IRequirement requirement : update.getRequirements()) {
                if (currentRequirements.contains(requirement) || requirement.getMin() <= 0) continue;
                builder.addListItem2(String.format("additionally requires %s compared to the previous version", requirement));
            }
        }
    }

    private static org.osgi.framework.Version getOSGiVersion(IInstallableUnit unit) {
        if (unit != null) {
            try {
                return org.osgi.framework.Version.parseVersion((String)unit.getVersion().toString());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return null;
    }

    private record ResolvedRepository(String id, String location, Element element) implements TargetDefinition.Repository
    {
        public String getLocation() {
            return this.location();
        }

        public String getId() {
            return this.id();
        }

        public void setLocation(URI uri) {
            this.element().setAttribute("location", uri.toString());
        }
    }

    private record MetadataRepositoryUpdate(URI uri, IMetadataRepository update) {
        public boolean updateLocation(ResolvedRepository element) {
            if (this.uri != null) {
                try {
                    if (new URI(element.getLocation()).equals(this.uri)) {
                        return false;
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                element.setLocation(this.uri);
                return true;
            }
            return false;
        }

        public boolean hasUpdate(URI other) {
            if (this.uri == null) {
                return false;
            }
            return !this.uri.equals(other);
        }
    }

    private record VersionUpdate(String id, String previousVersion, IInstallableUnit current, IInstallableUnit update) {
        public boolean hasVersionChange() {
            if (InstallableUnitLocationUpdater.EMPTY_VERSION.equals(this.previousVersion)) {
                return true;
            }
            if (this.current != null) {
                return !this.current.getVersion().equals(this.update.getVersion());
            }
            return !this.update.getVersion().toString().equals(this.previousVersion);
        }

        public boolean isMajorChange() {
            org.osgi.framework.Version currentVersion = InstallableUnitLocationUpdater.getOSGiVersion(this.current);
            org.osgi.framework.Version updateVersion = InstallableUnitLocationUpdater.getOSGiVersion(this.update);
            if (this.isVersion(currentVersion) && this.isVersion(updateVersion)) {
                return updateVersion.getMajor() > currentVersion.getMajor();
            }
            return false;
        }

        private boolean isVersion(org.osgi.framework.Version version) {
            return version != null && !org.osgi.framework.Version.emptyVersion.equals((Object)version);
        }

        public String getPreviousVersion() {
            if (this.current != null && !this.current.getVersion().toString().equals(this.update.getVersion().toString())) {
                return this.current.getVersion().toString();
            }
            return this.previousVersion;
        }
    }

    private record IU(String id, String version, Element element) {
    }
}

