/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versionbump;

import de.pdark.decentxml.Element;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.DefaultVersionsHelper;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.tycho.p2maven.tmp.BundlesAction;
import org.eclipse.tycho.versionbump.MavenVersionUpdate;
import org.eclipse.tycho.versionbump.UpdateTargetMojo;

@Named
public class MavenLocationUpdater {
    @Inject
    protected ArtifactHandlerManager artifactHandlerManager;
    @Inject
    protected RepositorySystem repositorySystem;
    @Inject
    protected Map<String, Wagon> wagonMap;

    List<MavenVersionUpdate> update(Element mavenLocation, UpdateTargetMojo context) throws VersionRangeResolutionException, ArtifactResolutionException, MojoExecutionException, VersionRetrievalException {
        VersionsHelper helper = this.getHelper(context);
        Element dependencies = mavenLocation.getChild("dependencies");
        ArrayList<MavenVersionUpdate> updates = new ArrayList<MavenVersionUpdate>();
        if (dependencies != null) {
            for (Element dependency : dependencies.getChildren("dependency")) {
                Dependency mavenDependency = MavenLocationUpdater.getDependency(dependency);
                Artifact dependencyArtifact = helper.createDependencyArtifact(mavenDependency);
                ArtifactVersions versions = helper.lookupArtifactVersions(dependencyArtifact, false);
                ArtifactVersion updateVersion = context.getSegments().map(seg -> versions.getNewestUpdateWithinSegment(Optional.of(seg), false)).filter(Objects::nonNull).findFirst().orElse(null);
                if (updateVersion == null) continue;
                String oldVersion = mavenDependency.getVersion();
                String newVersion = updateVersion.toString();
                if (newVersion.equals(oldVersion)) {
                    context.getLog().debug((CharSequence)(String.valueOf(mavenDependency) + " is already up-to date"));
                    continue;
                }
                UpdateTargetMojo.setElementValue("version", newVersion, dependency);
                context.getLog().info((CharSequence)("update " + String.valueOf(mavenDependency) + " to version " + newVersion));
                IInstallableUnit current = this.getIU(helper, dependencyArtifact);
                Dependency clone = mavenDependency.clone();
                clone.setVersion(newVersion);
                IInstallableUnit update = this.getIU(helper, helper.createDependencyArtifact(clone));
                updates.add(new MavenVersionUpdate(dependencyArtifact, newVersion, current, update));
            }
        }
        return updates;
    }

    private IInstallableUnit getIU(VersionsHelper helper, Artifact dependencyArtifact) {
        try {
            helper.resolveArtifact(dependencyArtifact, false);
            File file = dependencyArtifact.getFile();
            BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)file);
            if (bundleDescription != null) {
                IArtifactKey key = BundlesAction.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
                PublisherInfo publisherInfo = new PublisherInfo();
                publisherInfo.setArtifactOptions(1);
                return BundlesAction.createBundleIU((BundleDescription)bundleDescription, (IArtifactKey)key, (IPublisherInfo)publisherInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    VersionsHelper getHelper(UpdateTargetMojo context) throws MojoExecutionException {
        return new DefaultVersionsHelper.Builder().withArtifactHandlerManager(this.artifactHandlerManager).withRepositorySystem(this.repositorySystem).withWagonMap(this.wagonMap).withServerId("serverId").withRulesUri(context.getMavenRulesUri()).withRuleSet(context.getMavenRuleSet()).withIgnoredVersions(context.getMavenIgnoredVersions()).withLog(context.getLog()).withMavenSession(context.getMavenSession()).withMojoExecution(context.getMojoExecution()).build();
    }

    private static Dependency getDependency(Element dependency) {
        Dependency mavenDependency = new Dependency();
        mavenDependency.setGroupId(UpdateTargetMojo.getElementValue("groupId", dependency));
        mavenDependency.setArtifactId(UpdateTargetMojo.getElementValue("artifactId", dependency));
        mavenDependency.setVersion(UpdateTargetMojo.getElementValue("version", dependency));
        mavenDependency.setType(UpdateTargetMojo.getElementValue("type", dependency));
        mavenDependency.setClassifier(UpdateTargetMojo.getElementValue("classifier", dependency));
        if (mavenDependency.getType() == null) {
            mavenDependency.setType("jar");
        }
        return mavenDependency;
    }
}

