/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versionbump;

import java.util.Collection;
import org.apache.maven.artifact.Artifact;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.tycho.core.MarkdownBuilder;

record MavenVersionUpdate(Artifact currentArtifact, String newVersion, IInstallableUnit current, IInstallableUnit update) {
    public void describeUpdate(MarkdownBuilder builder) {
        String msg = String.format("`%s` has been updated to version `%s`", this.currentArtifact().getId(), this.newVersion());
        builder.addListItem(msg);
        IInstallableUnit current = this.current();
        IInstallableUnit updated = this.update();
        if (current != null && updated != null) {
            Collection currentRequirements = current.getRequirements();
            for (IRequirement requirement : this.update.getRequirements()) {
                if (currentRequirements.contains(requirement) || requirement.getMin() <= 0) continue;
                builder.addListItem2(String.format("additionally requires %s compared to the previous version", requirement));
            }
        }
    }

    public String id() {
        return this.currentArtifact().getId() + "->" + this.newVersion();
    }
}

