/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versionbump;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.tycho.DependencyArtifacts;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.model.manifest.MutableBundleManifest;
import org.eclipse.tycho.p2tools.copiedfromp2.QueryableArray;
import org.eclipse.tycho.versionbump.AbstractUpdateMojo;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

@Mojo(name="update-manifest", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class UpdateManifestMojo
extends AbstractUpdateMojo {
    @Parameter(defaultValue="${project.basedir}/META-INF/MANIFEST.MF", property="manifestFile")
    private File manifestFile;
    @Parameter(defaultValue="true", property="upper")
    private boolean addMissingUpperBounds;
    @Parameter(defaultValue="true", property="lower")
    private boolean addMissingLowerBounds;
    @Component
    private TychoProjectManager projectManager;

    @Override
    protected void doUpdate(File file) throws Exception {
        QueryableArray queryable;
        Map<String, String> updatedBundles;
        MutableBundleManifest manifest = MutableBundleManifest.read((File)file);
        DependencyArtifacts artifacts = this.projectManager.getDependencyArtifacts(this.getProject()).orElse(null);
        if (artifacts != null && !(updatedBundles = this.updateRequiredBundles(manifest, queryable = new QueryableArray(artifacts.getInstallableUnits()))).isEmpty()) {
            manifest.updateRequiredBundleVersions(updatedBundles);
            MutableBundleManifest.write((MutableBundleManifest)manifest, (File)file);
        }
    }

    private Map<String, String> updateRequiredBundles(MutableBundleManifest manifest, QueryableArray queryable) {
        HashMap<String, String> updatedBundles = new HashMap<String, String>();
        for (Map.Entry requiredBundle : manifest.getRequiredBundleVersions().entrySet()) {
            String oldValue = (String)requiredBundle.getValue();
            String bsn = (String)requiredBundle.getKey();
            IInstallableUnit unit = queryable.query(QueryUtil.createLatestQuery((IQuery)QueryUtil.createIUQuery((String)bsn)), null).stream().findFirst().orElse(null);
            if (unit == null) continue;
            Version latestVersion = Version.parseVersion((String)unit.getVersion().toString());
            String format = this.toVersionString(latestVersion);
            if (oldValue == null || oldValue.isBlank()) {
                if (this.addMissingUpperBounds && this.addMissingLowerBounds) {
                    updatedBundles.put(bsn, String.format("[%s,%d)", this.toVersionString(latestVersion), latestVersion.getMajor() + 1));
                    continue;
                }
                if (!this.addMissingLowerBounds) continue;
                updatedBundles.put(bsn, this.toVersionString(latestVersion));
                continue;
            }
            if (oldValue.startsWith("[") || oldValue.startsWith("(")) {
                String newVersionRange;
                VersionRange range = VersionRange.valueOf((String)oldValue);
                if (this.versionEqualsIgnoreQualifier(range.getLeft(), latestVersion)) continue;
                if (this.isStrict(range)) {
                    newVersionRange = String.format("[%s,%s]", format, format);
                    this.getLog().info((CharSequence)("Update strict version range of required bundle " + bsn + " from " + oldValue + " to " + newVersionRange));
                    updatedBundles.put(bsn, newVersionRange);
                    continue;
                }
                newVersionRange = String.format("[%s,%s)", format, range.getRight().toString());
                this.getLog().info((CharSequence)("Update version range of required bundle " + bsn + " from " + oldValue + " to " + newVersionRange));
                updatedBundles.put(bsn, newVersionRange);
                continue;
            }
            Version currentVersion = Version.parseVersion((String)oldValue);
            if (latestVersion.compareTo(currentVersion) > 0 && !this.versionEqualsIgnoreQualifier(currentVersion, latestVersion)) {
                this.getLog().info((CharSequence)("Update lower bound of required bundle " + bsn + " from " + oldValue + " to " + format));
                updatedBundles.put(bsn, format);
                oldValue = format;
            }
            if (!this.addMissingUpperBounds) continue;
            updatedBundles.put(bsn, String.format("[%s,%d)", oldValue, latestVersion.getMajor() + 1));
        }
        return updatedBundles;
    }

    private boolean isStrict(VersionRange range) {
        return range.isExact();
    }

    private String toVersionString(Version version) {
        return String.format("%d.%d.%d", version.getMajor(), version.getMinor(), version.getMicro());
    }

    private boolean versionEqualsIgnoreQualifier(Version v1, Version v2) {
        return v1.getMajor() == v2.getMajor() && v1.getMinor() == v2.getMinor() && v1.getMicro() == v1.getMicro();
    }

    @Override
    protected File getFileToBeUpdated() throws MojoExecutionException, MojoFailureException {
        return this.manifestFile;
    }
}

