/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versionbump;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.tycho.ExecutionEnvironmentConfiguration;
import org.eclipse.tycho.IllegalArtifactReferenceException;
import org.eclipse.tycho.MavenRepositoryLocation;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.core.ee.shared.ExecutionEnvironmentConfigurationStub;
import org.eclipse.tycho.core.resolver.P2ResolutionResult;
import org.eclipse.tycho.core.resolver.P2Resolver;
import org.eclipse.tycho.core.resolver.P2ResolverFactory;
import org.eclipse.tycho.model.PluginRef;
import org.eclipse.tycho.model.ProductConfiguration;
import org.eclipse.tycho.p2.target.facade.TargetPlatformConfigurationStub;
import org.eclipse.tycho.p2maven.repository.P2ArtifactRepositoryLayout;
import org.eclipse.tycho.versionbump.AbstractUpdateMojo;

@Mojo(name="update-product")
public class UpdateProductMojo
extends AbstractUpdateMojo {
    @Parameter(defaultValue="${project.artifactId}.product")
    private File productFile;
    @Parameter(defaultValue="JavaSE-21")
    private String executionEnvironment;
    @Component
    private P2ResolverFactory factory;

    String getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    P2Resolver createResolver() {
        return this.factory.createResolver(Collections.singletonList(TargetEnvironment.getRunningEnvironment()));
    }

    @Override
    protected void doUpdate(File file) throws IOException, URISyntaxException {
        TargetPlatformConfigurationStub resolutionContext = new TargetPlatformConfigurationStub();
        for (ArtifactRepository repository : this.getProject().getRemoteArtifactRepositories()) {
            URI uri = new URL(repository.getUrl()).toURI();
            if (!(repository.getLayout() instanceof P2ArtifactRepositoryLayout)) continue;
            resolutionContext.addP2Repository(new MavenRepositoryLocation(repository.getId(), uri));
        }
        ProductConfiguration product = ProductConfiguration.read((File)file);
        P2Resolver resolver = this.createResolver();
        for (PluginRef plugin : product.getPlugins()) {
            try {
                resolver.addDependency("eclipse-plugin", plugin.getId(), "0.0.0");
            }
            catch (IllegalArtifactReferenceException e) {
                throw new RuntimeException(e);
            }
        }
        P2ResolutionResult result = resolver.resolveMetadata(resolutionContext, (ExecutionEnvironmentConfiguration)new ExecutionEnvironmentConfigurationStub(this.getExecutionEnvironment()));
        HashMap<String, String> ius = new HashMap<String, String>();
        for (P2ResolutionResult.Entry entry : result.getArtifacts()) {
            ius.put(entry.getId(), entry.getVersion());
        }
        for (PluginRef plugin : product.getPlugins()) {
            String version = (String)ius.get(plugin.getId());
            if (version == null) continue;
            plugin.setVersion(version);
        }
        ProductConfiguration.write((ProductConfiguration)product, (File)file);
    }

    @Override
    protected File getFileToBeUpdated() {
        return this.productFile;
    }
}

