/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versionbump;

import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.XMLIOSource;
import de.pdark.decentxml.XMLParser;
import de.pdark.decentxml.XMLSource;
import de.pdark.decentxml.XMLWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.model.RuleSet;
import org.eclipse.tycho.core.MarkdownBuilder;
import org.eclipse.tycho.targetplatform.TargetPlatformArtifactResolver;
import org.eclipse.tycho.targetplatform.TargetResolveException;
import org.eclipse.tycho.versionbump.AbstractUpdateMojo;
import org.eclipse.tycho.versionbump.InstallableUnitLocationUpdater;
import org.eclipse.tycho.versionbump.MavenLocationUpdater;
import org.eclipse.tycho.versionbump.MavenVersionUpdate;

@Mojo(name="update-target")
public class UpdateTargetMojo
extends AbstractUpdateMojo {
    @Parameter(property="target")
    private File targetFile;
    @Parameter(property="allowMajorUpdates", defaultValue="true")
    private boolean allowMajorUpdates;
    @Parameter(property="allowMinorUpdates", defaultValue="true")
    private boolean allowMinorUpdates;
    @Parameter(property="allowIncrementalUpdates", defaultValue="true")
    private boolean allowIncrementalUpdates;
    @Parameter(property="allowSubIncrementalUpdates", defaultValue="true")
    private boolean allowSubIncrementalUpdates;
    @Parameter(property="discovery")
    private List<String> updateSiteDiscovery;
    @Parameter
    private RuleSet mavenRuleSet;
    @Parameter(property="maven.version.ignore")
    private Set<String> mavenIgnoredVersions;
    @Parameter(property="maven.version.rules")
    private String mavenRulesUri;
    @Parameter(defaultValue="Please review the changes and merge if appropriate, or cherry pick individual updates.", property="tycho.updatetarget.report.preamble")
    private String reportPreamble;
    @Parameter(defaultValue="${project.build.directory}/targetUpdates.md", property="tycho.updatetarget.report")
    private File reportFileName;
    @Parameter(defaultValue="true", property="tycho.updatetarget.updateEmptyVersion")
    private boolean updateEmptyVersion;
    @Component
    private MavenSession mavenSession;
    @Parameter(defaultValue="${mojoExecution}", required=true, readonly=true)
    private MojoExecution mojoExecution;
    @Inject
    private MavenLocationUpdater mavenLocationUpdater;
    @Inject
    private InstallableUnitLocationUpdater installableUnitLocationUpdater;
    MarkdownBuilder builder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doUpdate(File file) throws Exception {
        this.getLog().info((CharSequence)("Update target file " + String.valueOf(file)));
        XMLParser parser = new XMLParser();
        Document target = parser.parse((XMLSource)new XMLIOSource(file));
        boolean changed = false;
        this.builder = new MarkdownBuilder(this.reportFileName);
        this.builder.h2("The content of the target `" + file.getName() + "` was updated");
        if (this.reportPreamble != null && !this.reportPreamble.isBlank()) {
            this.builder.add(this.reportPreamble);
            this.builder.newLine();
        }
        ArrayList<MavenVersionUpdate> mavenUpdates = new ArrayList<MavenVersionUpdate>();
        try (FileInputStream input = new FileInputStream(file);){
            for (Element iuLocation : this.getLocations("InstallableUnit", target)) {
                changed |= this.installableUnitLocationUpdater.update(iuLocation, this);
            }
            for (Element mavenLocation : this.getLocations("Maven", target)) {
                mavenUpdates.addAll(this.mavenLocationUpdater.update(mavenLocation, this));
                changed |= mavenUpdates.size() > 0;
            }
        }
        if (changed) {
            String enc = target.getEncoding() != null ? target.getEncoding() : "UTF-8";
            try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), enc);
                 XMLWriter xw = new XMLWriter((Writer)w);){
                try {
                    target.toXML(xw);
                }
                finally {
                    xw.flush();
                }
            }
            if (mavenUpdates.size() > 0) {
                this.builder.h3("The following maven artifacts have been updated:");
                HashSet<String> updatedMsg = new HashSet<String>();
                for (MavenVersionUpdate update : mavenUpdates) {
                    if (!updatedMsg.add(update.id())) continue;
                    update.describeUpdate(this.builder);
                }
                this.builder.newLine();
            }
            this.builder.newLine();
            this.builder.write();
        }
        this.builder = null;
    }

    static void setElementValue(String name, String value, Element root) {
        Element child = root.getChild(name);
        if (child != null) {
            child.setText(value);
        }
    }

    static String getElementValue(String name, Element root) {
        Element child = root.getChild(name);
        if (child != null) {
            String text = child.getText().trim();
            if (text.isBlank()) {
                return null;
            }
            return text;
        }
        return null;
    }

    private List<Element> getLocations(String type, Document target) {
        Element locations = target.getRootElement().getChild("locations");
        if (locations != null) {
            return locations.getChildren().stream().filter(elem -> type.equals(elem.getAttributeValue("type"))).toList();
        }
        return List.of();
    }

    @Override
    protected File getFileToBeUpdated() throws MojoFailureException {
        if (this.targetFile == null) {
            try {
                return TargetPlatformArtifactResolver.getMainTargetFile((MavenProject)this.getProject());
            }
            catch (TargetResolveException e) {
                throw new MojoFailureException((Throwable)e);
            }
        }
        return this.targetFile;
    }

    boolean isAllowSubIncrementalUpdates() {
        return this.allowSubIncrementalUpdates;
    }

    boolean isAllowIncrementalUpdates() {
        return this.allowIncrementalUpdates;
    }

    boolean isAllowMinorUpdates() {
        return this.allowMinorUpdates;
    }

    boolean isAllowMajorUpdates() {
        return this.allowMajorUpdates;
    }

    boolean isUpdateEmptyVersion() {
        return this.updateEmptyVersion;
    }

    @Override
    MavenSession getMavenSession() {
        return this.mavenSession;
    }

    MojoExecution getMojoExecution() {
        return this.mojoExecution;
    }

    List<String> getUpdateSiteDiscovery() {
        if (this.updateSiteDiscovery == null) {
            return List.of();
        }
        return this.updateSiteDiscovery.stream().map(String::trim).toList();
    }

    Set<String> getMavenIgnoredVersions() {
        return this.mavenIgnoredVersions;
    }

    RuleSet getMavenRuleSet() {
        return this.mavenRuleSet;
    }

    String getMavenRulesUri() {
        if (this.mavenRulesUri != null && !this.mavenRulesUri.isBlank()) {
            try {
                URI u = new URI(this.mavenRulesUri);
                if (u.isAbsolute()) {
                    return this.mavenRulesUri;
                }
            }
            catch (URISyntaxException u) {
                // empty catch block
            }
            File fullPath = new File(this.mavenRulesUri);
            if (fullPath.isFile()) {
                return fullPath.toURI().toString();
            }
            File file = new File(this.getProject().getBasedir(), this.mavenRulesUri);
            if (file.exists()) {
                return file.toURI().toString();
            }
        }
        return this.mavenRulesUri;
    }

    Stream<Segment> getSegments() {
        Stream.Builder<Segment> builder = Stream.builder();
        if (this.isAllowMajorUpdates()) {
            builder.accept(Segment.MAJOR);
        }
        if (this.isAllowMinorUpdates()) {
            builder.accept(Segment.MINOR);
        }
        if (this.isAllowIncrementalUpdates()) {
            builder.accept(Segment.INCREMENTAL);
        }
        if (this.isAllowSubIncrementalUpdates()) {
            builder.accept(Segment.SUBINCREMENTAL);
        }
        return builder.build();
    }
}

