/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.publisher;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.internal.p2.publisher.eclipse.FeatureParser;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.internal.p2.updatesite.CategoryParser;
import org.eclipse.equinox.internal.p2.updatesite.SiteModel;
import org.eclipse.equinox.internal.p2.updatesite.SiteXMLAction;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.actions.IFeatureRootAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;
import org.eclipse.equinox.p2.publisher.eclipse.ProductAction;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.tycho.core.resolver.shared.OptionalResolutionAction;
import org.eclipse.tycho.p2.impl.publisher.AbstractMetadataGenerator;
import org.eclipse.tycho.p2.impl.publisher.BundleDependenciesAction;
import org.eclipse.tycho.p2.impl.publisher.CategoryDependenciesAction;
import org.eclipse.tycho.p2.impl.publisher.DependencyMetadata;
import org.eclipse.tycho.p2.impl.publisher.FeatureDependenciesAction;
import org.eclipse.tycho.p2.impl.publisher.MavenPropertiesAdvice;
import org.eclipse.tycho.p2.impl.publisher.ProductDependenciesAction;
import org.eclipse.tycho.p2.impl.publisher.SiteDependenciesAction;
import org.eclipse.tycho.p2.impl.publisher.TychoBundleAction;
import org.eclipse.tycho.p2.impl.publisher.model.ProductFile2;
import org.eclipse.tycho.p2.impl.publisher.repo.FeatureRootfileArtifactRepository;
import org.eclipse.tycho.p2.impl.publisher.repo.TransientArtifactRepository;
import org.eclipse.tycho.p2.impl.publisher.rootfiles.FeatureRootAdvice;
import org.eclipse.tycho.p2.maven.repository.xmlio.ArtifactsIO;
import org.eclipse.tycho.p2.maven.repository.xmlio.MetadataIO;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.eclipse.tycho.p2.metadata.P2Generator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2GeneratorImpl
extends AbstractMetadataGenerator
implements P2Generator {
    private static final String[] SUPPORTED_TYPES = new String[]{"eclipse-plugin", "eclipse-test-plugin", "eclipse-feature", "eclipse-update-site", "eclipse-application", "eclipse-repository"};
    private boolean dependenciesOnly;

    public P2GeneratorImpl(boolean dependenciesOnly) {
        this.dependenciesOnly = dependenciesOnly;
    }

    public P2GeneratorImpl() {
        this(false);
    }

    public Map<String, Set<Object>> generateMetadata(List<IArtifactFacade> artifacts, Map<String, IArtifactFacade> attachedArtifacts, File targetDir) throws IOException {
        LinkedHashMap<String, Set<Object>> result = new LinkedHashMap<String, Set<Object>>();
        LinkedHashSet<IInstallableUnit> units = new LinkedHashSet<IInstallableUnit>();
        LinkedHashSet<IArtifactDescriptor> artifactDescriptors = new LinkedHashSet<IArtifactDescriptor>();
        for (IArtifactFacade artifact : artifacts) {
            DependencyMetadata metadata;
            TransientArtifactRepository artifactsRepository;
            PublisherInfo publisherInfo = new PublisherInfo();
            if ("eclipse-feature".equals(artifact.getPackagingType())) {
                publisherInfo.setArtifactOptions(11);
                artifactsRepository = new FeatureRootfileArtifactRepository(publisherInfo, targetDir);
                publisherInfo.setArtifactRepository((IArtifactRepository)artifactsRepository);
                metadata = super.generateMetadata(artifact, null, publisherInfo, null);
                attachedArtifacts.putAll(((FeatureRootfileArtifactRepository)artifactsRepository).getPublishedArtifacts());
            } else {
                publisherInfo.setArtifactOptions(8);
                artifactsRepository = new TransientArtifactRepository();
                publisherInfo.setArtifactRepository((IArtifactRepository)artifactsRepository);
                metadata = super.generateMetadata(artifact, null, publisherInfo, null);
            }
            units.addAll(metadata.getInstallableUnits());
            artifactDescriptors.addAll(metadata.getArtifactDescriptors());
            result.put(artifact.getClassidier(), new LinkedHashSet<IInstallableUnit>(metadata.getInstallableUnits()));
        }
        new MetadataIO().writeXML(units, attachedArtifacts.get("p2metadata").getLocation());
        new ArtifactsIO().writeXML(artifactDescriptors, attachedArtifacts.get("p2artifacts").getLocation());
        return result;
    }

    public DependencyMetadata generateMetadata(IArtifactFacade artifact, List<Map<String, String>> environments) {
        PublisherInfo publisherInfo = new PublisherInfo();
        publisherInfo.setArtifactOptions(3);
        publisherInfo.setArtifactRepository((IArtifactRepository)new TransientArtifactRepository());
        return super.generateMetadata(artifact, environments, publisherInfo, null);
    }

    @Override
    protected List<IPublisherAction> getPublisherActions(IArtifactFacade artifact, List<Map<String, String>> environments, OptionalResolutionAction optionalAction) {
        if (!this.dependenciesOnly && optionalAction != null) {
            throw new IllegalArgumentException();
        }
        ArrayList<IPublisherAction> actions = new ArrayList<IPublisherAction>();
        String packaging = artifact.getPackagingType();
        File location = artifact.getLocation();
        if ("eclipse-plugin".equals(packaging) || "eclipse-test-plugin".equals(packaging)) {
            if (this.dependenciesOnly && optionalAction != null) {
                actions.add((IPublisherAction)new BundleDependenciesAction(location, optionalAction));
            } else {
                actions.add((IPublisherAction)new TychoBundleAction(location));
            }
        } else if ("eclipse-feature".equals(packaging)) {
            Feature feature = new FeatureParser().parse(location);
            feature.setLocation(location.getAbsolutePath());
            if (this.dependenciesOnly) {
                actions.add((IPublisherAction)new FeatureDependenciesAction(feature));
            } else {
                actions.add((IPublisherAction)new FeaturesAction(new Feature[]{feature}));
            }
        } else if ("eclipse-application".equals(packaging)) {
            String product = new File(location, String.valueOf(artifact.getArtifactId()) + ".product").getAbsolutePath();
            try {
                ProductFile2 productDescriptor = new ProductFile2(product);
                if (this.dependenciesOnly) {
                    actions.add((IPublisherAction)new ProductDependenciesAction((IProductDescriptor)productDescriptor, environments));
                }
                actions.add((IPublisherAction)new ProductAction(product, (IProductDescriptor)productDescriptor, null, null));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if ("eclipse-update-site".equals(packaging)) {
            if (this.dependenciesOnly) {
                actions.add((IPublisherAction)new SiteDependenciesAction(location, artifact.getArtifactId(), artifact.getVersion()));
            } else {
                actions.add((IPublisherAction)new SiteXMLAction(location.toURI(), null));
            }
        } else if ("eclipse-repository".equals(packaging)) {
            for (File productFile : this.getProductFiles(location)) {
                ProductFile2 productDescriptor;
                String product = productFile.getAbsolutePath();
                try {
                    productDescriptor = new ProductFile2(product);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to parse the product file " + product, e);
                }
                if (!this.dependenciesOnly) continue;
                actions.add((IPublisherAction)new ProductDependenciesAction((IProductDescriptor)productDescriptor, environments));
            }
            for (File categoryFile : this.getCategoryFiles(location)) {
                CategoryParser cp = new CategoryParser(null);
                FileInputStream ins = null;
                try {
                    try {
                        ins = new FileInputStream(categoryFile);
                        SiteModel siteModel = cp.parse((InputStream)ins);
                        actions.add((IPublisherAction)new CategoryDependenciesAction(siteModel, artifact.getArtifactId(), artifact.getVersion()));
                    }
                    finally {
                        if (ins != null) {
                            ins.close();
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to read category File", e);
                }
            }
        } else if (location.isFile() && location.getName().endsWith(".jar")) {
            actions.add((IPublisherAction)new TychoBundleAction(location));
        } else {
            throw new IllegalArgumentException("Unknown type of packaging " + packaging);
        }
        return actions;
    }

    public boolean isSupported(String type) {
        return Arrays.asList(SUPPORTED_TYPES).contains(type);
    }

    private List<File> getProductFiles(File projectLocation) {
        ArrayList<File> res = new ArrayList<File>();
        File[] fileArray = projectLocation.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isFile() && f.getName().endsWith(".product")) {
                res.add(f);
            }
            ++n2;
        }
        return res;
    }

    private List<File> getCategoryFiles(File projectLocation) {
        ArrayList<File> res = new ArrayList<File>();
        File categoryFile = new File(projectLocation, "category.xml");
        if (categoryFile.exists()) {
            res.add(categoryFile);
        }
        return res;
    }

    @Override
    protected List<IPublisherAdvice> getPublisherAdvice(IArtifactFacade artifact) {
        ArrayList<IPublisherAdvice> advice = new ArrayList<IPublisherAdvice>();
        advice.add((IPublisherAdvice)new MavenPropertiesAdvice(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getClassidier()));
        advice.add((IPublisherAdvice)this.getExtraEntriesAdvice(artifact));
        IFeatureRootAdvice featureRootAdvice = FeatureRootAdvice.createRootFileAdvice(artifact, this.getBuildPropertiesParser());
        if (featureRootAdvice != null) {
            advice.add((IPublisherAdvice)featureRootAdvice);
        }
        return advice;
    }
}

