/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.resolver;

import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.equinox.internal.p2.director.Slicer;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.tycho.core.facade.MavenLogger;
import org.eclipse.tycho.p2.impl.resolver.AbstractResolutionStrategy;
import org.eclipse.tycho.p2.impl.resolver.QueryableCollection;
import org.eclipse.tycho.p2.impl.resolver.ResolverDebugUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSlicerResolutionStrategy
extends AbstractResolutionStrategy {
    protected AbstractSlicerResolutionStrategy(MavenLogger logger) {
        super(logger);
    }

    protected IQueryable<IInstallableUnit> slice(Map<String, String> properties, IProgressMonitor monitor) {
        if (this.logger.isExtendedDebugEnabled()) {
            this.logger.debug("Properties: " + properties.toString());
            this.logger.debug("Available IUs:\n" + ResolverDebugUtils.toDebugString(this.availableIUs, false));
            this.logger.debug("JRE IUs:\n" + ResolverDebugUtils.toDebugString(this.jreIUs, false));
            this.logger.debug("Root IUs:\n" + ResolverDebugUtils.toDebugString(this.rootIUs, true));
            if (this.additionalRequirements != null && !this.additionalRequirements.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (IRequirement req : this.additionalRequirements) {
                    sb.append("   ").append(req.toString()).append("\n");
                }
                this.logger.debug("Extra Requirements:\n" + sb.toString());
            }
        }
        LinkedHashSet<IInstallableUnit> availableIUs = new LinkedHashSet<IInstallableUnit>(this.availableIUs);
        availableIUs.addAll(this.jreIUs);
        LinkedHashSet<IInstallableUnit> seedIUs = new LinkedHashSet<IInstallableUnit>(this.rootIUs);
        if (this.additionalRequirements != null && !this.additionalRequirements.isEmpty()) {
            MetadataFactory.InstallableUnitDescription iud = new MetadataFactory.InstallableUnitDescription();
            String time = Long.toString(System.currentTimeMillis());
            iud.setId("tycho-extra-" + time);
            iud.setVersion(Version.createOSGi((int)0, (int)0, (int)0, (String)time));
            iud.setRequirements((IRequirement[])this.additionalRequirements.toArray(new IRequiredCapability[this.additionalRequirements.size()]));
            seedIUs.add(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud));
        }
        seedIUs.addAll(this.jreIUs);
        Slicer slicer = this.newSlicer((IQueryable<IInstallableUnit>)new QueryableCollection(availableIUs), properties);
        IQueryable slice = slicer.slice(seedIUs.toArray(EMPTY_IU_ARRAY), monitor);
        MultiStatus slicerStatus = slicer.getStatus();
        if (slice == null || this.isSlicerError(slicerStatus)) {
            throw this.newResolutionException((IStatus)slicer.getStatus());
        }
        if (this.logger.isExtendedDebugEnabled()) {
            this.logger.debug("Slice:\n" + ResolverDebugUtils.toDebugString((IQueryable<IInstallableUnit>)slice, false, monitor));
        }
        return slice;
    }

    protected abstract boolean isSlicerError(MultiStatus var1);

    protected abstract Slicer newSlicer(IQueryable<IInstallableUnit> var1, Map<String, String> var2);
}

