/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.publisher;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ProductFile;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.publisher.AdviceFileAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.eclipse.FeatureEntry;
import org.eclipse.tycho.core.facade.TargetEnvironment;
import org.eclipse.tycho.p2.impl.publisher.AbstractDependenciesAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductDependenciesAction
extends AbstractDependenciesAction {
    private final IProductDescriptor product;
    private final List<TargetEnvironment> environments;

    public ProductDependenciesAction(IProductDescriptor product, List<TargetEnvironment> environments) {
        this.product = product;
        this.environments = environments;
    }

    @Override
    protected Version getVersion() {
        return Version.create((String)this.product.getVersion());
    }

    @Override
    protected String getId() {
        return this.product.getId();
    }

    @Override
    protected Set<IRequirement> getRequiredCapabilities() {
        LinkedHashSet<IRequirement> required = new LinkedHashSet<IRequirement>();
        if (this.product.useFeatures()) {
            for (IVersionedId feature : this.product.getFeatures()) {
                String id = String.valueOf(feature.getId()) + ".feature.group";
                Version version = feature.getVersion();
                this.addRequiredCapability(required, id, version, null, false);
            }
        } else {
            for (FeatureEntry plugin : ((ProductFile)this.product).getProductEntries()) {
                this.addRequiredCapability(required, plugin.getId(), Version.parseVersion((String)plugin.getVersion()), null, true);
            }
        }
        if (this.product.includeLaunchers()) {
            this.addRequiredCapability(required, "org.eclipse.equinox.executable.feature.group", null, null, false);
        }
        return required;
    }

    @Override
    protected void addPublisherAdvice(IPublisherInfo publisherInfo) {
        File productFileLocation = this.product.getLocation();
        if (productFileLocation == null) {
            return;
        }
        String id = this.product.getId();
        Version parseVersion = Version.parseVersion((String)this.product.getVersion());
        Path basePath = new Path(productFileLocation.getParent());
        int indexOfExtension = productFileLocation.getName().indexOf(".product");
        String p2infFilename = String.valueOf(productFileLocation.getName().substring(0, indexOfExtension)) + ".p2.inf";
        AdviceFileAdvice advice = new AdviceFileAdvice(id, parseVersion, (IPath)basePath, (IPath)new Path(p2infFilename));
        if (advice.containsAdvice()) {
            publisherInfo.addAdvice((IPublisherAdvice)advice);
        }
    }
}

