/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.publisher.repo;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactDescriptor;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.actions.IPropertyAdvice;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.tycho.p2.impl.publisher.MavenPropertiesAdvice;
import org.eclipse.tycho.p2.impl.publisher.P2Artifact;
import org.eclipse.tycho.p2.impl.publisher.repo.TransientArtifactRepository;
import org.eclipse.tycho.p2.impl.publisher.rootfiles.FeatureRootAdvice;
import org.eclipse.tycho.p2.metadata.IP2Artifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureRootfileArtifactRepository
extends TransientArtifactRepository {
    private static final String ROOTFILE_CLASSIFIER = "root";
    private static final String ROOTFILE_EXTENSION = "zip";
    private final File outputDirectory;
    private final PublisherInfo publisherInfo;
    private Map<String, IP2Artifact> publishedArtifacts = new HashMap<String, IP2Artifact>();

    public FeatureRootfileArtifactRepository(PublisherInfo publisherInfo, File outputDirectory) {
        this.publisherInfo = publisherInfo;
        this.outputDirectory = outputDirectory;
    }

    @Override
    public OutputStream getOutputStream(IArtifactDescriptor descriptor) throws ProvisionException {
        IArtifactKey artifactKey = descriptor.getArtifactKey();
        if (artifactKey != null && "binary".equals(artifactKey.getClassifier())) {
            try {
                return this.createRootfileOutputStream(artifactKey);
            }
            catch (IOException e) {
                throw new ProvisionException(e.getMessage(), (Throwable)e);
            }
        }
        return super.getOutputStream(descriptor);
    }

    private OutputStream createRootfileOutputStream(IArtifactKey artifactKey) throws ProvisionException, IOException {
        File outputFile = new File(this.outputDirectory, String.valueOf(artifactKey.getId()) + "-" + artifactKey.getVersion() + "-" + ROOTFILE_CLASSIFIER + "." + ROOTFILE_EXTENSION);
        BufferedOutputStream target = null;
        try {
            SimpleArtifactDescriptor simpleArtifactDescriptor = (SimpleArtifactDescriptor)this.createArtifactDescriptor(artifactKey);
            Collection advices = this.publisherInfo.getAdvice(null, false, simpleArtifactDescriptor.getArtifactKey().getId(), simpleArtifactDescriptor.getArtifactKey().getVersion(), IPropertyAdvice.class);
            boolean mavenPropAdviceExists = false;
            for (IPropertyAdvice entry : advices) {
                if (!(entry instanceof MavenPropertiesAdvice)) continue;
                mavenPropAdviceExists = true;
                entry.getArtifactProperties(null, (IArtifactDescriptor)simpleArtifactDescriptor);
            }
            if (!mavenPropAdviceExists) {
                throw new ProvisionException("MavenPropertiesAdvice does not exist for artifact: " + simpleArtifactDescriptor);
            }
            String mavenArtifactClassifier = this.getRootFileArtifactClassifier(simpleArtifactDescriptor.getArtifactKey().getId());
            simpleArtifactDescriptor.setProperty("maven-classifier", mavenArtifactClassifier);
            simpleArtifactDescriptor.setProperty("maven-extension", ROOTFILE_EXTENSION);
            target = new BufferedOutputStream(new FileOutputStream(outputFile));
            this.publishedArtifacts.put(mavenArtifactClassifier, new P2Artifact(outputFile, Collections.<IInstallableUnit>emptySet(), (IArtifactDescriptor)simpleArtifactDescriptor));
            this.descriptors.add(simpleArtifactDescriptor);
        }
        catch (FileNotFoundException e) {
            throw new ProvisionException(e.getMessage(), (Throwable)e);
        }
        return target;
    }

    String getRootFileArtifactClassifier(String artifactId) {
        List adviceList = this.publisherInfo.getAdvice();
        for (IPublisherAdvice publisherAdvice : adviceList) {
            String[] configurations;
            if (!(publisherAdvice instanceof FeatureRootAdvice)) continue;
            String[] stringArray = configurations = ((FeatureRootAdvice)publisherAdvice).getConfigurations();
            int n = configurations.length;
            int n2 = 0;
            while (n2 < n) {
                String config = stringArray[n2];
                if (!"".equals(config) && artifactId.endsWith(config)) {
                    return "root." + config;
                }
                ++n2;
            }
        }
        return ROOTFILE_CLASSIFIER;
    }

    public Map<String, IP2Artifact> getPublishedArtifacts() {
        return this.publishedArtifacts;
    }
}

