/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.repo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.tycho.locking.facade.FileLockService;
import org.eclipse.tycho.locking.facade.FileLocker;
import org.eclipse.tycho.p2.repository.DefaultTychoRepositoryIndex;
import org.eclipse.tycho.p2.repository.GAV;
import org.eclipse.tycho.p2.repository.TychoRepositoryIndex;

public class FileBasedTychoRepositoryIndex
extends DefaultTychoRepositoryIndex {
    public static final String ARTIFACTS_INDEX_RELPATH = ".meta/p2-artifacts.properties";
    public static final String METADATA_INDEX_RELPATH = ".meta/p2-local-metadata.properties";
    private final File indexFile;
    private FileLocker fileLocker;
    private Set<GAV> addedGavs = new HashSet<GAV>();
    private Set<GAV> removedGavs = new HashSet<GAV>();

    private FileBasedTychoRepositoryIndex(File indexFile, FileLockService fileLockService) {
        this.indexFile = indexFile;
        this.fileLocker = fileLockService.getFileLocker(indexFile);
        if (indexFile.isFile()) {
            this.lock();
            try {
                try {
                    this.setGavs(this.read(new FileInputStream(indexFile)));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                this.unlock();
            }
        }
    }

    private void lock() {
        this.fileLocker.lock();
    }

    private void unlock() {
        this.fileLocker.release();
    }

    public void addGav(GAV gav) {
        super.addGav(gav);
        this.addedGavs.add(gav);
        if (this.removedGavs.contains(gav)) {
            this.removedGavs.remove(gav);
        }
    }

    public void removeGav(GAV gav) {
        super.removeGav(gav);
        this.removedGavs.add(gav);
        if (this.addedGavs.contains(gav)) {
            this.addedGavs.remove(gav);
        }
    }

    public void save() throws IOException {
        File parentDir = this.indexFile.getParentFile();
        if (!parentDir.isDirectory()) {
            parentDir.mkdirs();
        }
        this.lock();
        try {
            this.reconcile();
            this.write(new FileOutputStream(this.indexFile));
        }
        finally {
            this.unlock();
        }
    }

    private void reconcile() throws IOException {
        if (this.indexFile.isFile()) {
            this.setGavs(this.read(new FileInputStream(this.indexFile)));
            for (GAV addedGav : this.addedGavs) {
                this.addGav(addedGav);
            }
            for (GAV removedGav : this.removedGavs) {
                this.removeGav(removedGav);
            }
        }
        this.addedGavs.clear();
        this.removedGavs.clear();
    }

    public static TychoRepositoryIndex createMetadataIndex(File basedir, FileLockService fileLockService) {
        return new FileBasedTychoRepositoryIndex(new File(basedir, METADATA_INDEX_RELPATH), fileLockService);
    }

    public static TychoRepositoryIndex createArtifactsIndex(File basedir, FileLockService fileLockService) {
        return new FileBasedTychoRepositoryIndex(new File(basedir, ARTIFACTS_INDEX_RELPATH), fileLockService);
    }
}

