/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.resolver;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.tycho.artifacts.TargetPlatform;
import org.eclipse.tycho.artifacts.p2.P2TargetPlatform;
import org.eclipse.tycho.core.facade.MavenLogger;
import org.eclipse.tycho.core.facade.TargetEnvironment;
import org.eclipse.tycho.p2.impl.resolver.DefaultP2ResolutionResult;
import org.eclipse.tycho.p2.impl.resolver.LoggingProgressMonitor;
import org.eclipse.tycho.p2.impl.resolver.MetadataOnlyP2ResolutionResult;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.eclipse.tycho.p2.metadata.IReactorArtifactFacade;
import org.eclipse.tycho.p2.resolver.AbstractResolutionStrategy;
import org.eclipse.tycho.p2.resolver.DependencyCollector;
import org.eclipse.tycho.p2.resolver.ProjectorResolutionStrategy;
import org.eclipse.tycho.p2.resolver.QueryableCollection;
import org.eclipse.tycho.p2.resolver.facade.P2ResolutionResult;
import org.eclipse.tycho.p2.resolver.facade.P2Resolver;
import org.eclipse.tycho.p2.target.facade.TargetPlatformBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2ResolverImpl
implements P2Resolver {
    private static final String CAPABILITY_NS_OSGI_BUNDLE = "osgi.bundle";
    private final MavenLogger logger;
    private final IProgressMonitor monitor;
    private List<TargetEnvironment> environments;
    private Map<String, String> additionalFilterProperties = new HashMap<String, String>();
    private final List<IRequirement> additionalRequirements = new ArrayList<IRequirement>();
    private P2TargetPlatform context;
    private Set<IInstallableUnit> usedTargetPlatformUnits;

    public P2ResolverImpl(MavenLogger logger) {
        this.logger = logger;
        this.monitor = new LoggingProgressMonitor(logger);
        this.environments = Collections.singletonList(TargetEnvironment.getRunningEnvironment());
    }

    public List<P2ResolutionResult> resolveDependencies(TargetPlatform targetPlatform, File projectLocation) {
        this.context = (P2TargetPlatform)targetPlatform;
        ArrayList<P2ResolutionResult> results = new ArrayList<P2ResolutionResult>();
        this.usedTargetPlatformUnits = new LinkedHashSet<IInstallableUnit>();
        for (TargetEnvironment environment : this.environments) {
            results.add(this.resolveDependencies(projectLocation, new ProjectorResolutionStrategy(this.logger), environment));
        }
        this.context.reportUsedLocalIUs(this.usedTargetPlatformUnits);
        this.usedTargetPlatformUnits = null;
        return results;
    }

    public P2ResolutionResult collectProjectDependencies(TargetPlatform context, File projectLocation) {
        this.context = (P2TargetPlatform)context;
        return this.resolveDependencies(projectLocation, new DependencyCollector(this.logger), new TargetEnvironment(null, null, null));
    }

    public P2ResolutionResult resolveMetadata(TargetPlatformBuilder context) {
        ProjectorResolutionStrategy strategy = new ProjectorResolutionStrategy(this.logger);
        P2TargetPlatform contextImpl = (P2TargetPlatform)context.buildTargetPlatform();
        strategy.setEEResolutionHints(contextImpl.getEEResolutionHints());
        strategy.setAvailableInstallableUnits(contextImpl.getInstallableUnits());
        strategy.setRootInstallableUnits(new HashSet<IInstallableUnit>());
        strategy.setAdditionalRequirements(this.additionalRequirements);
        MetadataOnlyP2ResolutionResult result = new MetadataOnlyP2ResolutionResult();
        for (IInstallableUnit iu : strategy.multiPlatformResolve(this.environments, this.monitor)) {
            result.addArtifact("p2-installable-unit", iu.getId(), iu.getVersion().toString(), iu);
        }
        return result;
    }

    protected P2ResolutionResult resolveDependencies(File projectLocation, AbstractResolutionStrategy strategy, TargetEnvironment environment) {
        Collection<IInstallableUnit> projectSecondaryIUs;
        Collection<IInstallableUnit> availableUnits = this.context.getInstallableUnits();
        strategy.setRootInstallableUnits(this.getRootIUs(projectLocation));
        if (projectLocation != null && !(projectSecondaryIUs = this.context.getReactorProjectIUs(projectLocation, false)).isEmpty()) {
            availableUnits = new LinkedHashSet<IInstallableUnit>(availableUnits);
            availableUnits.addAll(projectSecondaryIUs);
        }
        strategy.setAdditionalRequirements(this.additionalRequirements);
        strategy.setAvailableInstallableUnits(availableUnits);
        strategy.setEEResolutionHints(this.context.getEEResolutionHints());
        strategy.setAdditionalFilterProperties(this.additionalFilterProperties);
        Collection<IInstallableUnit> newState = strategy.resolve(environment, this.monitor);
        if (this.usedTargetPlatformUnits != null) {
            this.usedTargetPlatformUnits.addAll(newState);
        }
        this.context.downloadArtifacts(newState);
        return this.toResolutionResult(newState);
    }

    private Collection<IInstallableUnit> getRootIUs(File projectLocation) {
        if (projectLocation == null) {
            return Collections.emptyList();
        }
        return this.context.getReactorProjectIUs(projectLocation, true);
    }

    private P2ResolutionResult toResolutionResult(Collection<IInstallableUnit> newState) {
        DefaultP2ResolutionResult result = new DefaultP2ResolutionResult();
        for (IInstallableUnit iu : newState) {
            IArtifactFacade mavenArtifact = this.context.getMavenArtifact(iu);
            if (mavenArtifact != null) {
                this.addMavenArtifact(result, mavenArtifact, iu);
                continue;
            }
            for (IArtifactKey key : iu.getArtifacts()) {
                this.addArtifactFile(result, iu, key);
            }
        }
        this.collectNonReactorIUs(result, newState);
        return result;
    }

    private void collectNonReactorIUs(DefaultP2ResolutionResult result, Collection<IInstallableUnit> newState) {
        for (IInstallableUnit iu : newState) {
            if (this.isReactorArtifact(iu)) continue;
            result.addNonReactorUnit(iu);
        }
    }

    private boolean isReactorArtifact(IInstallableUnit iu) {
        return this.context.getMavenArtifact(iu) instanceof IReactorArtifactFacade;
    }

    private void addArtifactFile(DefaultP2ResolutionResult platform, IInstallableUnit iu, IArtifactKey key) {
        String featureId;
        String mavenClassidier;
        File file = this.context.getLocalArtifactFile(key);
        if (file == null) {
            return;
        }
        IArtifactFacade reactorArtifact = this.context.getMavenArtifact(iu);
        String id = iu.getId();
        String version = iu.getVersion().toString();
        String string = mavenClassidier = reactorArtifact != null ? reactorArtifact.getClassifier() : null;
        if (CAPABILITY_NS_OSGI_BUNDLE.equals(key.getClassifier())) {
            platform.addArtifact("eclipse-plugin", id, version, true, file, mavenClassidier, iu);
        } else if ("org.eclipse.update.feature".equals(key.getClassifier()) && (featureId = this.getFeatureId(iu)) != null) {
            platform.addArtifact("eclipse-feature", featureId, version, true, file, mavenClassidier, iu);
        }
    }

    private void addMavenArtifact(DefaultP2ResolutionResult platform, IArtifactFacade mavenArtifact, IInstallableUnit iu) {
        String type = mavenArtifact.getPackagingType();
        String id = iu.getId();
        String version = iu.getVersion().toString();
        File location = mavenArtifact.getLocation();
        String mavenClassifier = mavenArtifact.getClassifier();
        boolean primary = false;
        if ("eclipse-plugin".equals(type)) {
            primary = this.isBundleOrFragmentWithId(iu, id);
        } else if ("eclipse-feature".equals(type)) {
            String featureId = this.getFeatureId(iu);
            if (featureId != null) {
                id = featureId;
                primary = true;
            }
        } else if ("jar".equals(type)) {
            type = "eclipse-plugin";
            primary = true;
        }
        platform.addArtifact(type, id, version, primary, location, mavenClassifier, iu);
    }

    private String getFeatureId(IInstallableUnit iu) {
        for (IProvidedCapability provided : iu.getProvidedCapabilities()) {
            if (!"org.eclipse.update.feature".equals(provided.getNamespace())) continue;
            return provided.getName();
        }
        return null;
    }

    private boolean isBundleOrFragmentWithId(IInstallableUnit iu, String id) {
        for (IProvidedCapability provided : iu.getProvidedCapabilities()) {
            if (!CAPABILITY_NS_OSGI_BUNDLE.equals(provided.getNamespace()) && !"osgi.fragment".equals(provided.getNamespace())) continue;
            return id.equals(provided.getName());
        }
        return false;
    }

    public void setEnvironments(List<TargetEnvironment> environments) {
        if (environments == null) {
            throw new NullPointerException();
        }
        this.environments = environments;
    }

    public void setAdditionalFilterProperties(Map<String, String> additionalFilterProperties) {
        if (additionalFilterProperties == null) {
            throw new NullPointerException();
        }
        this.additionalFilterProperties = additionalFilterProperties;
    }

    public void addDependency(String type, String id, String versionRange) {
        if ("p2-installable-unit".equals(type)) {
            this.additionalRequirements.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)new VersionRange(versionRange), null, (boolean)false, (boolean)true));
        } else if ("eclipse-plugin".equals(type)) {
            this.additionalRequirements.add(MetadataFactory.createRequirement((String)CAPABILITY_NS_OSGI_BUNDLE, (String)id, (VersionRange)new VersionRange(versionRange), null, (boolean)false, (boolean)true));
        } else if ("eclipse-feature".equals(type)) {
            this.additionalRequirements.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)(String.valueOf(id) + ".feature.group"), (VersionRange)new VersionRange(versionRange), null, (boolean)false, (boolean)true));
        }
    }

    public List<IRequirement> getAdditionalRequirements() {
        return this.additionalRequirements;
    }

    public P2ResolutionResult resolveInstallableUnit(TargetPlatform context, String id, String versionRange) {
        this.context = (P2TargetPlatform)context;
        QueryableCollection queriable = new QueryableCollection(((P2TargetPlatform)context).getInstallableUnits());
        VersionRange range = new VersionRange(versionRange);
        IRequirement requirement = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)range, null, (int)1, (int)Integer.MAX_VALUE, (boolean)false);
        IQueryResult result = queriable.query(QueryUtil.createLatestQuery((IQuery)QueryUtil.createMatchQuery((IExpression)requirement.getMatches(), (Object[])new Object[0])), this.monitor);
        Set newState = result.toUnmodifiableSet();
        this.context.downloadArtifacts(newState);
        return this.toResolutionResult(newState);
    }
}

