/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.remote;

import java.lang.reflect.Field;
import java.net.URI;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.repository.spi.AbstractRepository;
import org.eclipse.tycho.core.facade.MavenLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class P2MirrorDisablingArtifactRepositoryManager
implements IArtifactRepositoryManager {
    private final IArtifactRepositoryManager delegate;
    private final MavenLogger mavenLogger;

    public P2MirrorDisablingArtifactRepositoryManager(IArtifactRepositoryManager originalRepositoryManager, MavenLogger mavenLogger) {
        this.delegate = originalRepositoryManager;
        this.mavenLogger = mavenLogger;
    }

    private static IArtifactRepository disableMirrors(IArtifactRepository repository, MavenLogger logger) throws ProvisionException {
        if (repository instanceof SimpleArtifactRepository) {
            P2MirrorDisablingArtifactRepositoryManager.stripMirrorsURLProperty((SimpleArtifactRepository)repository, logger);
        }
        return repository;
    }

    private static void stripMirrorsURLProperty(AbstractRepository<?> repository, MavenLogger logger) {
        try {
            Map<?, ?> properties = P2MirrorDisablingArtifactRepositoryManager.getRepositoryProperties(repository);
            Object removedConfiguration = properties.remove("p2.mirrorsURL");
            if (removedConfiguration != null && logger.isDebugEnabled()) {
                logger.debug("Removed 'p2.mirrorsURL' property in repository " + repository.getLocation());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to disable mirrors for artifact repository at \"" + repository.getLocation() + "\"", e);
        }
    }

    private static Map<?, ?> getRepositoryProperties(AbstractRepository<?> repository) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = AbstractRepository.class.getDeclaredField("properties");
        field.setAccessible(true);
        return (Map)field.get(repository);
    }

    public IArtifactRepository createRepository(URI location, String name, String type, Map<String, String> properties) throws ProvisionException {
        IArtifactRepository repository = this.delegate.createRepository(location, name, type, properties);
        P2MirrorDisablingArtifactRepositoryManager.disableMirrors(repository, this.mavenLogger);
        return repository;
    }

    public IArtifactRepository loadRepository(URI location, int flags, IProgressMonitor monitor) throws ProvisionException {
        IArtifactRepository repository = this.delegate.loadRepository(location, flags, monitor);
        P2MirrorDisablingArtifactRepositoryManager.disableMirrors(repository, this.mavenLogger);
        return repository;
    }

    public IArtifactRepository loadRepository(URI location, IProgressMonitor monitor) throws ProvisionException {
        IArtifactRepository repository = this.delegate.loadRepository(location, monitor);
        P2MirrorDisablingArtifactRepositoryManager.disableMirrors(repository, this.mavenLogger);
        return repository;
    }

    public IArtifactRepository refreshRepository(URI location, IProgressMonitor monitor) throws ProvisionException {
        IArtifactRepository repository = this.delegate.refreshRepository(location, monitor);
        P2MirrorDisablingArtifactRepositoryManager.disableMirrors(repository, this.mavenLogger);
        return repository;
    }

    public void addRepository(URI location) {
        this.delegate.addRepository(location);
    }

    public boolean contains(URI location) {
        return this.delegate.contains(location);
    }

    public IArtifactRequest createMirrorRequest(IArtifactKey key, IArtifactRepository destination, Map<String, String> destinationDescriptorProperties, Map<String, String> destinationRepositoryProperties) {
        return this.delegate.createMirrorRequest(key, destination, destinationDescriptorProperties, destinationRepositoryProperties);
    }

    public IArtifactRequest createMirrorRequest(IArtifactKey key, IArtifactRepository destination, Map<String, String> destinationDescriptorProperties, Map<String, String> destinationRepositoryProperties, String downloadStatsParameters) {
        return this.delegate.createMirrorRequest(key, destination, destinationDescriptorProperties, destinationRepositoryProperties, downloadStatsParameters);
    }

    public IProvisioningAgent getAgent() {
        return this.delegate.getAgent();
    }

    public URI[] getKnownRepositories(int flags) {
        return this.delegate.getKnownRepositories(flags);
    }

    public String getRepositoryProperty(URI location, String key) {
        return this.delegate.getRepositoryProperty(location, key);
    }

    public boolean isEnabled(URI location) {
        return this.delegate.isEnabled(location);
    }

    public IQueryResult<IArtifactKey> query(IQuery<IArtifactKey> query, IProgressMonitor monitor) {
        return this.delegate.query(query, monitor);
    }

    public boolean removeRepository(URI location) {
        return this.delegate.removeRepository(location);
    }

    public void setEnabled(URI location, boolean enablement) {
        this.delegate.setEnabled(location, enablement);
    }

    public void setRepositoryProperty(URI location, String key, String value) {
        this.delegate.setRepositoryProperty(location, key, value);
    }
}

