/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.resolver;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.tycho.core.facade.MavenLogger;
import org.eclipse.tycho.core.facade.TargetEnvironment;
import org.eclipse.tycho.p2.resolver.ExecutionEnvironmentResolutionHints;
import org.eclipse.tycho.p2.resolver.ResolutionData;
import org.eclipse.tycho.p2.resolver.ResolutionDataImpl;
import org.eclipse.tycho.p2.util.StatusTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResolutionStrategy {
    protected static final IInstallableUnit[] EMPTY_IU_ARRAY = new IInstallableUnit[0];
    protected final MavenLogger logger;
    private final ResolutionDataImpl modifiableData = new ResolutionDataImpl();
    protected final ResolutionData data = this.modifiableData;

    protected AbstractResolutionStrategy(MavenLogger logger) {
        this.logger = logger;
    }

    public final void setAvailableInstallableUnits(Collection<IInstallableUnit> availableIUs) {
        this.modifiableData.setAvailableIUs(availableIUs);
    }

    public final void setRootInstallableUnits(Collection<IInstallableUnit> rootIUs) {
        this.modifiableData.setRootIUs(rootIUs);
    }

    public final void setAdditionalRequirements(List<IRequirement> additionalRequirements) {
        this.modifiableData.setAdditionalRequirements(additionalRequirements);
    }

    public final void setEEResolutionHints(ExecutionEnvironmentResolutionHints eeResolutionHints) {
        this.modifiableData.setEEResolutionHints(eeResolutionHints);
    }

    public final void setAdditionalFilterProperties(Map<String, String> additionalFilterProperties) {
        this.modifiableData.setAdditionalFilterProperties(additionalFilterProperties);
    }

    public Collection<IInstallableUnit> resolve(TargetEnvironment environment, IProgressMonitor monitor) {
        return this.resolve(this.getEffectiveFilterProperties(environment), monitor);
    }

    public Collection<IInstallableUnit> multiPlatformResolve(List<TargetEnvironment> environments, IProgressMonitor monitor) {
        LinkedHashSet<IInstallableUnit> result = new LinkedHashSet<IInstallableUnit>();
        for (TargetEnvironment environment : environments) {
            result.addAll(this.resolve(this.getEffectiveFilterProperties(environment), monitor));
        }
        return result;
    }

    protected abstract Collection<IInstallableUnit> resolve(Map<String, String> var1, IProgressMonitor var2);

    private Map<String, String> getEffectiveFilterProperties(TargetEnvironment environment) {
        HashMap result = environment.toFilterProperties();
        result.put("org.eclipse.update.install.features", "true");
        this.insertAdditionalFilterProperties(result);
        return result;
    }

    private void insertAdditionalFilterProperties(Map<String, String> result) {
        for (Map.Entry<String, String> entry : this.data.getAdditionalFilterProperties().entrySet()) {
            String overwrittenValue = result.put(entry.getKey(), entry.getValue());
            if (overwrittenValue == null) continue;
            this.logger.warn("Overriding profile property '" + entry.getKey() + "' with value '" + entry.getValue() + "' (was '" + overwrittenValue + "')");
        }
    }

    protected RuntimeException newResolutionException(IStatus status) {
        return new RuntimeException(StatusTool.collectProblems((IStatus)status), status.getException());
    }
}

