/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.tycho.core.facade.MavenLogger;
import org.eclipse.tycho.p2.impl.resolver.LoggingProgressMonitor;
import org.eclipse.tycho.p2.util.StatusTool;
import org.eclipse.tycho.repository.local.LocalArtifactRepository;
import org.eclipse.tycho.repository.local.MavenMirrorRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2ArtifactDownloadTool {
    private static final IArtifactRequest[] ARTIFACT_REQUEST_ARRAY = new IArtifactRequest[0];
    private final IProvisioningAgent agent;
    private final MavenLogger logger;

    public P2ArtifactDownloadTool(IProvisioningAgent agent, MavenLogger logger) {
        this.agent = agent;
        this.logger = logger;
    }

    public void downloadArtifactsToLocalMavenRepository(List<IArtifactKey> artifacts, List<URI> artifactRepositoryLocations, LocalArtifactRepository localMavenRepository, boolean includePackedArtifacts) {
        List<MavenMirrorRequest> requests = new ArrayList<MavenMirrorRequest>();
        for (IArtifactKey key : artifacts) {
            requests.add(new MavenMirrorRequest(key, localMavenRepository, this.getTransport(), includePackedArtifacts));
        }
        IArtifactRepository repository = this.createCompositeRepository(artifactRepositoryLocations);
        IStatus result = repository.getArtifacts(requests.toArray(ARTIFACT_REQUEST_ARRAY), (IProgressMonitor)new LoggingProgressMonitor(this.logger));
        if (!result.isOK()) {
            throw new RuntimeException(StatusTool.collectProblems((IStatus)result), result.getException());
        }
        requests = this.filterCompletedRequests(requests);
        localMavenRepository.save();
        Iterator<MavenMirrorRequest> iter = requests.iterator();
        while (iter.hasNext()) {
            MavenMirrorRequest request = iter.next();
            if (!localMavenRepository.contains(request.getArtifactKey())) continue;
            iter.remove();
        }
        if (!requests.isEmpty()) {
            StringBuilder msg = new StringBuilder("Could not download artifacts from any repository\n");
            for (MavenMirrorRequest request : requests) {
                msg.append("   ").append(request.getArtifactKey().toExternalForm()).append('\n');
            }
            throw new RuntimeException(msg.toString());
        }
    }

    private Transport getTransport() {
        return (Transport)this.agent.getService(Transport.SERVICE_NAME);
    }

    private IArtifactRepository createCompositeRepository(List<URI> artifactRepositories) {
        CompositeArtifactRepository composite = CompositeArtifactRepository.createMemoryComposite((IProvisioningAgent)this.agent);
        for (URI artifactRepository : artifactRepositories) {
            composite.addChild(artifactRepository);
        }
        return composite;
    }

    private List<MavenMirrorRequest> filterCompletedRequests(List<MavenMirrorRequest> requests) {
        ArrayList<MavenMirrorRequest> filteredRequests = new ArrayList<MavenMirrorRequest>();
        for (MavenMirrorRequest request : requests) {
            if (request.getResult() != null && request.getResult().isOK()) continue;
            filteredRequests.add(request);
        }
        return filteredRequests;
    }
}

