/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.core.helpers.OrderedProperties;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.repository.spi.AbstractRepository;
import org.eclipse.tycho.artifacts.TargetPlatformFilter;
import org.eclipse.tycho.artifacts.p2.P2TargetPlatform;
import org.eclipse.tycho.core.facade.MavenContext;
import org.eclipse.tycho.core.facade.MavenLogger;
import org.eclipse.tycho.core.facade.TargetEnvironment;
import org.eclipse.tycho.core.resolver.shared.MavenRepositoryLocation;
import org.eclipse.tycho.p2.impl.resolver.ClassifiedLocation;
import org.eclipse.tycho.p2.impl.resolver.DuplicateReactorIUsException;
import org.eclipse.tycho.p2.impl.resolver.LoggingProgressMonitor;
import org.eclipse.tycho.p2.maven.repository.xmlio.MetadataIO;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.eclipse.tycho.p2.metadata.IReactorArtifactFacade;
import org.eclipse.tycho.p2.remote.IRepositoryIdManager;
import org.eclipse.tycho.p2.repository.GAV;
import org.eclipse.tycho.p2.target.TargetDefinitionResolverService;
import org.eclipse.tycho.p2.target.TargetPlatformBundlePublisher;
import org.eclipse.tycho.p2.target.TargetPlatformContent;
import org.eclipse.tycho.p2.target.TargetPlatformImpl;
import org.eclipse.tycho.p2.target.ee.ExecutionEnvironmentResolutionHandler;
import org.eclipse.tycho.p2.target.facade.TargetDefinition;
import org.eclipse.tycho.p2.target.facade.TargetDefinitionResolutionException;
import org.eclipse.tycho.p2.target.facade.TargetDefinitionSyntaxException;
import org.eclipse.tycho.p2.target.facade.TargetPlatformBuilder;
import org.eclipse.tycho.p2.target.filters.TargetPlatformFilterEvaluator;
import org.eclipse.tycho.repository.local.LocalArtifactRepository;
import org.eclipse.tycho.repository.local.LocalMetadataRepository;
import org.eclipse.tycho.repository.registry.ArtifactRepositoryBlackboard;
import org.eclipse.tycho.repository.registry.facade.RepositoryBlackboardKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetPlatformBuilderImpl
implements TargetPlatformBuilder {
    private final MavenLogger logger;
    private final IProgressMonitor monitor;
    private final boolean offline;
    private final IProvisioningAgent remoteAgent;
    private final IMetadataRepositoryManager remoteMetadataRepositoryManager;
    private final IArtifactRepositoryManager remoteArtifactRepositoryManager;
    private IRepositoryIdManager remoteRepositoryIdManager;
    private final TargetDefinitionResolverService targetDefinitionResolverService;
    private boolean includePackedArtifacts;
    private boolean failOnDuplicateIUs = true;
    private final ExecutionEnvironmentResolutionHandler eeResolutionHandler;
    private final LocalArtifactRepository localArtifactRepository;
    private final LocalMetadataRepository localMetadataRepository;
    private boolean includeLocalMavenRepo;
    private Map<ClassifiedLocation, IReactorArtifactFacade> reactorProjects = new LinkedHashMap<ClassifiedLocation, IReactorArtifactFacade>();
    private Map<IInstallableUnit, IArtifactFacade> mavenInstallableUnits = new HashMap<IInstallableUnit, IArtifactFacade>();
    private final TargetPlatformBundlePublisher bundlesPublisher;
    private final Set<IMetadataRepository> metadataRepositories = new LinkedHashSet<IMetadataRepository>();
    private final List<IArtifactRepository> artifactRepositories = new ArrayList<IArtifactRepository>();
    private List<TargetPlatformContent> content = new ArrayList<TargetPlatformContent>();
    private File projectLocation;
    private List<TargetPlatformFilter> iuFilters = new ArrayList<TargetPlatformFilter>();

    public TargetPlatformBuilderImpl(IProvisioningAgent remoteAgent, MavenContext mavenContext, TargetDefinitionResolverService targetDefinitionResolverService, ExecutionEnvironmentResolutionHandler eeResolutionHandler, LocalArtifactRepository localArtifactRepo, LocalMetadataRepository localMetadataRepo) throws ProvisionException {
        this.remoteAgent = remoteAgent;
        this.targetDefinitionResolverService = targetDefinitionResolverService;
        this.logger = mavenContext.getLogger();
        this.monitor = new LoggingProgressMonitor(this.logger);
        this.includeLocalMavenRepo = TargetPlatformBuilderImpl.shouldIncludeLocalMavenRepo(mavenContext);
        this.remoteMetadataRepositoryManager = (IMetadataRepositoryManager)remoteAgent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        if (this.remoteMetadataRepositoryManager == null) {
            throw new IllegalStateException("No metadata repository manager found");
        }
        this.remoteArtifactRepositoryManager = (IArtifactRepositoryManager)remoteAgent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        if (this.remoteArtifactRepositoryManager == null) {
            throw new IllegalStateException("No artifact repository manager found");
        }
        this.remoteRepositoryIdManager = (IRepositoryIdManager)remoteAgent.getService(IRepositoryIdManager.SERVICE_NAME);
        this.offline = mavenContext.isOffline();
        this.eeResolutionHandler = eeResolutionHandler;
        File localRepositoryRoot = mavenContext.getLocalRepositoryRoot();
        this.bundlesPublisher = new TargetPlatformBundlePublisher(localRepositoryRoot, this.logger);
        this.localArtifactRepository = localArtifactRepo;
        this.localMetadataRepository = localMetadataRepo;
        if (this.includeLocalMavenRepo) {
            this.metadataRepositories.add((IMetadataRepository)this.localMetadataRepository);
        }
    }

    public void addReactorArtifact(IReactorArtifactFacade artifact) {
        ClassifiedLocation key = new ClassifiedLocation((IArtifactFacade)artifact);
        this.reactorProjects.put(key, artifact);
    }

    public void addArtifactWithExistingMetadata(IArtifactFacade artifact, IArtifactFacade p2MetadataFile) {
        try {
            this.addMavenArtifact(new ClassifiedLocation(artifact), artifact, this.readUnits(p2MetadataFile));
        }
        catch (IOException e) {
            throw new RuntimeException("failed to read p2 metadata", e);
        }
    }

    private Set<IInstallableUnit> readUnits(IArtifactFacade p2MetadataFile) throws IOException {
        FileInputStream inputStream = new FileInputStream(p2MetadataFile.getLocation());
        try {
            MetadataIO io = new MetadataIO();
            Set set = io.readXML((InputStream)inputStream);
            return set;
        }
        finally {
            inputStream.close();
        }
    }

    public void addMavenArtifact(ClassifiedLocation key, IArtifactFacade artifact, Set<IInstallableUnit> units) {
        for (IInstallableUnit unit : units) {
            String classifier = unit.getProperty("maven-classifier");
            if (!(classifier == null ? key.getClassifier() == null : classifier.equals(key.getClassifier()))) continue;
            this.mavenInstallableUnits.put(unit, artifact);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("P2Resolver: artifact " + new GAV(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()).toString() + " at location " + artifact.getLocation() + " resolves installable unit " + new VersionedId(unit.getId(), unit.getVersion()));
        }
    }

    public void publishAndAddArtifactIfBundleArtifact(IArtifactFacade artifact) {
        IInstallableUnit bundleIU = this.bundlesPublisher.attemptToPublishBundle(artifact);
        if (bundleIU != null) {
            this.addMavenArtifact(new ClassifiedLocation(artifact), artifact, Collections.singleton(bundleIU));
        }
    }

    private IArtifactRepository getSupplementaryArtifactRepository() {
        return this.bundlesPublisher.getArtifactRepoOfPublishedBundles();
    }

    public void addP2Repository(MavenRepositoryLocation location) {
        IMetadataRepository metadataRepository = null;
        IArtifactRepository artifactRepository = null;
        try {
            this.remoteRepositoryIdManager.addMapping(location.getId(), location.getURL());
            metadataRepository = this.remoteMetadataRepositoryManager.loadRepository(location.getURL(), this.monitor);
            this.metadataRepositories.add(metadataRepository);
            if (!this.offline || URIUtil.isFileURI((URI)location.getURL())) {
                artifactRepository = this.remoteArtifactRepositoryManager.loadRepository(location.getURL(), this.monitor);
                this.artifactRepositories.add(artifactRepository);
                this.forceSingleThreadedDownload(artifactRepository);
            }
        }
        catch (ProvisionException e) {
            String idMessage = location.getId() == null ? "" : " with ID '" + location.getId() + "'";
            throw new RuntimeException("Failed to load p2 repository" + idMessage + " from location " + location.getURL(), e);
        }
    }

    public void addP2Repository(URI location) {
        this.addP2Repository(new MavenRepositoryLocation(null, location));
    }

    protected void forceSingleThreadedDownload(IArtifactRepository artifactRepository) {
        try {
            if (artifactRepository instanceof SimpleArtifactRepository) {
                OrderedProperties p = this.getProperties(artifactRepository);
                p.put("eclipse.p2.max.threads", "1");
            } else if (artifactRepository instanceof CompositeArtifactRepository) {
                List children = ((CompositeArtifactRepository)artifactRepository).getChildren();
                for (URI child : children) {
                    this.forceSingleThreadedDownload(this.remoteArtifactRepositoryManager.loadRepository(child, this.monitor));
                }
            }
        }
        catch (Exception exception) {}
    }

    private OrderedProperties getProperties(IArtifactRepository artifactRepository) throws NoSuchFieldException, IllegalAccessException {
        Field field = AbstractRepository.class.getDeclaredField("properties");
        field.setAccessible(true);
        OrderedProperties p = (OrderedProperties)field.get((SimpleArtifactRepository)artifactRepository);
        return p;
    }

    public void addTargetDefinition(TargetDefinition definition, List<TargetEnvironment> environments) throws TargetDefinitionSyntaxException, TargetDefinitionResolutionException {
        TargetPlatformContent targetFileContent = this.targetDefinitionResolverService.getTargetDefinitionContent(definition, environments, this.eeResolutionHandler.getResolutionHints(), this.remoteAgent);
        this.content.add(targetFileContent);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Added " + targetFileContent.getUnits().size() + " units, the content of the target definition file, to the target platform");
        }
    }

    public void setProjectLocation(File projectLocation) {
        this.projectLocation = projectLocation;
    }

    public P2TargetPlatform buildTargetPlatform() {
        IArtifactRepository resolutionContextArtifactRepo = this.getSupplementaryArtifactRepository();
        RepositoryBlackboardKey blackboardKey = RepositoryBlackboardKey.forResolutionContextArtifacts((File)this.projectLocation);
        ArtifactRepositoryBlackboard.putRepository((RepositoryBlackboardKey)blackboardKey, (IArtifactRepository)resolutionContextArtifactRepo);
        this.logger.debug("Registered artifact repository " + blackboardKey);
        Set<IInstallableUnit> reactorProjectUIs = this.getReactorProjectUIs();
        TargetPlatformFilterEvaluator filter = !this.iuFilters.isEmpty() ? new TargetPlatformFilterEvaluator(this.iuFilters, this.logger) : null;
        LinkedHashSet<IInstallableUnit> externalUIs = this.gatherExternalInstallableUnits(this.monitor);
        this.applyFilters(filter, externalUIs, reactorProjectUIs);
        LinkedHashSet<IInstallableUnit> mavenIUs = this.gatherMavenInstallableUnits();
        this.applyFilters(filter, mavenIUs, reactorProjectUIs);
        ArrayList<URI> allRemoteArtifactRepositories = new ArrayList<URI>();
        for (IArtifactRepository artifactRepository : this.artifactRepositories) {
            allRemoteArtifactRepositories.add(artifactRepository.getLocation());
        }
        for (TargetPlatformContent contentPart : this.content) {
            allRemoteArtifactRepositories.addAll(contentPart.getArtifactRepositoryLocations());
        }
        TargetPlatformImpl targetPlatform = new TargetPlatformImpl(this.reactorProjects.values(), externalUIs, this.mavenInstallableUnits, this.eeResolutionHandler.getResolutionHints(), filter, this.localMetadataRepository, allRemoteArtifactRepositories, this.localArtifactRepository, this.remoteAgent, this.includePackedArtifacts, this.includeLocalMavenRepo, this.logger);
        this.eeResolutionHandler.readFullSpecification(targetPlatform.getInstallableUnits());
        return targetPlatform;
    }

    private LinkedHashSet<IInstallableUnit> gatherExternalInstallableUnits(IProgressMonitor monitor) {
        LinkedHashSet<IInstallableUnit> result = new LinkedHashSet<IInstallableUnit>();
        for (TargetPlatformContent contentPart : this.content) {
            result.addAll(contentPart.getUnits());
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.metadataRepositories.size() * 200));
        for (IMetadataRepository repository : this.metadataRepositories) {
            IQueryResult matches = repository.query(QueryUtil.ALL_UNITS, (IProgressMonitor)sub.newChild(100));
            result.addAll(matches.toUnmodifiableSet());
        }
        sub.done();
        if (this.includeLocalMavenRepo && this.logger.isDebugEnabled()) {
            IQueryResult locallyInstalledIUs = this.localMetadataRepository.query(QueryUtil.ALL_UNITS, null);
            this.logger.debug("Added " + this.countElements(locallyInstalledIUs.iterator()) + " locally built units to the target platform");
        }
        return result;
    }

    private LinkedHashSet<IInstallableUnit> gatherMavenInstallableUnits() {
        return new LinkedHashSet<IInstallableUnit>(this.mavenInstallableUnits.keySet());
    }

    private int countElements(Iterator<?> iterator) {
        int result = 0;
        while (iterator.hasNext()) {
            ++result;
            iterator.next();
        }
        return result;
    }

    private static boolean isPartialIU(IInstallableUnit iu) {
        return Boolean.valueOf(iu.getProperty("org.eclipse.equinox.p2.partial.iu"));
    }

    public void addFilters(List<TargetPlatformFilter> filters) {
        this.iuFilters.addAll(filters);
    }

    private void applyFilters(TargetPlatformFilterEvaluator filter, LinkedHashSet<IInstallableUnit> units, Set<IInstallableUnit> reactorProjectUIs) {
        HashSet<String> reactorIUIDs = new HashSet<String>();
        for (IInstallableUnit unit : reactorProjectUIs) {
            reactorIUIDs.add(unit.getId());
        }
        Iterator iter = units.iterator();
        while (iter.hasNext()) {
            IInstallableUnit unit = (IInstallableUnit)iter.next();
            if (!this.eeResolutionHandler.getResolutionHints().isNonApplicableEEUnit(unit) && !TargetPlatformBuilderImpl.isPartialIU(unit) && !reactorIUIDs.contains(unit.getId())) continue;
            iter.remove();
        }
        if (filter != null) {
            filter.filterUnits(units);
        }
    }

    private Set<IInstallableUnit> getReactorProjectUIs() throws DuplicateReactorIUsException {
        HashMap<IInstallableUnit, LinkedHashSet<File>> reactorUIs = new HashMap<IInstallableUnit, LinkedHashSet<File>>();
        HashMap<IInstallableUnit, Set<File>> duplicateReactorUIs = new HashMap<IInstallableUnit, Set<File>>();
        for (IReactorArtifactFacade project : this.reactorProjects.values()) {
            LinkedHashSet<IInstallableUnit> projectIUs = new LinkedHashSet<IInstallableUnit>();
            projectIUs.addAll(TargetPlatformBuilderImpl.toSet(project.getDependencyMetadata(true), IInstallableUnit.class));
            projectIUs.addAll(TargetPlatformBuilderImpl.toSet(project.getDependencyMetadata(false), IInstallableUnit.class));
            for (IInstallableUnit iu : projectIUs) {
                LinkedHashSet<File> locations = (LinkedHashSet<File>)reactorUIs.get(iu);
                if (locations == null) {
                    locations = new LinkedHashSet<File>();
                    reactorUIs.put(iu, locations);
                }
                locations.add(project.getLocation());
                if (locations.size() <= 1) continue;
                duplicateReactorUIs.put(iu, locations);
            }
        }
        if (this.failOnDuplicateIUs && !duplicateReactorUIs.isEmpty()) {
            throw new DuplicateReactorIUsException(duplicateReactorUIs);
        }
        return reactorUIs.keySet();
    }

    static <T> Set<T> toSet(Collection<Object> collection, Class<T> targetType) {
        if (collection == null || collection.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        for (Object o : collection) {
            set.add(targetType.cast(o));
        }
        return set;
    }

    public void setIncludePackedArtifacts(boolean include) {
        this.includePackedArtifacts = include;
    }

    public void setFailOnDuplicateIUs(boolean failOnDuplicateIUs) {
        this.failOnDuplicateIUs = failOnDuplicateIUs;
    }

    public void setIncludeLocalMavenRepo(boolean includeLocalMavenRepo) {
        this.includeLocalMavenRepo = includeLocalMavenRepo;
        if (includeLocalMavenRepo) {
            this.metadataRepositories.add((IMetadataRepository)this.localMetadataRepository);
        } else {
            this.metadataRepositories.remove(this.localMetadataRepository);
        }
    }

    static boolean shouldIncludeLocalMavenRepo(MavenContext context) {
        boolean ignoreLocal = "ignore".equalsIgnoreCase(context.getSessionProperties().getProperty("tycho.localArtifacts"));
        if (ignoreLocal) {
            context.getLogger().debug("tycho.localArtifacts=" + context.getSessionProperties().getProperty("tycho.localArtifacts") + " -> ignoring locally built artifacts");
        }
        return !ignoreLocal;
    }
}

