/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.tycho.artifacts.p2.P2TargetPlatform;
import org.eclipse.tycho.core.facade.MavenLogger;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.eclipse.tycho.p2.metadata.IReactorArtifactFacade;
import org.eclipse.tycho.p2.resolver.ExecutionEnvironmentResolutionHints;
import org.eclipse.tycho.p2.target.P2ArtifactDownloadTool;
import org.eclipse.tycho.p2.target.TargetPlatformBuilderImpl;
import org.eclipse.tycho.p2.target.filters.TargetPlatformFilterEvaluator;
import org.eclipse.tycho.repository.local.LocalArtifactRepository;
import org.eclipse.tycho.repository.local.LocalMetadataRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetPlatformImpl
implements P2TargetPlatform {
    private final Collection<IInstallableUnit> externalIUs;
    private final ExecutionEnvironmentResolutionHints executionEnvironment;
    private final Map<IInstallableUnit, IArtifactFacade> mavenArtifactIUs;
    private final Collection<IReactorArtifactFacade> reactorProjects;
    private final LocalMetadataRepository localMetadataRepository;
    private final List<URI> remoteArtifactRepositories;
    private final LocalArtifactRepository localMavenRepository;
    private final IProvisioningAgent agent;
    private final MavenLogger logger;
    private final TargetPlatformFilterEvaluator filter;
    private final boolean includePackedArtifacts;
    private boolean includeLocalRepo;

    public TargetPlatformImpl(Collection<IReactorArtifactFacade> reactorProjects, Collection<IInstallableUnit> ius, Map<IInstallableUnit, IArtifactFacade> mavenArtifactIUs, ExecutionEnvironmentResolutionHints executionEnvironment, TargetPlatformFilterEvaluator filter, LocalMetadataRepository localMetadataRepository, List<URI> allRemoteArtifactRepositories, LocalArtifactRepository localMavenRepository, IProvisioningAgent agent, boolean includePackedArtifacts, boolean includeLocalRepo, MavenLogger logger) {
        this.reactorProjects = reactorProjects;
        this.externalIUs = ius;
        this.executionEnvironment = executionEnvironment;
        this.mavenArtifactIUs = mavenArtifactIUs;
        this.filter = filter;
        this.localMetadataRepository = localMetadataRepository;
        this.includeLocalRepo = includeLocalRepo;
        this.remoteArtifactRepositories = allRemoteArtifactRepositories;
        this.localMavenRepository = localMavenRepository;
        this.agent = agent;
        this.includePackedArtifacts = includePackedArtifacts;
        this.logger = logger;
    }

    @Override
    public Collection<IInstallableUnit> getInstallableUnits() {
        LinkedHashSet<IInstallableUnit> allius = new LinkedHashSet<IInstallableUnit>();
        allius.addAll(this.getReactorProjectIUs().keySet());
        allius.addAll(this.externalIUs);
        allius.addAll(this.mavenArtifactIUs.keySet());
        allius.addAll(this.executionEnvironment.getMandatoryUnits());
        return Collections.unmodifiableCollection(allius);
    }

    public Map<IInstallableUnit, IReactorArtifactFacade> getReactorProjectIUs() {
        LinkedHashMap<IInstallableUnit, IReactorArtifactFacade> allius = new LinkedHashMap<IInstallableUnit, IReactorArtifactFacade>();
        for (IReactorArtifactFacade project : this.reactorProjects) {
            for (Object iu : project.getDependencyMetadata(true)) {
                allius.put((IInstallableUnit)iu, project);
            }
            for (Object iu : project.getDependencyMetadata(false)) {
                allius.put((IInstallableUnit)iu, project);
            }
        }
        this.filterUnits(allius.keySet());
        return Collections.unmodifiableMap(allius);
    }

    private void filterUnits(Collection<IInstallableUnit> keySet) {
        if (this.filter != null) {
            this.filter.filterUnits(keySet);
        }
    }

    @Override
    public ExecutionEnvironmentResolutionHints getEEResolutionHints() {
        return this.executionEnvironment;
    }

    @Override
    public Collection<IInstallableUnit> getReactorProjectIUs(File projectRoot, boolean primary) {
        boolean found = false;
        LinkedHashSet<IInstallableUnit> result = new LinkedHashSet<IInstallableUnit>();
        for (IReactorArtifactFacade project : this.reactorProjects) {
            if (!project.getLocation().equals(projectRoot)) continue;
            found = true;
            result.addAll(TargetPlatformBuilderImpl.toSet(project.getDependencyMetadata(primary), IInstallableUnit.class));
        }
        if (!found) {
            throw new IllegalArgumentException("Not a reactor project: " + projectRoot);
        }
        this.filterUnits(result);
        return Collections.unmodifiableSet(result);
    }

    @Override
    public IArtifactFacade getMavenArtifact(IInstallableUnit iu) {
        Map<IInstallableUnit, IReactorArtifactFacade> reactorProjectIUs = this.getReactorProjectIUs();
        IArtifactFacade artifact = (IArtifactFacade)reactorProjectIUs.get(iu);
        if (artifact == null) {
            artifact = this.mavenArtifactIUs.get(iu);
        }
        return artifact;
    }

    @Override
    public File getLocalArtifactFile(IArtifactKey key) {
        return this.localMavenRepository.getArtifactFile(key);
    }

    @Override
    public void reportUsedLocalIUs(Collection<IInstallableUnit> usedUnits) {
        if (!this.includeLocalRepo) {
            return;
        }
        Set localIUs = this.localMetadataRepository.query(QueryUtil.ALL_UNITS, null).toSet();
        localIUs.retainAll(usedUnits);
        Iterator iterator = localIUs.iterator();
        while (iterator.hasNext()) {
            if (!this.executionEnvironment.isNonApplicableEEUnit((IInstallableUnit)iterator.next())) continue;
            iterator.remove();
        }
        if (!localIUs.isEmpty()) {
            this.logger.warn("The following locally built units have been used to resolve project dependencies:");
            for (IInstallableUnit localIu : localIUs) {
                this.logger.warn("  " + localIu.getId() + "/" + localIu.getVersion());
            }
        }
    }

    @Override
    public void downloadArtifacts(Collection<IInstallableUnit> usedUnits) {
        P2ArtifactDownloadTool downloadTool = new P2ArtifactDownloadTool(this.agent, this.logger);
        ArrayList<IArtifactKey> remoteArtifacts = new ArrayList<IArtifactKey>();
        for (IInstallableUnit iu : usedUnits) {
            if (this.getMavenArtifact(iu) != null) continue;
            Collection artifactKeys = iu.getArtifacts();
            remoteArtifacts.addAll(artifactKeys);
        }
        downloadTool.downloadArtifactsToLocalMavenRepository(remoteArtifacts, this.remoteArtifactRepositories, this.localMavenRepository, this.includePackedArtifacts);
        this.localMetadataRepository.save();
    }
}

