/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.resolver;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.ReactorProjectIdentities;
import org.eclipse.tycho.artifacts.TargetPlatform;
import org.eclipse.tycho.artifacts.p2.P2TargetPlatform;
import org.eclipse.tycho.core.ee.shared.ExecutionEnvironmentConfiguration;
import org.eclipse.tycho.core.ee.shared.ExecutionEnvironmentConfigurationStub;
import org.eclipse.tycho.core.facade.MavenLogger;
import org.eclipse.tycho.core.facade.TargetEnvironment;
import org.eclipse.tycho.p2.impl.resolver.DefaultP2ResolutionResult;
import org.eclipse.tycho.p2.impl.resolver.MetadataOnlyP2ResolutionResult;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.eclipse.tycho.p2.resolver.AbstractResolutionStrategy;
import org.eclipse.tycho.p2.resolver.DependencyCollector;
import org.eclipse.tycho.p2.resolver.ProjectorResolutionStrategy;
import org.eclipse.tycho.p2.resolver.QueryableCollection;
import org.eclipse.tycho.p2.resolver.facade.P2ResolutionResult;
import org.eclipse.tycho.p2.resolver.facade.P2Resolver;
import org.eclipse.tycho.p2.target.TargetPlatformFactoryImpl;
import org.eclipse.tycho.p2.target.facade.PomDependencyCollector;
import org.eclipse.tycho.p2.target.facade.TargetPlatformConfigurationStub;
import org.eclipse.tycho.repository.util.LoggingProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2ResolverImpl
implements P2Resolver {
    private static final String CAPABILITY_NS_OSGI_BUNDLE = "osgi.bundle";
    private final MavenLogger logger;
    private final IProgressMonitor monitor;
    private List<TargetEnvironment> environments;
    private Map<String, String> additionalFilterProperties = new HashMap<String, String>();
    private final List<IRequirement> additionalRequirements = new ArrayList<IRequirement>();
    private TargetPlatformFactoryImpl targetPlatformFactory;
    private P2TargetPlatform context;
    private Set<IInstallableUnit> currentProjectUnits;
    private Map<IInstallableUnit, ReactorProjectIdentities> reactorProjectLookup;
    private Map<IInstallableUnit, IArtifactFacade> mavenArtifactLookup;
    private Set<IInstallableUnit> usedTargetPlatformUnits;

    public P2ResolverImpl(TargetPlatformFactoryImpl targetPlatformFactory, MavenLogger logger) {
        this.targetPlatformFactory = targetPlatformFactory;
        this.logger = logger;
        this.monitor = new LoggingProgressMonitor(logger);
        this.environments = Collections.singletonList(TargetEnvironment.getRunningEnvironment());
    }

    private void setContext(TargetPlatform targetPlatform, ReactorProject currentProject) {
        this.context = (P2TargetPlatform)targetPlatform;
        this.currentProjectUnits = currentProject == null ? Collections.emptySet() : currentProject.getDependencyMetadata();
        this.reactorProjectLookup = this.context.getOriginalReactorProjectMap();
        this.mavenArtifactLookup = this.context.getOriginalMavenArtifactMap();
    }

    public List<P2ResolutionResult> resolveDependencies(TargetPlatform targetPlatform, ReactorProject project) {
        this.setContext(targetPlatform, project);
        ArrayList<P2ResolutionResult> results = new ArrayList<P2ResolutionResult>();
        this.usedTargetPlatformUnits = new LinkedHashSet<IInstallableUnit>();
        for (TargetEnvironment environment : this.environments) {
            results.add(this.resolveDependencies(project, new ProjectorResolutionStrategy(this.logger), environment));
        }
        this.context.reportUsedLocalIUs(this.usedTargetPlatformUnits);
        this.usedTargetPlatformUnits = null;
        return results;
    }

    public P2ResolutionResult collectProjectDependencies(TargetPlatform targetPlatform, ReactorProject project) {
        this.setContext(targetPlatform, project);
        return this.resolveDependencies(project, new DependencyCollector(this.logger), new TargetEnvironment(null, null, null));
    }

    public P2ResolutionResult resolveMetadata(TargetPlatformConfigurationStub context, String eeName) {
        ProjectorResolutionStrategy strategy = new ProjectorResolutionStrategy(this.logger);
        TargetPlatform contextImpl = this.targetPlatformFactory.createTargetPlatform(context, (ExecutionEnvironmentConfiguration)new ExecutionEnvironmentConfigurationStub(eeName), (List)null, (PomDependencyCollector)null);
        strategy.setEEResolutionHints(contextImpl.getEEResolutionHints());
        strategy.setAvailableInstallableUnits(contextImpl.getInstallableUnits());
        strategy.setRootInstallableUnits(new HashSet<IInstallableUnit>());
        strategy.setAdditionalRequirements(this.additionalRequirements);
        MetadataOnlyP2ResolutionResult result = new MetadataOnlyP2ResolutionResult();
        for (IInstallableUnit iu : strategy.multiPlatformResolve(this.environments, this.monitor)) {
            result.addArtifact("p2-installable-unit", iu.getId(), iu.getVersion().toString(), iu);
        }
        return result;
    }

    protected P2ResolutionResult resolveDependencies(ReactorProject project, AbstractResolutionStrategy strategy, TargetEnvironment environment) {
        Set<IInstallableUnit> availableUnits = this.context.getInstallableUnits();
        if (project != null) {
            strategy.setRootInstallableUnits(project.getDependencyMetadata(true));
            Set projectSecondaryIUs = project.getDependencyMetadata(false);
            if (!projectSecondaryIUs.isEmpty()) {
                availableUnits = new LinkedHashSet<IInstallableUnit>(availableUnits);
                availableUnits.addAll(projectSecondaryIUs);
            }
        } else {
            strategy.setRootInstallableUnits(Collections.<IInstallableUnit>emptySet());
        }
        strategy.setAdditionalRequirements(this.additionalRequirements);
        strategy.setAvailableInstallableUnits(availableUnits);
        strategy.setEEResolutionHints(this.context.getEEResolutionHints());
        strategy.setAdditionalFilterProperties(this.additionalFilterProperties);
        Collection<IInstallableUnit> newState = strategy.resolve(environment, this.monitor);
        if (this.usedTargetPlatformUnits != null) {
            this.usedTargetPlatformUnits.addAll(newState);
        }
        return this.toResolutionResult(newState, project);
    }

    private P2ResolutionResult toResolutionResult(Collection<IInstallableUnit> newState, ReactorProject currentProject) {
        DefaultP2ResolutionResult result = new DefaultP2ResolutionResult();
        TreeSet<String> missingArtifacts = new TreeSet<String>();
        for (IInstallableUnit iu : newState) {
            this.addUnit(result, iu, currentProject, missingArtifacts);
        }
        result.removeEntriesWithUnknownType();
        this.context.saveLocalMavenRepository();
        this.failIfArtifactsMissing(missingArtifacts);
        this.collectNonReactorIUs(result, newState);
        return result;
    }

    private void addUnit(DefaultP2ResolutionResult result, IInstallableUnit iu, ReactorProject currentProject, Set<String> missingArtifacts) {
        if (this.currentProjectUnits.contains(iu)) {
            this.addReactorProject(result, currentProject.getIdentities(), iu);
            return;
        }
        ReactorProjectIdentities otherProject = this.reactorProjectLookup.get(iu);
        if (otherProject != null) {
            this.addReactorProject(result, otherProject, iu);
            return;
        }
        IArtifactFacade mavenArtifact = this.mavenArtifactLookup.get(iu);
        if (mavenArtifact != null) {
            this.addExternalMavenArtifact(result, mavenArtifact, iu);
            return;
        }
        for (IArtifactKey key : iu.getArtifacts()) {
            File artifactLocation = this.context.getLocalArtifactFile(key);
            if (artifactLocation == null) {
                missingArtifacts.add(key.toString());
                continue;
            }
            this.addArtifactFile(result, iu, key, artifactLocation);
        }
    }

    private void failIfArtifactsMissing(Set<String> missingArtifacts) {
        if (!missingArtifacts.isEmpty()) {
            this.logger.error("The following artifacts could not be downloaded: ");
            for (String missingArtifact : missingArtifacts) {
                this.logger.error("  " + missingArtifact);
            }
            throw new RuntimeException("Some required artifacts could not be downloaded. See log output for details.");
        }
    }

    private void collectNonReactorIUs(DefaultP2ResolutionResult result, Collection<IInstallableUnit> newState) {
        for (IInstallableUnit iu : newState) {
            if (this.currentProjectUnits.contains(iu) || this.reactorProjectLookup.get(iu) != null) continue;
            result.addNonReactorUnit(iu);
        }
    }

    private void addArtifactFile(DefaultP2ResolutionResult result, IInstallableUnit iu, IArtifactKey key, File artifactLocation) {
        String featureId;
        String id = iu.getId();
        String version = iu.getVersion().toString();
        String mavenClassifier = null;
        if (CAPABILITY_NS_OSGI_BUNDLE.equals(key.getClassifier())) {
            result.addArtifact("eclipse-plugin", id, version, artifactLocation, mavenClassifier, iu);
        } else if ("org.eclipse.update.feature".equals(key.getClassifier()) && (featureId = this.getFeatureId(iu)) != null) {
            result.addArtifact("eclipse-feature", featureId, version, artifactLocation, mavenClassifier, iu);
        }
    }

    private void addReactorProject(DefaultP2ResolutionResult result, ReactorProjectIdentities project, IInstallableUnit iu) {
        String id = iu.getId();
        String version = iu.getVersion().toString();
        String mavenClassifier = iu.getProperty("maven-classifier");
        File location = project.getBasedir();
        this.addMavenArtifact(result, iu, id, version, mavenClassifier, location);
    }

    private void addExternalMavenArtifact(DefaultP2ResolutionResult result, IArtifactFacade mavenArtifact, IInstallableUnit iu) {
        String id = iu.getId();
        String version = iu.getVersion().toString();
        String mavenClassifier = iu.getProperty("maven-classifier");
        File location = mavenArtifact.getLocation();
        this.addMavenArtifact(result, iu, id, version, mavenClassifier, location);
    }

    protected void addMavenArtifact(DefaultP2ResolutionResult result, IInstallableUnit iu, String id, String version, String mavenClassifier, File location) {
        String contributingArtifactId;
        String contributingArtifactType;
        if (this.isBundleOrFragmentWithId(iu, id)) {
            contributingArtifactType = "eclipse-plugin";
            contributingArtifactId = id;
        } else {
            String featureId = this.getFeatureId(iu);
            if (featureId != null) {
                contributingArtifactType = "eclipse-feature";
                contributingArtifactId = featureId;
            } else if (this.isProduct(iu)) {
                contributingArtifactType = "eclipse-product";
                contributingArtifactId = id;
            } else {
                contributingArtifactType = null;
                contributingArtifactId = null;
            }
        }
        result.addArtifact(contributingArtifactType, contributingArtifactId, version, location, mavenClassifier, iu);
    }

    private String getFeatureId(IInstallableUnit iu) {
        for (IProvidedCapability provided : iu.getProvidedCapabilities()) {
            if (!"org.eclipse.update.feature".equals(provided.getNamespace())) continue;
            return provided.getName();
        }
        return null;
    }

    private boolean isBundleOrFragmentWithId(IInstallableUnit iu, String id) {
        for (IProvidedCapability provided : iu.getProvidedCapabilities()) {
            if (!CAPABILITY_NS_OSGI_BUNDLE.equals(provided.getNamespace()) && !"osgi.fragment".equals(provided.getNamespace())) continue;
            return id.equals(provided.getName());
        }
        return false;
    }

    private boolean isProduct(IInstallableUnit iu) {
        return Boolean.parseBoolean(iu.getProperty("org.eclipse.equinox.p2.type.product"));
    }

    public void setEnvironments(List<TargetEnvironment> environments) {
        if (environments == null) {
            throw new NullPointerException();
        }
        this.environments = environments;
    }

    public void setAdditionalFilterProperties(Map<String, String> additionalFilterProperties) {
        if (additionalFilterProperties == null) {
            throw new NullPointerException();
        }
        this.additionalFilterProperties = additionalFilterProperties;
    }

    public void addDependency(String type, String id, String versionRange) {
        if ("p2-installable-unit".equals(type)) {
            this.additionalRequirements.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)new VersionRange(versionRange), null, (boolean)false, (boolean)true));
        } else if ("eclipse-plugin".equals(type)) {
            this.additionalRequirements.add(MetadataFactory.createRequirement((String)CAPABILITY_NS_OSGI_BUNDLE, (String)id, (VersionRange)new VersionRange(versionRange), null, (boolean)false, (boolean)true));
        } else if ("eclipse-feature".equals(type)) {
            this.additionalRequirements.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)(String.valueOf(id) + ".feature.group"), (VersionRange)new VersionRange(versionRange), null, (boolean)false, (boolean)true));
        }
    }

    public List<IRequirement> getAdditionalRequirements() {
        return this.additionalRequirements;
    }

    public P2ResolutionResult resolveInstallableUnit(TargetPlatform targetPlatform, String id, String versionRange) {
        this.setContext(targetPlatform, null);
        QueryableCollection queriable = new QueryableCollection(this.context.getInstallableUnits());
        VersionRange range = new VersionRange(versionRange);
        IRequirement requirement = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)range, null, (int)1, (int)Integer.MAX_VALUE, (boolean)false);
        IQueryResult result = queriable.query(QueryUtil.createLatestQuery((IQuery)QueryUtil.createMatchQuery((IExpression)requirement.getMatches(), (Object[])new Object[0])), this.monitor);
        Set newState = result.toUnmodifiableSet();
        return this.toResolutionResult(newState, null);
    }
}

