/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.remote;

import java.net.URI;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.tycho.core.facade.MavenLogger;
import org.eclipse.tycho.p2.remote.RemoteRepositoryLoadingHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RemoteMetadataRepositoryManager
implements IMetadataRepositoryManager {
    private final IMetadataRepositoryManager delegate;
    private final RemoteRepositoryLoadingHelper loadingHelper;
    private final MavenLogger logger;

    RemoteMetadataRepositoryManager(IMetadataRepositoryManager delegate, RemoteRepositoryLoadingHelper loadingHelper, MavenLogger logger) {
        this.delegate = delegate;
        this.loadingHelper = loadingHelper;
        this.logger = logger;
    }

    private URI translate(URI location) {
        return this.loadingHelper.getEffectiveLocation(location);
    }

    private URI translateAndPrepareLoad(URI location) throws ProvisionException {
        return this.loadingHelper.getEffectiveLocationAndPrepareLoad(location);
    }

    public IMetadataRepository loadRepository(URI location, IProgressMonitor monitor) throws ProvisionException, OperationCanceledException {
        return this.loadRepository(location, 0, monitor);
    }

    public IMetadataRepository loadRepository(URI location, int flags, IProgressMonitor monitor) throws ProvisionException, OperationCanceledException {
        URI effectiveLocation = this.translateAndPrepareLoad(location);
        IMetadataRepository loadedRepository = this.delegate.loadRepository(effectiveLocation, flags, monitor);
        this.failIfRepositoryContainsPartialIUs(loadedRepository, effectiveLocation);
        return loadedRepository;
    }

    private void failIfRepositoryContainsPartialIUs(IMetadataRepository repository, URI effectiveLocation) throws ProvisionException {
        IQueryResult allUnits = repository.query(QueryUtil.ALL_UNITS, null);
        boolean hasPartialIUs = false;
        for (IInstallableUnit unit : allUnits.toUnmodifiableSet()) {
            if (!Boolean.valueOf(unit.getProperty("org.eclipse.equinox.p2.partial.iu")).booleanValue()) continue;
            hasPartialIUs = true;
            this.logger.error("Partial IU: " + unit.getId());
        }
        if (hasPartialIUs) {
            String message = "The p2 repository at " + effectiveLocation + " contains partial IUs (see above) from an old style update site which cannot be used for dependency resolution";
            throw new ProvisionException(message);
        }
    }

    public void addRepository(URI location) {
        this.delegate.addRepository(this.translate(location));
    }

    public boolean contains(URI location) {
        return this.delegate.contains(this.translate(location));
    }

    public IMetadataRepository createRepository(URI location, String name, String type, Map<String, String> properties) throws ProvisionException, OperationCanceledException {
        return this.delegate.createRepository(this.translate(location), name, type, properties);
    }

    public IProvisioningAgent getAgent() {
        return this.delegate.getAgent();
    }

    public URI[] getKnownRepositories(int flags) {
        return this.delegate.getKnownRepositories(flags);
    }

    public String getRepositoryProperty(URI location, String key) {
        return this.delegate.getRepositoryProperty(this.translate(location), key);
    }

    public boolean isEnabled(URI location) {
        return this.delegate.isEnabled(this.translate(location));
    }

    public IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
        return this.delegate.query(query, monitor);
    }

    public IMetadataRepository refreshRepository(URI location, IProgressMonitor monitor) throws ProvisionException, OperationCanceledException {
        return this.delegate.refreshRepository(this.translateAndPrepareLoad(location), monitor);
    }

    public boolean removeRepository(URI location) {
        return this.delegate.removeRepository(this.translate(location));
    }

    public void setEnabled(URI location, boolean enablement) {
        this.delegate.setEnabled(this.translate(location), enablement);
    }

    public void setRepositoryProperty(URI location, String key, String value) {
        this.delegate.setRepositoryProperty(this.translate(location), key, value);
    }
}

