/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.tycho.core.facade.MavenContext;
import org.eclipse.tycho.core.facade.MavenLogger;
import org.eclipse.tycho.p2.impl.resolver.ClassifiedLocation;
import org.eclipse.tycho.p2.maven.repository.xmlio.MetadataIO;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.eclipse.tycho.p2.repository.GAV;
import org.eclipse.tycho.p2.target.TargetPlatformBundlePublisher;
import org.eclipse.tycho.p2.target.facade.PomDependencyCollector;
import org.eclipse.tycho.repository.p2base.artifact.provider.IRawArtifactFileProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PomDependencyCollectorImpl
implements PomDependencyCollector {
    private final TargetPlatformBundlePublisher bundlesPublisher;
    private final MavenLogger logger;
    private Map<IInstallableUnit, IArtifactFacade> mavenInstallableUnits = new HashMap<IInstallableUnit, IArtifactFacade>();
    private File projectLocation;

    public PomDependencyCollectorImpl(MavenContext mavenContext) {
        this.logger = mavenContext.getLogger();
        File localRepositoryRoot = mavenContext.getLocalRepositoryRoot();
        this.bundlesPublisher = new TargetPlatformBundlePublisher(localRepositoryRoot, mavenContext.getLogger());
    }

    public void setProjectLocation(File projectLocation) {
        this.projectLocation = projectLocation;
    }

    public File getProjectLocation() {
        return this.projectLocation;
    }

    public void publishAndAddArtifactIfBundleArtifact(IArtifactFacade artifact) {
        IInstallableUnit bundleIU = this.bundlesPublisher.attemptToPublishBundle(artifact);
        if (bundleIU != null) {
            this.addMavenArtifact(new ClassifiedLocation(artifact), artifact, Collections.singleton(bundleIU));
        }
    }

    public void addArtifactWithExistingMetadata(IArtifactFacade artifact, IArtifactFacade p2MetadataFile) {
        try {
            this.addMavenArtifact(new ClassifiedLocation(artifact), artifact, this.readUnits(p2MetadataFile));
        }
        catch (IOException e) {
            throw new RuntimeException("failed to read p2 metadata", e);
        }
    }

    private Set<IInstallableUnit> readUnits(IArtifactFacade p2MetadataFile) throws IOException {
        FileInputStream inputStream = new FileInputStream(p2MetadataFile.getLocation());
        try {
            MetadataIO io = new MetadataIO();
            Set set = io.readXML((InputStream)inputStream);
            return set;
        }
        finally {
            inputStream.close();
        }
    }

    public void addMavenArtifact(ClassifiedLocation key, IArtifactFacade artifact, Set<IInstallableUnit> units) {
        for (IInstallableUnit unit : units) {
            String classifier = unit.getProperty("maven-classifier");
            if (!(classifier == null ? key.getClassifier() == null : classifier.equals(key.getClassifier()))) continue;
            this.mavenInstallableUnits.put(unit, artifact);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("P2Resolver: artifact " + new GAV(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()).toString() + " at location " + artifact.getLocation() + " resolves installable unit " + new VersionedId(unit.getId(), unit.getVersion()));
        }
    }

    LinkedHashSet<IInstallableUnit> gatherMavenInstallableUnits() {
        return new LinkedHashSet<IInstallableUnit>(this.getMavenInstallableUnits().keySet());
    }

    Map<IInstallableUnit, IArtifactFacade> getMavenInstallableUnits() {
        return this.mavenInstallableUnits;
    }

    IRawArtifactFileProvider getArtifactRepoOfPublishedBundles() {
        return this.bundlesPublisher.getArtifactRepoOfPublishedBundles();
    }
}

