/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.ReactorProjectIdentities;
import org.eclipse.tycho.artifacts.p2.P2TargetPlatform;
import org.eclipse.tycho.core.facade.MavenLogger;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.eclipse.tycho.p2.resolver.ExecutionEnvironmentResolutionHints;
import org.eclipse.tycho.p2.target.filters.TargetPlatformFilterEvaluator;
import org.eclipse.tycho.repository.local.LocalArtifactRepository;
import org.eclipse.tycho.repository.local.LocalMetadataRepository;
import org.eclipse.tycho.repository.p2base.artifact.provider.IRawArtifactFileProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetPlatformImpl
implements P2TargetPlatform {
    private final Collection<IInstallableUnit> externalIUs;
    private final ExecutionEnvironmentResolutionHints executionEnvironment;
    private final Map<IInstallableUnit, IArtifactFacade> mavenArtifactIUs;
    private final Collection<ReactorProject> reactorProjects;
    private final LocalMetadataRepository localMetadataRepository;
    private final IRawArtifactFileProvider jointArtifacts;
    @Deprecated
    private LocalArtifactRepository localArtifactRepository;
    private final MavenLogger logger;
    private final TargetPlatformFilterEvaluator filter;
    private boolean includeLocalRepo;

    public TargetPlatformImpl(Collection<ReactorProject> reactorProjects, Collection<IInstallableUnit> ius, Map<IInstallableUnit, IArtifactFacade> mavenArtifactIUs, ExecutionEnvironmentResolutionHints executionEnvironment, TargetPlatformFilterEvaluator filter, LocalMetadataRepository localMetadataRepository, IRawArtifactFileProvider jointArtifacts, LocalArtifactRepository localArtifactRepository, boolean includeLocalRepo, MavenLogger logger) {
        this.reactorProjects = reactorProjects;
        this.externalIUs = ius;
        this.executionEnvironment = executionEnvironment;
        this.mavenArtifactIUs = mavenArtifactIUs;
        this.filter = filter;
        this.localMetadataRepository = localMetadataRepository;
        this.includeLocalRepo = includeLocalRepo;
        this.jointArtifacts = jointArtifacts;
        this.localArtifactRepository = localArtifactRepository;
        this.logger = logger;
    }

    @Override
    public Set<IInstallableUnit> getInstallableUnits() {
        LinkedHashSet<IInstallableUnit> allius = new LinkedHashSet<IInstallableUnit>();
        allius.addAll(this.getReactorProjectIUs().keySet());
        allius.addAll(this.externalIUs);
        allius.addAll(this.mavenArtifactIUs.keySet());
        allius.addAll(this.executionEnvironment.getMandatoryUnits());
        return Collections.unmodifiableSet(allius);
    }

    public Map<IInstallableUnit, ReactorProjectIdentities> getReactorProjectIUs() {
        LinkedHashMap<IInstallableUnit, ReactorProjectIdentities> allius = new LinkedHashMap<IInstallableUnit, ReactorProjectIdentities>();
        for (ReactorProject project : this.reactorProjects) {
            Set projectUnits = project.getDependencyMetadata();
            if (projectUnits == null) continue;
            for (Object iu : projectUnits) {
                allius.put((IInstallableUnit)iu, project.getIdentities());
            }
        }
        this.filterUnits(allius.keySet());
        return Collections.unmodifiableMap(allius);
    }

    private void filterUnits(Collection<IInstallableUnit> keySet) {
        if (this.filter != null) {
            this.filter.filterUnits(keySet);
        }
    }

    @Override
    public ExecutionEnvironmentResolutionHints getEEResolutionHints() {
        return this.executionEnvironment;
    }

    @Override
    public Map<IInstallableUnit, ReactorProjectIdentities> getOriginalReactorProjectMap() {
        return this.getReactorProjectIUs();
    }

    @Override
    public Map<IInstallableUnit, IArtifactFacade> getOriginalMavenArtifactMap() {
        return this.mavenArtifactIUs;
    }

    @Override
    public File getLocalArtifactFile(IArtifactKey key) {
        return this.jointArtifacts.getArtifactFile(key);
    }

    @Override
    public void saveLocalMavenRepository() {
        this.localArtifactRepository.save();
    }

    @Override
    public void reportUsedLocalIUs(Collection<IInstallableUnit> usedUnits) {
        if (!this.includeLocalRepo) {
            return;
        }
        Set localIUs = this.localMetadataRepository.query(QueryUtil.ALL_UNITS, null).toSet();
        localIUs.retainAll(usedUnits);
        Iterator iterator = localIUs.iterator();
        while (iterator.hasNext()) {
            if (!this.executionEnvironment.isNonApplicableEEUnit((IInstallableUnit)iterator.next())) continue;
            iterator.remove();
        }
        if (!localIUs.isEmpty()) {
            this.logger.warn("The following locally built units have been used to resolve project dependencies:");
            for (IInstallableUnit localIu : localIUs) {
                this.logger.warn("  " + localIu.getId() + "/" + localIu.getVersion());
            }
        }
    }
}

