/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.publisher.rootfiles;

import java.io.File;
import org.eclipse.tycho.p2.impl.publisher.rootfiles.FileSet;
import org.eclipse.tycho.p2.impl.publisher.rootfiles.RootFilesProperties;

public class RootFilePatternParser {
    private final File baseDir;
    private final RootFilesProperties target;
    private boolean useDefaultExcludes;

    public RootFilePatternParser(File baseDir, RootFilesProperties target, boolean useDefaultExcludes) {
        this.baseDir = baseDir;
        this.target = target;
        this.useDefaultExcludes = useDefaultExcludes;
    }

    void addFilesFromPatterns(String[] paths) {
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            RootFilePath rootFilePath = new RootFilePath(path, this.baseDir);
            this.target.addFiles(rootFilePath.toFileSet(this.useDefaultExcludes).scan());
            ++n2;
        }
    }

    static class RootFilePath {
        private static final String ABSOLUTE_PREFIX = "absolute:";
        private static final String FILE_PREFIX = "file:";
        private String path;
        private File baseDir;
        private boolean isAbsolute = false;
        private boolean isFile = false;

        public RootFilePath(String path, File baseDir) {
            this.path = this.parse(path);
            this.baseDir = baseDir;
        }

        public FileSet toFileSet(boolean useDefaultExcludes) {
            String pattern;
            File fileSetBasedir;
            File file;
            File file2 = file = this.isAbsolute ? new File(this.path) : new File(this.baseDir, this.path);
            if (this.isFile) {
                fileSetBasedir = file.getParentFile();
                pattern = file.getName();
            } else {
                fileSetBasedir = file;
                pattern = "**/*";
            }
            return new FileSet(fileSetBasedir, pattern, useDefaultExcludes);
        }

        private String parse(String path) {
            if (path.startsWith(ABSOLUTE_PREFIX)) {
                this.isAbsolute = true;
                path = path.substring(ABSOLUTE_PREFIX.length());
            }
            if (path.startsWith(FILE_PREFIX)) {
                this.isFile = true;
                path = path.substring(FILE_PREFIX.length());
            }
            return path;
        }
    }
}

