/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.publisher.rootfiles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.tycho.p2.impl.publisher.rootfiles.FileToPathMap;
import org.eclipse.tycho.p2.impl.publisher.rootfiles.SegmentHelper;
import org.eclipse.tycho.p2.impl.publisher.rootfiles.VirtualFileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootFilesProperties {
    private FileToPathMap fileSourceToDestinationMap = new FileToPathMap();
    private List<Permission> permissions = new ArrayList<Permission>();
    private StringBuilder links = new StringBuilder();

    public FileToPathMap getFileMap() {
        return this.fileSourceToDestinationMap;
    }

    public void addFiles(FileToPathMap fileSourceToDestinationMap) {
        this.fileSourceToDestinationMap.putAll(fileSourceToDestinationMap);
    }

    public Collection<Permission> getPermissions() {
        return this.permissions;
    }

    public void addPermission(String chmodPermissionPattern, String[] pathsInInstallation) {
        String[] stringArray = pathsInInstallation;
        int n = pathsInInstallation.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            this.permissions.add(new Permission(path, chmodPermissionPattern));
            ++n2;
        }
    }

    public String getLinks() {
        return this.links.toString();
    }

    public void addLinks(String[] linkValueSegments) {
        RootFilesProperties.verifySpecifiedInPairs(linkValueSegments);
        String[] stringArray = linkValueSegments;
        int n = linkValueSegments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            this.addLinkSegment(segment);
            ++n2;
        }
    }

    public void resolvePermissionWildcards(boolean useDefaultExcludes) {
        Collection<IPath> allFilePaths = this.fileSourceToDestinationMap.values();
        for (Permission permission : this.permissions) {
            permission.resolveWildcards(allFilePaths, useDefaultExcludes);
        }
    }

    private static void verifySpecifiedInPairs(String[] linkValueSegments) {
        if (linkValueSegments.length % 2 != 0) {
            String message = "Links must be specified as a sequence of \"link target,link name\" pairs; the actual value \"" + SegmentHelper.segmentsToString(linkValueSegments, ',') + "\" contains an odd number of segments";
            throw new IllegalArgumentException(message);
        }
    }

    private void addLinkSegment(String segment) {
        if (this.links.length() > 0) {
            this.links.append(',');
        }
        this.links.append(segment);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Permission {
        private final String pathPattern;
        private Set<String> resolvedPaths;
        private final String chmodPermissions;
        private boolean isResolved = false;

        public Permission(String pathPattern, String chmodPermissions) {
            this.pathPattern = pathPattern;
            this.chmodPermissions = chmodPermissions;
        }

        void resolveWildcards(Collection<IPath> virtualFiles, boolean useDefaultExcludes) {
            this.resolvedPaths = new HashSet<String>();
            VirtualFileSet virtualFileSet = new VirtualFileSet(this.pathPattern, virtualFiles, useDefaultExcludes);
            for (IPath path : virtualFileSet.getMatchingPaths()) {
                this.resolvedPaths.add(path.toString());
            }
            this.isResolved = true;
        }

        public List<String[]> toP2Formats() {
            if (!this.isResolved) {
                throw new IllegalStateException("must call resolveWildcards() first");
            }
            ArrayList<String[]> p2Formats = new ArrayList<String[]>(this.resolvedPaths.size());
            for (String resolvedPath : this.resolvedPaths) {
                String[] p2Format = new String[]{this.chmodPermissions, resolvedPath};
                p2Formats.add(p2Format);
            }
            return p2Formats;
        }
    }
}

