/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.remote;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.tycho.core.facade.MavenLogger;
import org.eclipse.tycho.core.resolver.shared.MavenRepositoryLocation;
import org.eclipse.tycho.core.resolver.shared.MavenRepositorySettings;
import org.eclipse.tycho.p2.remote.IRepositoryIdManager;
import org.eclipse.tycho.p2.remote.P2PasswordUtil;

class RemoteRepositoryLoadingHelper
implements IRepositoryIdManager {
    private final MavenRepositorySettings settings;
    private final MavenLogger logger;
    private Map<URI, String> knownMavenRepositoryIds = new HashMap<URI, String>();

    public RemoteRepositoryLoadingHelper(MavenRepositorySettings settings, MavenLogger logger) {
        this.settings = settings;
        this.logger = logger;
    }

    public void addMapping(String mavenRepositoryId, URI location) {
        if (mavenRepositoryId == null) {
            return;
        }
        URI key = RemoteRepositoryLoadingHelper.normalize(location);
        String previousValue = this.knownMavenRepositoryIds.put(key, mavenRepositoryId);
        if (previousValue != null && !mavenRepositoryId.equals(previousValue)) {
            this.logger.warn("p2 repository with URL " + key + " is associated with multiple IDs; was '" + previousValue + "', now is '" + mavenRepositoryId + "'");
        }
    }

    private static URI normalize(URI location) {
        try {
            String path = location.getPath();
            if (path != null && path.endsWith("/")) {
                return new URI(location.getScheme(), location.getAuthority(), path.substring(0, path.length() - 1), location.getQuery(), location.getFragment());
            }
            return location;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public URI getEffectiveLocation(URI location) {
        if (RemoteRepositoryLoadingHelper.certainlyNoRemoteURL(location)) {
            return location;
        }
        MavenRepositoryLocation effectiveLocation = this.effectiveLocationFor(location, false);
        return effectiveLocation.getURL();
    }

    public URI getEffectiveLocationAndPrepareLoad(URI location) throws ProvisionException {
        if (RemoteRepositoryLoadingHelper.certainlyNoRemoteURL(location)) {
            return location;
        }
        MavenRepositoryLocation effectiveLocation = this.effectiveLocationFor(location, true);
        this.setPasswordForLoading(effectiveLocation);
        return effectiveLocation.getURL();
    }

    private MavenRepositoryLocation effectiveLocationFor(URI location, boolean forLoading) {
        MavenRepositoryLocation locationWithID;
        MavenRepositoryLocation mirror;
        URI normalizedLocation = RemoteRepositoryLoadingHelper.normalize(location);
        String id = this.knownMavenRepositoryIds.get(normalizedLocation);
        if (id == null) {
            id = normalizedLocation.toString();
        }
        if ((mirror = this.settings.getMirror(locationWithID = new MavenRepositoryLocation(id, normalizedLocation))) != null) {
            if (forLoading) {
                this.logger.info("Loading repository '" + id + "' from mirror '" + mirror.getId() + "' at '" + mirror.getURL() + "'");
            }
            return mirror;
        }
        return locationWithID;
    }

    private void setPasswordForLoading(MavenRepositoryLocation location) throws ProvisionException {
        MavenRepositorySettings.Credentials credentials = this.settings.getCredentials(location);
        if (credentials != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Setting credentials for p2 repository '" + location.getId() + "'");
            }
            P2PasswordUtil.setCredentials(location.getURL(), credentials.getUserName(), credentials.getPassword(), this.logger);
        }
    }

    private static boolean certainlyNoRemoteURL(URI location) {
        return location.isOpaque() || !location.isAbsolute();
    }
}

