/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.CompoundQueryable;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tycho.core.facade.MavenLogger;
import org.eclipse.tycho.core.facade.TargetEnvironment;
import org.eclipse.tycho.p2.remote.IRepositoryIdManager;
import org.eclipse.tycho.p2.target.TargetDefinitionContent;
import org.eclipse.tycho.p2.target.facade.TargetDefinition;
import org.eclipse.tycho.p2.target.facade.TargetDefinitionResolutionException;
import org.eclipse.tycho.p2.target.facade.TargetDefinitionSyntaxException;
import org.eclipse.tycho.p2.util.resolution.AbstractResolutionStrategy;
import org.eclipse.tycho.p2.util.resolution.ExecutionEnvironmentResolutionHints;
import org.eclipse.tycho.p2.util.resolution.ProjectorResolutionStrategy;
import org.eclipse.tycho.p2.util.resolution.SlicerResolutionStrategy;
import org.eclipse.tycho.repository.util.DuplicateFilteringLoggingProgressMonitor;
import org.eclipse.tycho.repository.util.StatusTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetDefinitionResolver {
    private IMetadataRepositoryManager metadataManager;
    private IRepositoryIdManager repositoryIdManager;
    private final MavenLogger logger;
    private final List<TargetEnvironment> environments;
    private final ExecutionEnvironmentResolutionHints executionEnvironment;
    private final IProgressMonitor monitor;

    public TargetDefinitionResolver(List<TargetEnvironment> environments, ExecutionEnvironmentResolutionHints executionEnvironment, IProvisioningAgent agent, MavenLogger logger) {
        this.environments = environments;
        this.executionEnvironment = executionEnvironment;
        this.logger = logger;
        this.monitor = new DuplicateFilteringLoggingProgressMonitor(logger);
        this.metadataManager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        this.repositoryIdManager = (IRepositoryIdManager)agent.getService(IRepositoryIdManager.SERVICE_NAME);
    }

    public TargetDefinitionContent resolveContent(TargetDefinition definition) {
        try {
            return this.resolveContentWithExceptions(definition);
        }
        catch (TargetDefinitionSyntaxException e) {
            throw new RuntimeException("Invalid syntax in target definition " + definition.getOrigin() + ": " + e.getMessage(), e);
        }
        catch (TargetDefinitionResolutionException e) {
            throw new RuntimeException("Failed to resolve target definition " + definition.getOrigin(), e);
        }
    }

    TargetDefinitionContent resolveContentWithExceptions(TargetDefinition definition) throws TargetDefinitionSyntaxException, TargetDefinitionResolutionException {
        Collection<IInstallableUnit> units;
        ArrayList<URI> artifactRepositories = new ArrayList<URI>();
        LinkedHashSet<IInstallableUnit> availableUnits = new LinkedHashSet<IInstallableUnit>();
        LinkedHashSet<IInstallableUnit> rootIUs = new LinkedHashSet<IInstallableUnit>();
        TargetDefinition.IncludeMode includeMode = null;
        Boolean includeAllEnvironments = null;
        for (TargetDefinition.Location locationDefinition : definition.getLocations()) {
            if (locationDefinition instanceof TargetDefinition.InstallableUnitLocation) {
                TargetDefinition.InstallableUnitLocation iuLocationDefinition = (TargetDefinition.InstallableUnitLocation)locationDefinition;
                if (includeMode != null && includeMode != iuLocationDefinition.getIncludeMode()) {
                    throw new TargetDefinitionResolutionException("Include mode must be the same for all locations");
                }
                includeMode = iuLocationDefinition.getIncludeMode();
                if (includeAllEnvironments != null && includeAllEnvironments.booleanValue() != iuLocationDefinition.includeAllEnvironments()) {
                    throw new TargetDefinitionResolutionException("The attribute 'includeAllPlatforms' must be the same for all locations");
                }
                includeAllEnvironments = iuLocationDefinition.includeAllEnvironments();
                ArrayList<IMetadataRepository> metadataRepositories = new ArrayList<IMetadataRepository>();
                for (TargetDefinition.Repository repository : iuLocationDefinition.getRepositories()) {
                    this.repositoryIdManager.addMapping(repository.getId(), repository.getLocation());
                    artifactRepositories.add(repository.getLocation());
                    metadataRepositories.add(this.loadRepository(repository));
                }
                CompoundQueryable locationUnits = new CompoundQueryable((IQueryable[])metadataRepositories.toArray(new IMetadataRepository[metadataRepositories.size()]));
                for (TargetDefinition.Unit unit : iuLocationDefinition.getUnits()) {
                    rootIUs.add(this.getUnitInstance((IQueryable<IInstallableUnit>)locationUnits, unit));
                }
                for (IInstallableUnit unit : locationUnits.query(QueryUtil.ALL_UNITS, this.monitor)) {
                    if (this.executionEnvironment.isNonApplicableEEUnit(unit)) continue;
                    availableUnits.add(unit);
                }
                continue;
            }
            this.logger.warn(NLS.bind((String)"Target location type: {0} is not supported", (Object)locationDefinition.getTypeDescription()));
        }
        if (!availableUnits.isEmpty()) {
            AbstractResolutionStrategy strategy = this.getResolutionStrategy(includeMode, includeAllEnvironments);
            strategy.setRootInstallableUnits(rootIUs);
            strategy.setAvailableInstallableUnits(availableUnits);
            strategy.setEEResolutionHints(this.executionEnvironment);
            units = strategy.multiPlatformResolve(this.environments, this.monitor);
        } else {
            units = Collections.emptySet();
        }
        if (definition.hasIncludedBundles()) {
            this.logger.warn("De-selecting bundles in a target definition file is not supported. See http://wiki.eclipse.org/Tycho_Messages_Explained#Target_File_Include_Bundles for alternatives.");
        }
        return new TargetDefinitionContent(units, artifactRepositories);
    }

    private AbstractResolutionStrategy getResolutionStrategy(TargetDefinition.IncludeMode includeMode, Boolean includeAllEnvironments) throws TargetDefinitionResolutionException {
        switch (includeMode) {
            case PLANNER: {
                return this.getPlannerResolutionStrategy(includeAllEnvironments);
            }
            case SLICER: {
                return this.getSlicerResolutionStrategy(includeAllEnvironments);
            }
        }
        throw new IllegalStateException();
    }

    private AbstractResolutionStrategy getSlicerResolutionStrategy(boolean ignoreFilters) {
        return new SlicerResolutionStrategy(this.logger, ignoreFilters){

            protected RuntimeException newResolutionException(IStatus status) {
                return TargetDefinitionResolver.this.newResolutionException(status);
            }
        };
    }

    private AbstractResolutionStrategy getPlannerResolutionStrategy(boolean includeAllEnvironments) throws TargetDefinitionResolutionException {
        if (includeAllEnvironments) {
            throw new TargetDefinitionResolutionException("includeAllPlatforms='true' and includeMode='planner' are incompatible.");
        }
        return new ProjectorResolutionStrategy(this.logger){

            protected RuntimeException newResolutionException(IStatus status) {
                return TargetDefinitionResolver.this.newResolutionException(status);
            }
        };
    }

    private IMetadataRepository loadRepository(TargetDefinition.Repository repository) throws TargetDefinitionResolutionException {
        try {
            return this.metadataManager.loadRepository(repository.getLocation(), this.monitor);
        }
        catch (ProvisionException e) {
            throw new TargetDefinitionResolutionException("Failed to load p2 metadata repository from location " + repository.getLocation(), (Throwable)e);
        }
    }

    private IInstallableUnit getUnitInstance(IQueryable<IInstallableUnit> units, TargetDefinition.Unit unitReference) throws TargetDefinitionSyntaxException, TargetDefinitionResolutionException {
        IQueryResult<IInstallableUnit> queryResult = this.searchUnitInThisLocation(units, unitReference);
        if (queryResult.isEmpty()) {
            throw new TargetDefinitionResolutionException(NLS.bind((String)"Could not find \"{0}/{1}\" in the repositories of the current location", (Object)unitReference.getId(), (Object)unitReference.getVersion()));
        }
        IInstallableUnit unitInstance = (IInstallableUnit)queryResult.iterator().next();
        return unitInstance;
    }

    private IQueryResult<IInstallableUnit> searchUnitInThisLocation(IQueryable<IInstallableUnit> units, TargetDefinition.Unit unitReference) throws TargetDefinitionSyntaxException {
        Version version = this.parseVersion(unitReference);
        IQuery matchingIUQuery = QueryUtil.createIUQuery((String)unitReference.getId(), (Version)version);
        IQuery latestMatchingIUQuery = QueryUtil.createLatestQuery((IQuery)matchingIUQuery);
        IQueryResult queryResult = units.query(latestMatchingIUQuery, this.monitor);
        return queryResult;
    }

    RuntimeException newResolutionException(IStatus status) {
        return new TargetDefinitionResolutionException(StatusTool.collectProblems((IStatus)status), (Throwable)new CoreException(status));
    }

    private Version parseVersion(TargetDefinition.Unit unitReference) throws TargetDefinitionSyntaxException {
        try {
            return Version.parseVersion((String)unitReference.getVersion());
        }
        catch (IllegalArgumentException e) {
            throw new TargetDefinitionSyntaxException(NLS.bind((String)"Cannot parse version \"{0}\" of unit \"{1}\"", (Object)unitReference.getVersion(), (Object)unitReference.getId()), (Throwable)e);
        }
    }
}

