/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.ReactorProjectIdentities;
import org.eclipse.tycho.artifacts.TargetPlatform;
import org.eclipse.tycho.core.ee.shared.ExecutionEnvironmentConfiguration;
import org.eclipse.tycho.core.facade.MavenContext;
import org.eclipse.tycho.core.facade.MavenLogger;
import org.eclipse.tycho.core.resolver.shared.MavenRepositoryLocation;
import org.eclipse.tycho.p2.maven.repository.Activator;
import org.eclipse.tycho.p2.remote.IRepositoryIdManager;
import org.eclipse.tycho.p2.target.DuplicateReactorIUsException;
import org.eclipse.tycho.p2.target.FinalTargetPlatformImpl;
import org.eclipse.tycho.p2.target.P2TargetPlatform;
import org.eclipse.tycho.p2.target.PomDependencyCollectorImpl;
import org.eclipse.tycho.p2.target.PreliminaryTargetPlatformImpl;
import org.eclipse.tycho.p2.target.TargetDefinitionContent;
import org.eclipse.tycho.p2.target.TargetDefinitionResolverService;
import org.eclipse.tycho.p2.target.ee.ExecutionEnvironmentResolutionHandler;
import org.eclipse.tycho.p2.target.facade.PomDependencyCollector;
import org.eclipse.tycho.p2.target.facade.TargetDefinition;
import org.eclipse.tycho.p2.target.facade.TargetPlatformConfigurationStub;
import org.eclipse.tycho.p2.target.facade.TargetPlatformFactory;
import org.eclipse.tycho.p2.target.filters.TargetPlatformFilterEvaluator;
import org.eclipse.tycho.p2.util.resolution.ExecutionEnvironmentResolutionHints;
import org.eclipse.tycho.repository.local.LocalArtifactRepository;
import org.eclipse.tycho.repository.local.LocalMetadataRepository;
import org.eclipse.tycho.repository.local.MirroringArtifactProvider;
import org.eclipse.tycho.repository.p2base.artifact.provider.CompositeArtifactProvider;
import org.eclipse.tycho.repository.p2base.artifact.provider.IRawArtifactFileProvider;
import org.eclipse.tycho.repository.p2base.artifact.provider.IRawArtifactProvider;
import org.eclipse.tycho.repository.p2base.artifact.provider.formats.ArtifactTransferPolicies;
import org.eclipse.tycho.repository.p2base.artifact.repository.ProviderOnlyArtifactRepository;
import org.eclipse.tycho.repository.p2base.artifact.repository.RepositoryArtifactProvider;
import org.eclipse.tycho.repository.publishing.PublishingRepository;
import org.eclipse.tycho.repository.registry.ArtifactRepositoryBlackboard;
import org.eclipse.tycho.repository.registry.facade.RepositoryBlackboardKey;
import org.eclipse.tycho.repository.util.DuplicateFilteringLoggingProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetPlatformFactoryImpl
implements TargetPlatformFactory {
    private final MavenContext mavenContext;
    private final MavenLogger logger;
    private final IProgressMonitor monitor;
    private final IProvisioningAgent remoteAgent;
    private final IRepositoryIdManager remoteRepositoryIdManager;
    private final IMetadataRepositoryManager remoteMetadataRepositoryManager;
    private final IArtifactRepositoryManager remoteArtifactRepositoryManager;
    private final boolean offline;
    private final LocalArtifactRepository localArtifactRepository;
    private final LocalMetadataRepository localMetadataRepository;
    private final TargetDefinitionResolverService targetDefinitionResolverService;

    public TargetPlatformFactoryImpl(MavenContext mavenContext, IProvisioningAgent remoteAgent, LocalArtifactRepository localArtifactRepo, LocalMetadataRepository localMetadataRepo, TargetDefinitionResolverService targetDefinitionResolverService) {
        this.mavenContext = mavenContext;
        this.logger = mavenContext.getLogger();
        this.monitor = new DuplicateFilteringLoggingProgressMonitor(this.logger);
        this.remoteAgent = remoteAgent;
        this.remoteRepositoryIdManager = (IRepositoryIdManager)remoteAgent.getService(IRepositoryIdManager.SERVICE_NAME);
        this.offline = mavenContext.isOffline();
        this.remoteMetadataRepositoryManager = (IMetadataRepositoryManager)remoteAgent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        if (this.remoteMetadataRepositoryManager == null) {
            throw new IllegalStateException("No metadata repository manager found");
        }
        this.remoteArtifactRepositoryManager = (IArtifactRepositoryManager)remoteAgent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        if (this.remoteArtifactRepositoryManager == null) {
            throw new IllegalStateException("No artifact repository manager found");
        }
        this.localMetadataRepository = localMetadataRepo;
        this.localArtifactRepository = localArtifactRepo;
        this.targetDefinitionResolverService = targetDefinitionResolverService;
    }

    public PomDependencyCollector newPomDependencyCollector() {
        return new PomDependencyCollectorImpl(this.mavenContext);
    }

    public P2TargetPlatform createTargetPlatform(TargetPlatformConfigurationStub tpConfiguration, ExecutionEnvironmentConfiguration eeConfiguration, List<ReactorProject> reactorProjects, PomDependencyCollector pomDependencies) {
        return this.createTargetPlatform(tpConfiguration, ExecutionEnvironmentResolutionHandler.adapt(eeConfiguration), reactorProjects, pomDependencies);
    }

    public P2TargetPlatform createTargetPlatform(TargetPlatformConfigurationStub tpConfiguration, ExecutionEnvironmentResolutionHandler eeResolutionHandler, List<ReactorProject> reactorProjects, PomDependencyCollector pomDependencies) {
        List<TargetDefinitionContent> targetFileContent = this.resolveTargetDefinitions(tpConfiguration, eeResolutionHandler.getResolutionHints());
        PomDependencyCollectorImpl pomDependenciesContent = (PomDependencyCollectorImpl)pomDependencies;
        if (pomDependenciesContent == null) {
            pomDependenciesContent = new PomDependencyCollectorImpl(this.mavenContext);
        }
        IRawArtifactFileProvider pomDependencyArtifactRepo = pomDependenciesContent.getArtifactRepoOfPublishedBundles();
        RepositoryBlackboardKey blackboardKey = RepositoryBlackboardKey.forResolutionContextArtifacts((File)pomDependenciesContent.getProjectLocation());
        ArtifactRepositoryBlackboard.putRepository((RepositoryBlackboardKey)blackboardKey, (IArtifactRepository)new ProviderOnlyArtifactRepository(pomDependencyArtifactRepo, Activator.getProvisioningAgent(), blackboardKey.toURI()));
        this.logger.debug("Registered artifact repository " + blackboardKey);
        Set completeRepositories = tpConfiguration.getP2Repositories();
        this.registerRepositoryIDs(completeRepositories);
        boolean includeLocalMavenRepo = this.shouldIncludeLocallyInstalledUnits(tpConfiguration);
        LinkedHashSet<IInstallableUnit> externalUIs = this.gatherExternalInstallableUnits(completeRepositories, targetFileContent, pomDependenciesContent, includeLocalMavenRepo);
        Map<IInstallableUnit, ReactorProjectIdentities> reactorProjectUIs = this.getPreliminaryReactorProjectUIs(reactorProjects);
        List iuFilters = tpConfiguration.getFilters();
        TargetPlatformFilterEvaluator filter = !iuFilters.isEmpty() ? new TargetPlatformFilterEvaluator(iuFilters, this.logger) : null;
        TargetPlatformFactoryImpl.applyConfiguredFilter(filter, reactorProjectUIs.keySet());
        this.applyFilters(filter, externalUIs, reactorProjectUIs.keySet(), eeResolutionHandler.getResolutionHints());
        PreliminaryTargetPlatformImpl targetPlatform = new PreliminaryTargetPlatformImpl(reactorProjectUIs, externalUIs, pomDependenciesContent.getMavenInstallableUnits(), eeResolutionHandler.getResolutionHints(), filter, this.localMetadataRepository, this.createJointArtifactProvider(completeRepositories, targetFileContent, pomDependencyArtifactRepo, tpConfiguration.getIncludePackedArtifacts()), this.localArtifactRepository, includeLocalMavenRepo, this.logger);
        eeResolutionHandler.readFullSpecification(targetPlatform.getInstallableUnits());
        return targetPlatform;
    }

    private List<TargetDefinitionContent> resolveTargetDefinitions(TargetPlatformConfigurationStub tpConfiguration, ExecutionEnvironmentResolutionHints eeResolutionHints) {
        ArrayList<TargetDefinitionContent> result = new ArrayList<TargetDefinitionContent>();
        for (TargetDefinition definition : tpConfiguration.getTargetDefinitions()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Adding target definition file \"" + definition.getOrigin() + "\"");
            }
            TargetDefinitionContent targetFileContent = this.targetDefinitionResolverService.getTargetDefinitionContent(definition, tpConfiguration.getEnvironments(), eeResolutionHints, this.remoteAgent);
            result.add(targetFileContent);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("Added " + targetFileContent.getUnits().size() + " units, the content of the target definition file, to the target platform");
        }
        return result;
    }

    private void registerRepositoryIDs(Set<MavenRepositoryLocation> repositoriesWithIDs) {
        for (MavenRepositoryLocation location : repositoriesWithIDs) {
            this.remoteRepositoryIdManager.addMapping(location.getId(), location.getURL());
        }
    }

    private boolean shouldIncludeLocallyInstalledUnits(TargetPlatformConfigurationStub tpConfiguration) {
        if (tpConfiguration.getForceIgnoreLocalArtifacts()) {
            return false;
        }
        boolean ignoreLocal = "ignore".equalsIgnoreCase(this.mavenContext.getSessionProperties().getProperty("tycho.localArtifacts"));
        if (ignoreLocal) {
            this.logger.debug("tycho.localArtifacts=" + this.mavenContext.getSessionProperties().getProperty("tycho.localArtifacts") + " -> ignoring locally built artifacts");
            return false;
        }
        return true;
    }

    private LinkedHashSet<IInstallableUnit> gatherExternalInstallableUnits(Set<MavenRepositoryLocation> completeRepositories, List<TargetDefinitionContent> targetDefinitionsContent, PomDependencyCollectorImpl pomDependenciesContent, boolean includeLocalMavenRepo) {
        LinkedHashSet<IInstallableUnit> result = new LinkedHashSet<IInstallableUnit>();
        for (TargetDefinitionContent targetDefinitionContent : targetDefinitionsContent) {
            result.addAll(targetDefinitionContent.getUnits());
        }
        ArrayList<Object> metadataRepositories = new ArrayList<Object>();
        for (MavenRepositoryLocation mavenRepositoryLocation : completeRepositories) {
            metadataRepositories.add(this.loadMetadataRepository(mavenRepositoryLocation));
        }
        if (includeLocalMavenRepo) {
            metadataRepositories.add(this.localMetadataRepository);
        }
        for (IMetadataRepository iMetadataRepository : metadataRepositories) {
            IQueryResult matches = iMetadataRepository.query(QueryUtil.ALL_UNITS, this.monitor);
            result.addAll(matches.toUnmodifiableSet());
        }
        result.addAll(pomDependenciesContent.gatherMavenInstallableUnits());
        if (includeLocalMavenRepo && this.logger.isDebugEnabled()) {
            IQueryResult iQueryResult = this.localMetadataRepository.query(QueryUtil.ALL_UNITS, null);
            this.logger.debug("Added " + TargetPlatformFactoryImpl.countElements(iQueryResult.iterator()) + " locally built units to the target platform");
        }
        return result;
    }

    private IMetadataRepository loadMetadataRepository(MavenRepositoryLocation location) {
        try {
            return this.remoteMetadataRepositoryManager.loadRepository(location.getURL(), this.monitor);
        }
        catch (ProvisionException e) {
            String idMessage = location.getId() == null ? "" : " with ID '" + location.getId() + "'";
            throw new RuntimeException("Failed to load p2 repository" + idMessage + " from location " + location.getURL(), e);
        }
    }

    private IRawArtifactFileProvider createJointArtifactProvider(Set<MavenRepositoryLocation> completeRepositories, List<TargetDefinitionContent> targetDefinitionsContent, IRawArtifactFileProvider pomDependencyArtifactRepository, boolean includePackedArtifacts) {
        RepositoryArtifactProvider remoteArtifactProvider = this.createRemoteArtifactProvider(completeRepositories, targetDefinitionsContent);
        MirroringArtifactProvider remoteArtifactCache = MirroringArtifactProvider.createInstance((LocalArtifactRepository)this.localArtifactRepository, (IRawArtifactProvider)remoteArtifactProvider, (boolean)includePackedArtifacts, (MavenLogger)this.logger);
        CompositeArtifactProvider jointArtifactsProvider = new CompositeArtifactProvider(new IRawArtifactFileProvider[]{pomDependencyArtifactRepository, remoteArtifactCache});
        return jointArtifactsProvider;
    }

    private RepositoryArtifactProvider createRemoteArtifactProvider(Set<MavenRepositoryLocation> completeRepositories, List<TargetDefinitionContent> targetDefinitionsContent) {
        ArrayList<URI> allRemoteArtifactRepositories = new ArrayList<URI>();
        for (MavenRepositoryLocation location : completeRepositories) {
            if (this.offline && !URIUtil.isFileURI((URI)location.getURL())) continue;
            allRemoteArtifactRepositories.add(location.getURL());
        }
        for (TargetDefinitionContent targetDefinitionContent : targetDefinitionsContent) {
            allRemoteArtifactRepositories.addAll(targetDefinitionContent.getArtifactRepositoryLocations());
        }
        return new RepositoryArtifactProvider(allRemoteArtifactRepositories, ArtifactTransferPolicies.forRemoteArtifacts(), this.remoteAgent);
    }

    private Map<IInstallableUnit, ReactorProjectIdentities> getPreliminaryReactorProjectUIs(List<ReactorProject> reactorProjects) throws DuplicateReactorIUsException {
        if (reactorProjects == null) {
            return Collections.emptyMap();
        }
        HashMap<IInstallableUnit, ReactorProjectIdentities> reactorUIs = new HashMap<IInstallableUnit, ReactorProjectIdentities>();
        HashMap<IInstallableUnit, Set<File>> duplicateReactorUIs = new HashMap<IInstallableUnit, Set<File>>();
        for (ReactorProject project : reactorProjects) {
            Set projectIUs = project.getDependencyMetadata();
            if (projectIUs == null) continue;
            for (IInstallableUnit iu : projectIUs) {
                ReactorProjectIdentities otherOrigin = reactorUIs.put(iu, project.getIdentities());
                if (otherOrigin == null || otherOrigin.equals((Object)project.getIdentities())) continue;
                LinkedHashSet<File> duplicateLocations = (LinkedHashSet<File>)duplicateReactorUIs.get(iu);
                if (duplicateLocations == null) {
                    duplicateLocations = new LinkedHashSet<File>();
                    duplicateReactorUIs.put(iu, duplicateLocations);
                }
                duplicateLocations.add(otherOrigin.getBasedir());
                duplicateLocations.add(project.getBasedir());
            }
        }
        if (!duplicateReactorUIs.isEmpty()) {
            throw new DuplicateReactorIUsException(duplicateReactorUIs);
        }
        return reactorUIs;
    }

    private void applyFilters(TargetPlatformFilterEvaluator filter, Collection<IInstallableUnit> collectionToModify, Set<IInstallableUnit> reactorProjectUIs, ExecutionEnvironmentResolutionHints eeResolutionHints) {
        HashSet<String> reactorIUIDs = new HashSet<String>();
        for (IInstallableUnit unit : reactorProjectUIs) {
            reactorIUIDs.add(unit.getId());
        }
        Iterator<IInstallableUnit> iter = collectionToModify.iterator();
        while (iter.hasNext()) {
            IInstallableUnit unit = iter.next();
            if (!eeResolutionHints.isNonApplicableEEUnit(unit) && !TargetPlatformFactoryImpl.isPartialIU(unit) && !reactorIUIDs.contains(unit.getId())) continue;
            iter.remove();
        }
        TargetPlatformFactoryImpl.applyConfiguredFilter(filter, collectionToModify);
    }

    private static void applyConfiguredFilter(TargetPlatformFilterEvaluator filter, Collection<IInstallableUnit> collectionToModify) {
        if (filter != null) {
            filter.filterUnits(collectionToModify);
        }
    }

    private static boolean isPartialIU(IInstallableUnit iu) {
        return Boolean.valueOf(iu.getProperty("org.eclipse.equinox.p2.partial.iu"));
    }

    static int countElements(Iterator<?> iterator) {
        int result = 0;
        while (iterator.hasNext()) {
            ++result;
            iterator.next();
        }
        return result;
    }

    public P2TargetPlatform createTargetPlatformWithUpdatedReactorContent(TargetPlatform baseTargetPlatform, List<PublishingRepository> upstreamProjectResults) {
        return this.createTargetPlatformWithUpdatedReactorUnits(baseTargetPlatform, TargetPlatformFactoryImpl.extractProjectResultIUs(upstreamProjectResults));
    }

    P2TargetPlatform createTargetPlatformWithUpdatedReactorUnits(TargetPlatform baseTargetPlatform, Map<IInstallableUnit, ReactorProjectIdentities> reactorUnits) {
        if (!(baseTargetPlatform instanceof PreliminaryTargetPlatformImpl)) {
            throw new IllegalArgumentException("Base target platform must be an instance of PreliminaryTargetPlatformImpl; was: " + baseTargetPlatform);
        }
        return this.createTargetPlatformWithUpdatedReactorUnits((PreliminaryTargetPlatformImpl)baseTargetPlatform, reactorUnits);
    }

    P2TargetPlatform createTargetPlatformWithUpdatedReactorUnits(PreliminaryTargetPlatformImpl preliminaryTP, Map<IInstallableUnit, ReactorProjectIdentities> reactorUnitsMap) {
        LinkedHashSet<IInstallableUnit> allUnits = preliminaryTP.getExternalUnits();
        if (reactorUnitsMap != null) {
            LinkedList<IInstallableUnit> reactorUnits = new LinkedList<IInstallableUnit>(reactorUnitsMap.keySet());
            TargetPlatformFilterEvaluator configuredFilters = preliminaryTP.getFilter();
            if (configuredFilters != null) {
                configuredFilters.filterUnits(reactorUnits);
            }
            allUnits.addAll(reactorUnits);
        }
        IRawArtifactFileProvider jointArtifacts = preliminaryTP.getJointArtifacts();
        return new FinalTargetPlatformImpl(allUnits, preliminaryTP.getEEResolutionHints(), jointArtifacts, this.localArtifactRepository, preliminaryTP.getOriginalMavenArtifactMap(), reactorUnitsMap);
    }

    private static Map<IInstallableUnit, ReactorProjectIdentities> extractProjectResultIUs(List<PublishingRepository> projectResults) {
        LinkedHashMap<IInstallableUnit, ReactorProjectIdentities> reactorUnits = new LinkedHashMap<IInstallableUnit, ReactorProjectIdentities>();
        for (PublishingRepository projectResult : projectResults) {
            Set projectUnits = projectResult.getMetadataRepository().query(QueryUtil.ALL_UNITS, null).toUnmodifiableSet();
            ReactorProjectIdentities project = projectResult.getProjectIdentities();
            for (IInstallableUnit projectUnit : projectUnits) {
                reactorUnits.put(projectUnit, project);
            }
        }
        return reactorUnits;
    }
}

