/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target.ee;

import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.tycho.p2.target.ee.InvalidEENameException;
import org.eclipse.tycho.p2.util.resolution.ExecutionEnvironmentResolutionHints;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CustomEEResolutionHints
implements ExecutionEnvironmentResolutionHints {
    private final String eeName;
    private transient String unitName;
    private transient Version unitVersion;

    public CustomEEResolutionHints(String eeName) throws InvalidEENameException {
        this.eeName = eeName;
        this.parse(eeName);
    }

    void parse(String eeName) throws InvalidEENameException {
        int idx = eeName.indexOf(45);
        if (idx == -1) {
            throw new InvalidEENameException(eeName);
        }
        String name = eeName.substring(0, idx);
        name = name.replace('/', '.');
        name = name.replace('_', '.');
        this.unitName = "a.jre." + name.toLowerCase(Locale.ENGLISH);
        String version = eeName.substring(idx + 1);
        try {
            this.unitVersion = Version.create((String)version);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidEENameException(eeName);
        }
    }

    @Override
    public boolean isEESpecificationUnit(IInstallableUnit unit) {
        return this.unitName.equals(unit.getId()) && unit.getVersion().equals(this.unitVersion);
    }

    @Override
    public boolean isNonApplicableEEUnit(IInstallableUnit iu) {
        return this.isJreUnit(iu.getId()) && !this.isEESpecificationUnit(iu);
    }

    private boolean isJreUnit(String id) {
        return id.startsWith("a.jre") || id.startsWith("config.a.jre");
    }

    @Override
    public Collection<IInstallableUnit> getMandatoryUnits() {
        return Collections.emptyList();
    }

    @Override
    public Collection<IInstallableUnit> getTemporaryAdditions() {
        return Collections.emptyList();
    }

    @Override
    public Collection<IRequirement> getMandatoryRequires() {
        VersionRange strictUnitRange = new VersionRange(this.unitVersion, true, this.unitVersion, true);
        return Collections.singleton(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)this.unitName, (VersionRange)strictUnitRange, null, (boolean)false, (boolean)false));
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 37 * result + (this.eeName == null ? 0 : this.eeName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CustomEEResolutionHints)) {
            return false;
        }
        CustomEEResolutionHints other = (CustomEEResolutionHints)obj;
        return CustomEEResolutionHints.eq(this.eeName, other.eeName);
    }

    private static <T> boolean eq(T left, T right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return false;
        }
        return left.equals(right);
    }
}

