/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.util.resolution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.equinox.internal.p2.director.Slicer;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.p2.util.resolution.AbstractResolutionStrategy;
import org.eclipse.tycho.p2.util.resolution.QueryableCollection;
import org.eclipse.tycho.p2.util.resolution.ResolverDebugUtils;
import org.eclipse.tycho.p2.util.resolution.ResolverException;
import org.eclipse.tycho.repository.util.StatusTool;

abstract class AbstractSlicerResolutionStrategy
extends AbstractResolutionStrategy {
    protected AbstractSlicerResolutionStrategy(MavenLogger logger) {
        super(logger);
    }

    protected final IQueryable<IInstallableUnit> slice(Map<String, String> properties, IProgressMonitor monitor) throws ResolverException {
        if (this.logger.isExtendedDebugEnabled()) {
            this.logger.debug("Properties: " + properties.toString());
            this.logger.debug("Available IUs:\n" + ResolverDebugUtils.toDebugString(this.data.getAvailableIUs(), false));
            this.logger.debug("JRE IUs:\n" + ResolverDebugUtils.toDebugString(this.data.getEEResolutionHints().getMandatoryUnits(), false));
            this.logger.debug("Root IUs:\n" + ResolverDebugUtils.toDebugString(this.data.getRootIUs(), true));
            if (this.data.getAdditionalRequirements() != null && !this.data.getAdditionalRequirements().isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (IRequirement req : this.data.getAdditionalRequirements()) {
                    sb.append("   ").append(req.toString()).append("\n");
                }
                this.logger.debug("Extra Requirements:\n" + sb.toString());
            }
        }
        LinkedHashSet<IInstallableUnit> availableIUs = new LinkedHashSet<IInstallableUnit>(this.data.getAvailableIUs());
        availableIUs.addAll(this.data.getEEResolutionHints().getTemporaryAdditions());
        availableIUs.addAll(this.data.getEEResolutionHints().getMandatoryUnits());
        LinkedHashSet<IInstallableUnit> seedIUs = new LinkedHashSet<IInstallableUnit>(this.data.getRootIUs());
        if (this.data.getAdditionalRequirements() != null && !this.data.getAdditionalRequirements().isEmpty()) {
            seedIUs.add(AbstractSlicerResolutionStrategy.createUnitRequiring("tycho-extra", null, this.data.getAdditionalRequirements()));
        }
        seedIUs.addAll(this.data.getEEResolutionHints().getMandatoryUnits());
        if (!this.data.getEEResolutionHints().getMandatoryRequires().isEmpty()) {
            seedIUs.add(AbstractSlicerResolutionStrategy.createUnitRequiring("tycho-ee", null, this.data.getEEResolutionHints().getMandatoryRequires()));
        }
        Slicer slicer = this.newSlicer((IQueryable<IInstallableUnit>)new QueryableCollection(availableIUs), properties);
        IQueryable slice = slicer.slice(seedIUs.toArray(EMPTY_IU_ARRAY), monitor);
        MultiStatus slicerStatus = slicer.getStatus();
        if (slice == null || this.isSlicerError(slicerStatus)) {
            throw new ResolverException(StatusTool.toLogMessage((IStatus)slicerStatus), properties.toString(), StatusTool.findException((IStatus)slicerStatus));
        }
        if (this.logger.isExtendedDebugEnabled()) {
            this.logger.debug("Slice:\n" + ResolverDebugUtils.toDebugString((IQueryable<IInstallableUnit>)slice, false, monitor));
        }
        return slice;
    }

    protected abstract boolean isSlicerError(MultiStatus var1);

    protected abstract Slicer newSlicer(IQueryable<IInstallableUnit> var1, Map<String, String> var2);

    protected static IInstallableUnit createUnitRequiring(String name, Collection<IInstallableUnit> units, Collection<IRequirement> additionalRequirements) {
        MetadataFactory.InstallableUnitDescription result = new MetadataFactory.InstallableUnitDescription();
        String time = Long.toString(System.currentTimeMillis());
        result.setId(String.valueOf(name) + "-" + time);
        result.setVersion(Version.createOSGi((int)0, (int)0, (int)0, (String)time));
        ArrayList<IRequirement> requirements = new ArrayList<IRequirement>();
        if (units != null) {
            for (IInstallableUnit unit : units) {
                requirements.add(AbstractSlicerResolutionStrategy.createStrictRequirementTo(unit));
            }
        }
        if (additionalRequirements != null) {
            requirements.addAll(additionalRequirements);
        }
        result.addRequirements(requirements);
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)result);
    }

    private static IRequirement createStrictRequirementTo(IInstallableUnit unit) {
        VersionRange strictRange = new VersionRange(unit.getVersion(), true, unit.getVersion(), true);
        int min = 1;
        int max = Integer.MAX_VALUE;
        boolean greedy = true;
        IRequirement requirement = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)unit.getId(), (VersionRange)strictRange, (IMatchExpression)unit.getFilter(), (int)min, (int)max, (boolean)greedy);
        return requirement;
    }
}

