/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target.ee;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.tycho.p2.target.ee.StandardEEResolutionHints;
import org.eclipse.tycho.p2.util.resolution.ExecutionEnvironmentResolutionHints;
import org.osgi.framework.BundleActivator;

public class AllKnownEEsResolutionHints
implements ExecutionEnvironmentResolutionHints {
    private final Map<VersionedId, IInstallableUnit> temporaryUnits = new LinkedHashMap<VersionedId, IInstallableUnit>();

    public AllKnownEEsResolutionHints() {
        for (String env : AllKnownEEsResolutionHints.getAllKnownExecutionEnvironments()) {
            StandardEEResolutionHints.addIUsFromEnvironment(env, this.temporaryUnits);
        }
    }

    @Override
    public Collection<IInstallableUnit> getMandatoryUnits() {
        return Collections.emptyList();
    }

    @Override
    public boolean isNonApplicableEEUnit(IInstallableUnit iu) {
        return iu.getId().startsWith("a.jre") || iu.getId().startsWith("config.a.jre");
    }

    @Override
    public boolean isEESpecificationUnit(IInstallableUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<IRequirement> getMandatoryRequires() {
        return Collections.emptyList();
    }

    @Override
    public Collection<IInstallableUnit> getTemporaryAdditions() {
        return this.temporaryUnits.values();
    }

    private static List<String> getAllKnownExecutionEnvironments() {
        ClassLoader loader = BundleActivator.class.getClassLoader();
        Properties listProps = AllKnownEEsResolutionHints.readProperties(loader.getResource("profile.list"));
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = listProps.getProperty("java.profiles").split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String profileFile = stringArray[n2];
            Properties props = AllKnownEEsResolutionHints.readProperties(loader.getResource(profileFile.trim()));
            String profileName = props.getProperty("osgi.java.profile.name");
            if (profileName == null) {
                throw new IllegalStateException("osgi.java.profile.name must not be null for profile " + profileFile);
            }
            result.add(profileName);
            ++n2;
        }
        return result;
    }

    private static Properties readProperties(URL url) {
        Properties listProps = new Properties();
        InputStream stream = null;
        try {
            try {
                stream = url.openStream();
                listProps.load(stream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return listProps;
    }
}

