/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.core.shared.TargetEnvironment;
import org.eclipse.tycho.p2.target.TargetDefinitionContent;
import org.eclipse.tycho.p2.target.TargetDefinitionResolver;
import org.eclipse.tycho.p2.target.facade.TargetDefinition;
import org.eclipse.tycho.p2.util.resolution.ExecutionEnvironmentResolutionHints;

public class TargetDefinitionResolverService {
    private static final String CACHE_MISS_MESSAGE = "Target definition content cache miss: ";
    private Map<ResolutionArguments, TargetDefinitionContent> resolutionCache = new HashMap<ResolutionArguments, TargetDefinitionContent>();
    private MavenLogger logger;

    public TargetDefinitionResolverService() {
    }

    public TargetDefinitionResolverService(MavenContext mavenContext) {
        this.logger = mavenContext.getLogger();
    }

    public TargetDefinitionContent getTargetDefinitionContent(TargetDefinition definition, List<TargetEnvironment> environments, ExecutionEnvironmentResolutionHints jreIUs, IProvisioningAgent agent) {
        ResolutionArguments arguments = new ResolutionArguments(definition, environments, jreIUs, agent);
        TargetDefinitionContent resolution = this.resolutionCache.get(arguments);
        if (resolution == null) {
            if (this.logger.isDebugEnabled()) {
                this.debugCacheMiss(arguments);
                this.logger.debug("Resolving target definition content...");
            }
            resolution = this.resolveFromArguments(arguments);
            this.resolutionCache.put(arguments, resolution);
        }
        return resolution;
    }

    private TargetDefinitionContent resolveFromArguments(ResolutionArguments arguments) {
        return new TargetDefinitionResolver(arguments.environments, arguments.jreIUs, arguments.agent, this.logger).resolveContent(arguments.definition);
    }

    private void debugCacheMiss(ResolutionArguments arguments) {
        if (this.resolutionCache.isEmpty()) {
            return;
        }
        ArrayList<String> fieldsInWhichDistanceOneEntriesDiffer = new ArrayList<String>();
        for (ResolutionArguments existingKey : this.resolutionCache.keySet()) {
            List<String> differingFields = arguments.getNonEqualFields(existingKey);
            if (differingFields.size() != 1) continue;
            fieldsInWhichDistanceOneEntriesDiffer.add(differingFields.get(0));
        }
        if (fieldsInWhichDistanceOneEntriesDiffer.isEmpty()) {
            this.logger.debug("Target definition content cache miss: All entries differ in more than one parameter");
        } else {
            this.logger.debug("Target definition content cache miss: All entries differ, but there are entries which only differ in one parameter: " + fieldsInWhichDistanceOneEntriesDiffer);
        }
    }

    public void setMavenContext(MavenContext mavenContext) {
        this.logger = mavenContext.getLogger();
    }

    static <T> boolean eq(T left, T right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return false;
        }
        return left.equals(right);
    }

    static <T> void addIfNonEqual(List<String> result, String stringToAdd, T left, T right) {
        if (!TargetDefinitionResolverService.eq(left, right)) {
            result.add(stringToAdd);
        }
    }

    private static final class ResolutionArguments {
        final TargetDefinition definition;
        final List<TargetEnvironment> environments;
        final ExecutionEnvironmentResolutionHints jreIUs;
        final IProvisioningAgent agent;

        public ResolutionArguments(TargetDefinition definition, List<TargetEnvironment> environments, ExecutionEnvironmentResolutionHints jreIUs, IProvisioningAgent agent) {
            this.definition = definition;
            this.environments = environments;
            this.jreIUs = jreIUs;
            this.agent = agent;
        }

        public int hashCode() {
            int result = 1;
            result = 61 * result + (this.agent == null ? 0 : this.agent.hashCode());
            result = 61 * result + (this.definition == null ? 0 : this.definition.hashCode());
            result = 61 * result + (this.environments == null ? 0 : this.environments.hashCode());
            result = 61 * result + (this.jreIUs == null ? 0 : this.jreIUs.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ResolutionArguments)) {
                return false;
            }
            ResolutionArguments other = (ResolutionArguments)obj;
            return TargetDefinitionResolverService.eq(this.jreIUs, other.jreIUs) && TargetDefinitionResolverService.eq(this.definition, other.definition) && TargetDefinitionResolverService.eq(this.agent, other.agent) && TargetDefinitionResolverService.eq(this.environments, other.environments);
        }

        public List<String> getNonEqualFields(ResolutionArguments other) {
            ArrayList<String> result = new ArrayList<String>();
            TargetDefinitionResolverService.addIfNonEqual(result, "target definition", this.definition, other.definition);
            TargetDefinitionResolverService.addIfNonEqual(result, "execution environment", this.jreIUs, other.jreIUs);
            TargetDefinitionResolverService.addIfNonEqual(result, "target environments", this.environments, other.environments);
            TargetDefinitionResolverService.addIfNonEqual(result, "remote p2 repository options", this.agent, other.agent);
            return result;
        }
    }
}

