/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.ReactorProjectIdentities;
import org.eclipse.tycho.artifacts.DependencyResolutionException;
import org.eclipse.tycho.artifacts.IllegalArtifactReferenceException;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.eclipse.tycho.p2.target.ArtifactMatcher;
import org.eclipse.tycho.p2.target.P2TargetPlatform;
import org.eclipse.tycho.p2.util.resolution.ExecutionEnvironmentResolutionHints;
import org.eclipse.tycho.repository.local.LocalArtifactRepository;
import org.eclipse.tycho.repository.p2base.artifact.provider.IRawArtifactFileProvider;

abstract class TargetPlatformBaseImpl
implements P2TargetPlatform {
    protected final LinkedHashSet<IInstallableUnit> installableUnits;
    private final Map<IInstallableUnit, ReactorProjectIdentities> reactorProjectLookup;
    final Map<IInstallableUnit, IArtifactFacade> mavenArtifactLookup;
    final ExecutionEnvironmentResolutionHints executionEnvironment;
    final IRawArtifactFileProvider artifacts;
    @Deprecated
    private LocalArtifactRepository localArtifactRepository;

    public TargetPlatformBaseImpl(LinkedHashSet<IInstallableUnit> installableUnits, ExecutionEnvironmentResolutionHints executionEnvironment, IRawArtifactFileProvider artifacts, LocalArtifactRepository localArtifactRepository, Map<IInstallableUnit, ReactorProjectIdentities> reactorProjectLookup, Map<IInstallableUnit, IArtifactFacade> mavenArtifactLookup) {
        this.installableUnits = installableUnits;
        this.executionEnvironment = executionEnvironment;
        this.reactorProjectLookup = reactorProjectLookup;
        this.mavenArtifactLookup = mavenArtifactLookup;
        this.artifacts = artifacts;
        this.localArtifactRepository = localArtifactRepository;
    }

    @Override
    public final Set<IInstallableUnit> getInstallableUnits() {
        return this.installableUnits;
    }

    public final ArtifactKey resolveArtifact(String type, String id, String version) throws IllegalArtifactReferenceException, DependencyResolutionException {
        IInstallableUnit resolvedUnit = this.resolveUnit(type, id, ArtifactMatcher.parseAsOSGiVersion(version));
        return new DefaultArtifactKey(type, id, resolvedUnit.getVersion().toString());
    }

    @Override
    public final IInstallableUnit resolveUnit(String type, String id, Version version) throws IllegalArtifactReferenceException, DependencyResolutionException {
        IInstallableUnit matchingUnit = ArtifactMatcher.resolveReference(type, id, version, this.installableUnits);
        if (matchingUnit == null) {
            String message = version == null ? String.valueOf(type) + " artifact with ID \"" + id + "\" was not found in the target platform" : String.valueOf(type) + " artifact with ID \"" + id + "\" and version matching \"" + version + "\" was not found in the target platform";
            throw new DependencyResolutionException(message);
        }
        return matchingUnit;
    }

    @Override
    public final ExecutionEnvironmentResolutionHints getEEResolutionHints() {
        return this.executionEnvironment;
    }

    @Override
    public final Map<IInstallableUnit, ReactorProjectIdentities> getOriginalReactorProjectMap() {
        return this.reactorProjectLookup;
    }

    @Override
    public final Map<IInstallableUnit, IArtifactFacade> getOriginalMavenArtifactMap() {
        return this.mavenArtifactLookup;
    }

    @Override
    public final File getLocalArtifactFile(IArtifactKey key) {
        return this.artifacts.getArtifactFile(key);
    }

    @Override
    public final void saveLocalMavenRepository() {
        this.localArtifactRepository.save();
    }
}

