/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.resolver.shared.IncludeSourceMode;
import org.eclipse.tycho.core.shared.BuildFailureException;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.core.shared.MavenDependenciesResolver;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.core.shared.MultiLineLogger;
import org.eclipse.tycho.core.shared.TargetEnvironment;
import org.eclipse.tycho.p2.resolver.FileTargetDefinitionContent;
import org.eclipse.tycho.p2.resolver.InstallableUnitResolver;
import org.eclipse.tycho.p2.resolver.MavenTargetDefinitionContent;
import org.eclipse.tycho.p2.resolver.URITargetDefinitionContent;
import org.eclipse.tycho.p2.target.TargetDefinitionContent;
import org.eclipse.tycho.p2.target.facade.TargetDefinition;
import org.eclipse.tycho.p2.target.facade.TargetDefinitionResolutionException;
import org.eclipse.tycho.p2.target.facade.TargetDefinitionSyntaxException;
import org.eclipse.tycho.p2.util.resolution.ExecutionEnvironmentResolutionHints;
import org.eclipse.tycho.p2.util.resolution.ResolverException;
import org.eclipse.tycho.repository.p2base.artifact.repository.ListCompositeArtifactRepository;
import org.eclipse.tycho.repository.p2base.artifact.repository.ListCompositeMetadataRepository;
import org.eclipse.tycho.repository.util.LoggingProgressMonitor;

public final class TargetDefinitionResolver {
    private static final Pattern SYSTEM_PROPERTY_PATTERN = TargetDefinitionResolver.createVariablePatternArgument("system_property");
    private static final Pattern PROJECT_LOC_PATTERN = TargetDefinitionResolver.createVariablePatternArgument("project_loc");
    private static final Pattern ENV_VAR_PATTERN = TargetDefinitionResolver.createVariablePatternArgument("env_var");
    private final MavenLogger logger;
    private final List<TargetEnvironment> environments;
    private final ExecutionEnvironmentResolutionHints executionEnvironment;
    private MavenContext mavenContext;
    private IncludeSourceMode includeSourceMode;
    private MavenDependenciesResolver mavenDependenciesResolver;

    public TargetDefinitionResolver(List<TargetEnvironment> environments, ExecutionEnvironmentResolutionHints executionEnvironment, IncludeSourceMode includeSourceMode, MavenContext mavenContext, MavenDependenciesResolver mavenDependenciesResolver) {
        this.environments = environments;
        this.executionEnvironment = executionEnvironment;
        this.includeSourceMode = includeSourceMode;
        this.mavenContext = mavenContext;
        this.mavenDependenciesResolver = mavenDependenciesResolver;
        this.logger = mavenContext.getLogger();
    }

    public TargetDefinitionContent resolveContent(TargetDefinition definition, IProvisioningAgent provisioningAgent) {
        try {
            return this.resolveContentWithExceptions(definition, provisioningAgent);
        }
        catch (TargetDefinitionSyntaxException e) {
            throw new BuildFailureException("Invalid syntax in target definition " + definition.getOrigin() + ": " + e.getMessage(), (Throwable)e);
        }
        catch (TargetDefinitionResolutionException e) {
            throw new BuildFailureException("Failed to resolve target definition " + definition.getOrigin() + ": " + e.getMessage(), (Throwable)e);
        }
        catch (ResolverException e) {
            this.logResolverException(e);
            throw new BuildFailureException("Failed to resolve target definition " + definition.getOrigin(), (Throwable)e);
        }
    }

    private void logResolverException(ResolverException e) {
        this.logger.error("Cannot resolve target definition:");
        new MultiLineLogger(this.logger).error(e.getDetails(), "  ");
        this.logger.error("");
    }

    TargetDefinitionContent resolveContentWithExceptions(TargetDefinition definition, final IProvisioningAgent provisioningAgent) throws TargetDefinitionSyntaxException, TargetDefinitionResolutionException, ResolverException {
        final Collector unitResultSet = new Collector();
        InstallableUnitResolver installableUnitResolver = null;
        LinkedHashMap<String, FileTargetDefinitionContent> fileRepositories = new LinkedHashMap<String, FileTargetDefinitionContent>();
        LinkedHashMap<String, URITargetDefinitionContent> uriRepositories = new LinkedHashMap<String, URITargetDefinitionContent>();
        ArrayList<MavenTargetDefinitionContent> mavenLocations = new ArrayList<MavenTargetDefinitionContent>();
        for (TargetDefinition.Location locationDefinition : definition.getLocations()) {
            if (locationDefinition instanceof TargetDefinition.InstallableUnitLocation) {
                TargetDefinition.InstallableUnitLocation installableUnitLocation = (TargetDefinition.InstallableUnitLocation)locationDefinition;
                if (installableUnitResolver == null) {
                    installableUnitResolver = new InstallableUnitResolver(this.environments, this.executionEnvironment, this.includeSourceMode, this.logger);
                }
                ArrayList<URITargetDefinitionContent> locations = new ArrayList<URITargetDefinitionContent>();
                for (TargetDefinition.Repository repository : installableUnitLocation.getRepositories()) {
                    URI location = repository.getLocation();
                    String key2 = location.normalize().toASCIIString();
                    locations.add(uriRepositories.computeIfAbsent(key2, s -> new URITargetDefinitionContent(provisioningAgent, location, repository.getId())));
                }
                IQueryable locationUnits = QueryUtil.compoundQueryable(locations);
                installableUnitResolver.addLocation((TargetDefinition.InstallableUnitLocation)locationDefinition, (IQueryable<IInstallableUnit>)locationUnits);
                continue;
            }
            if (locationDefinition instanceof TargetDefinition.PathLocation) {
                TargetDefinition.PathLocation pathLocation = (TargetDefinition.PathLocation)locationDefinition;
                File path = this.resolvePath(pathLocation.getPath(), definition);
                if (path.exists()) {
                    FileTargetDefinitionContent fileRepositoryRolver = fileRepositories.computeIfAbsent(path.getAbsolutePath(), key -> new FileTargetDefinitionContent(provisioningAgent, path));
                    if (pathLocation instanceof TargetDefinition.DirectoryLocation || pathLocation instanceof TargetDefinition.ProfileLocation) {
                        unitResultSet.addAll(fileRepositoryRolver.query((IQuery<IInstallableUnit>)QueryUtil.ALL_UNITS, (IProgressMonitor)new LoggingProgressMonitor(this.logger)));
                        continue;
                    }
                    if (!(pathLocation instanceof TargetDefinition.FeaturesLocation)) continue;
                    TargetDefinition.FeaturesLocation featuresLocation = (TargetDefinition.FeaturesLocation)pathLocation;
                    IArtifactKey key3 = FeaturesAction.createFeatureArtifactKey((String)featuresLocation.getId(), (String)featuresLocation.getVersion());
                    unitResultSet.addAll(fileRepositoryRolver.query((IQuery<IInstallableUnit>)QueryUtil.createIUQuery((IVersionedId)key3), (IProgressMonitor)new LoggingProgressMonitor(this.logger)));
                    continue;
                }
                this.logger.warn("Target location path '" + path.getAbsolutePath() + "' does not exits, target resoloution might be incomplete.");
                continue;
            }
            if (locationDefinition instanceof TargetDefinition.MavenGAVLocation) {
                TargetDefinition.MavenGAVLocation location = (TargetDefinition.MavenGAVLocation)locationDefinition;
                MavenTargetDefinitionContent targetDefinitionContent = new MavenTargetDefinitionContent(location, this.mavenDependenciesResolver, this.includeSourceMode, provisioningAgent, this.logger);
                mavenLocations.add(targetDefinitionContent);
                IQueryResult<IInstallableUnit> result = targetDefinitionContent.query((IQuery<IInstallableUnit>)QueryUtil.ALL_UNITS, (IProgressMonitor)new LoggingProgressMonitor(this.logger));
                unitResultSet.addAll(result);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("The following artifacts where resolved from location " + location);
                for (IInstallableUnit iu : result.toUnmodifiableSet()) {
                    this.logger.debug("\t" + iu);
                }
                continue;
            }
            this.logger.warn("Target location type '" + locationDefinition.getTypeDescription() + "' is not supported");
        }
        if (definition.hasIncludedBundles()) {
            this.logger.warn("De-selecting bundles in a target definition file is not supported. See https://wiki.eclipse.org/Tycho_Messages_Explained#Target_File_Include_Bundles for alternatives.");
        }
        final ArrayList<IMetadataRepository> metadataRepositories = new ArrayList<IMetadataRepository>();
        final ArrayList<IArtifactRepository> artifactRepositories = new ArrayList<IArtifactRepository>();
        for (FileTargetDefinitionContent fileDefinitionContent : fileRepositories.values()) {
            metadataRepositories.add(fileDefinitionContent.getMetadataRepository());
            artifactRepositories.add(fileDefinitionContent.getArtifactRepository());
        }
        for (URITargetDefinitionContent uriDefinitionContent : uriRepositories.values()) {
            metadataRepositories.add(uriDefinitionContent.getMetadataRepository());
            artifactRepositories.add(uriDefinitionContent.getArtifactRepository());
        }
        for (MavenTargetDefinitionContent mavenContent : mavenLocations) {
            metadataRepositories.add(mavenContent.getMetadataRepository());
            artifactRepositories.add(mavenContent.getArtifactRepository());
        }
        if (installableUnitResolver != null) {
            ListCompositeMetadataRepository metadataRepository = new ListCompositeMetadataRepository(metadataRepositories, provisioningAgent);
            unitResultSet.addAll(installableUnitResolver.resolve((IQueryable<IInstallableUnit>)metadataRepository));
        }
        return new TargetDefinitionContent(){
            private ListCompositeArtifactRepository artifactRepository;
            private IMetadataRepository metadataRepository;

            @Override
            public IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
                return unitResultSet.query(query, monitor);
            }

            @Override
            public IMetadataRepository getMetadataRepository() {
                if (this.metadataRepository == null) {
                    this.metadataRepository = new ListCompositeMetadataRepository(metadataRepositories, provisioningAgent);
                }
                return this.metadataRepository;
            }

            @Override
            public IArtifactRepository getArtifactRepository() {
                if (this.artifactRepository == null) {
                    this.artifactRepository = new ListCompositeArtifactRepository(provisioningAgent, artifactRepositories);
                }
                return this.artifactRepository;
            }
        };
    }

    protected File resolvePath(String path, TargetDefinition definition) throws ResolverException {
        path = TargetDefinitionResolver.resolvePattern(path, SYSTEM_PROPERTY_PATTERN, key -> this.mavenContext.getSessionProperties().getProperty((String)key, ""));
        path = TargetDefinitionResolver.resolvePattern(path, ENV_VAR_PATTERN, key -> {
            String env = System.getenv(key);
            return env == null ? "" : env;
        });
        path = TargetDefinitionResolver.resolvePattern(path, PROJECT_LOC_PATTERN, this::findProjectLocation);
        try {
            return new File(path).getCanonicalFile();
        }
        catch (IOException e) {
            throw new ResolverException("I/O Error while resolve path " + path, e);
        }
    }

    private String findProjectLocation(String projectName) {
        for (ReactorProject project : this.mavenContext.getProjects()) {
            if (!project.getName().equals(projectName)) continue;
            return project.getBasedir().getAbsolutePath();
        }
        for (ReactorProject project : this.mavenContext.getProjects()) {
            if (!project.getArtifactId().equals(projectName)) continue;
            return project.getBasedir().getAbsolutePath();
        }
        for (ReactorProject project : this.mavenContext.getProjects()) {
            if (!project.getBasedir().getName().equals(projectName)) continue;
            return project.getBasedir().getAbsolutePath();
        }
        String defaultValue = "${project_loc:" + projectName + "}";
        this.logger.warn("Can't resolve " + defaultValue + " target resoloution might be incomplete");
        return defaultValue;
    }

    private static String resolvePattern(String input, Pattern pattern, Function<String, String> parameterResolver) {
        Matcher matcher = pattern.matcher(input);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String group = matcher.group(1);
            String resolved = parameterResolver.apply(group);
            matcher.appendReplacement(sb, Matcher.quoteReplacement(resolved));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static Pattern createVariablePatternArgument(String variableName) {
        return Pattern.compile("\\$\\{" + variableName + ":([^}]+)\\}", 2);
    }
}

