/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.p2.maven.repository.xmlio.MetadataIO;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.eclipse.tycho.p2.repository.GAV;
import org.eclipse.tycho.p2.target.MavenBundleInfo;
import org.eclipse.tycho.p2.target.TargetPlatformBundlePublisher;
import org.eclipse.tycho.p2.target.facade.PomDependencyCollector;
import org.eclipse.tycho.repository.p2base.artifact.provider.IRawArtifactFileProvider;

public class PomDependencyCollectorImpl
implements PomDependencyCollector {
    private final TargetPlatformBundlePublisher bundlesPublisher;
    private final MavenLogger logger;
    private Map<IInstallableUnit, IArtifactFacade> mavenInstallableUnits = new HashMap<IInstallableUnit, IArtifactFacade>();
    private ReactorProject project;

    public PomDependencyCollectorImpl(MavenContext mavenContext, ReactorProject project) {
        this.project = project;
        this.logger = mavenContext.getLogger();
        File localRepositoryRoot = mavenContext.getLocalRepositoryRoot();
        this.bundlesPublisher = new TargetPlatformBundlePublisher(localRepositoryRoot, project, mavenContext.getLogger());
    }

    public File getProjectLocation() {
        if (this.project != null) {
            return this.project.getBasedir();
        }
        return null;
    }

    public void addMavenArtifact(IArtifactFacade artifact, boolean allowGenerateOSGiBundle) {
        MavenBundleInfo bundleIU = this.bundlesPublisher.attemptToPublishBundle(artifact, allowGenerateOSGiBundle);
        if (bundleIU != null) {
            this.addMavenArtifact(bundleIU.getArtifact(), Collections.singleton(bundleIU.getUnit()));
        }
    }

    public void addArtifactWithExistingMetadata(IArtifactFacade artifact, IArtifactFacade p2MetadataFile) {
        try {
            this.addMavenArtifact(artifact, this.readUnits(p2MetadataFile));
        }
        catch (IOException e) {
            throw new RuntimeException("failed to read p2 metadata", e);
        }
    }

    private Set<IInstallableUnit> readUnits(IArtifactFacade p2MetadataFile) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream inputStream = new FileInputStream(p2MetadataFile.getLocation());){
            MetadataIO io = new MetadataIO();
            return io.readXML((InputStream)inputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void addMavenArtifact(IArtifactFacade artifact, Set<IInstallableUnit> units) {
        for (IInstallableUnit unit : units) {
            String classifier = unit.getProperty("maven-classifier");
            if (Objects.equals(classifier, artifact.getClassifier())) {
                this.mavenInstallableUnits.put(unit, artifact);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("P2Resolver: artifact " + new GAV(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()).toString() + " at location " + artifact.getLocation() + " resolves installable unit " + new VersionedId(unit.getId(), unit.getVersion()));
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("P2Resolver: artifact " + new GAV(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()).toString() + " for installable unit " + new VersionedId(unit.getId(), unit.getVersion()) + " is ignored because of classifier missmatch");
        }
    }

    LinkedHashSet<IInstallableUnit> gatherMavenInstallableUnits() {
        return new LinkedHashSet<IInstallableUnit>(this.getMavenInstallableUnits().keySet());
    }

    Map<IInstallableUnit, IArtifactFacade> getMavenInstallableUnits() {
        return this.mavenInstallableUnits;
    }

    IRawArtifactFileProvider getArtifactRepoOfPublishedBundles() {
        return this.bundlesPublisher.getArtifactRepoOfPublishedBundles();
    }
}

