/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.tycho.ReactorProjectIdentities;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.eclipse.tycho.p2.target.TargetPlatformBaseImpl;
import org.eclipse.tycho.p2.target.filters.TargetPlatformFilterEvaluator;
import org.eclipse.tycho.p2.util.resolution.ExecutionEnvironmentResolutionHints;
import org.eclipse.tycho.repository.local.LocalArtifactRepository;
import org.eclipse.tycho.repository.local.LocalMetadataRepository;
import org.eclipse.tycho.repository.p2base.artifact.provider.IRawArtifactFileProvider;

public class PreliminaryTargetPlatformImpl
extends TargetPlatformBaseImpl {
    private final Collection<IInstallableUnit> externalIUs;
    private final LocalMetadataRepository localMetadataRepository;
    private final MavenLogger logger;
    private final TargetPlatformFilterEvaluator filter;
    private final boolean includeLocalRepo;

    public PreliminaryTargetPlatformImpl(Map<IInstallableUnit, ReactorProjectIdentities> reactorProjectIUs, Collection<IInstallableUnit> externalIUs, Map<IInstallableUnit, IArtifactFacade> mavenArtifactIUs, ExecutionEnvironmentResolutionHints executionEnvironment, TargetPlatformFilterEvaluator filter, LocalMetadataRepository localMetadataRepository, IRawArtifactFileProvider externalArtifacts, LocalArtifactRepository localArtifactRepository, boolean includeLocalRepo, MavenLogger logger) {
        super(PreliminaryTargetPlatformImpl.collectAllInstallableUnits(reactorProjectIUs, externalIUs, executionEnvironment), executionEnvironment, externalArtifacts, localArtifactRepository, reactorProjectIUs, mavenArtifactIUs);
        this.externalIUs = externalIUs;
        this.filter = filter;
        this.localMetadataRepository = localMetadataRepository;
        this.includeLocalRepo = includeLocalRepo;
        this.logger = logger;
    }

    public static LinkedHashSet<IInstallableUnit> collectAllInstallableUnits(Map<IInstallableUnit, ReactorProjectIdentities> reactorProjectIUs, Collection<IInstallableUnit> externalIUs, ExecutionEnvironmentResolutionHints executionEnvironment) {
        LinkedHashSet<IInstallableUnit> allius = new LinkedHashSet<IInstallableUnit>();
        allius.addAll(reactorProjectIUs.keySet());
        allius.addAll(externalIUs);
        allius.addAll(executionEnvironment.getMandatoryUnits());
        return allius;
    }

    @Override
    public void reportUsedLocalIUs(Collection<IInstallableUnit> usedUnits) {
        if (!this.includeLocalRepo) {
            return;
        }
        Set localIUs = this.localMetadataRepository.query(QueryUtil.ALL_UNITS, null).toSet();
        localIUs.retainAll(usedUnits);
        Iterator iterator = localIUs.iterator();
        while (iterator.hasNext()) {
            if (!this.executionEnvironment.isNonApplicableEEUnit((IInstallableUnit)iterator.next())) continue;
            iterator.remove();
        }
        if (!localIUs.isEmpty()) {
            this.logger.warn("The following locally built units have been used to resolve project dependencies:");
            for (IInstallableUnit localIu : localIUs) {
                this.logger.warn("  " + localIu.getId() + "/" + localIu.getVersion());
            }
        }
    }

    public LinkedHashSet<IInstallableUnit> getExternalUnits() {
        LinkedHashSet<IInstallableUnit> result = new LinkedHashSet<IInstallableUnit>();
        result.addAll(this.externalIUs);
        result.addAll(this.executionEnvironment.getMandatoryUnits());
        return result;
    }

    public TargetPlatformFilterEvaluator getFilter() {
        return this.filter;
    }

    public IRawArtifactFileProvider getExternalArtifacts() {
        return this.artifacts;
    }

    @Override
    public IMetadataRepository getInstallableUnitsAsMetadataRepository() {
        throw new UnsupportedOperationException();
    }
}

