/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.p2.impl.Activator;
import org.eclipse.tycho.p2.maven.repository.xmlio.MetadataIO;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.eclipse.tycho.p2.metadata.ReactorProjectFacade;
import org.eclipse.tycho.p2.repository.GAV;
import org.eclipse.tycho.p2.target.MavenBundleInfo;
import org.eclipse.tycho.p2.target.TargetPlatformBundlePublisher;
import org.eclipse.tycho.p2.target.facade.PomDependencyCollector;
import org.eclipse.tycho.p2.target.repository.FileArtifactRepository;
import org.eclipse.tycho.repository.p2base.artifact.provider.CompositeArtifactProvider;
import org.eclipse.tycho.repository.p2base.artifact.provider.IRawArtifactFileProvider;
import org.eclipse.tycho.repository.p2base.artifact.provider.formats.ArtifactTransferPolicies;
import org.eclipse.tycho.repository.p2base.artifact.repository.FileRepositoryArtifactProvider;
import org.osgi.framework.BundleException;

public class PomDependencyCollectorImpl
implements PomDependencyCollector {
    private final TargetPlatformBundlePublisher bundlesPublisher;
    private final MavenLogger logger;
    private Map<IInstallableUnit, IArtifactFacade> mavenInstallableUnits = new HashMap<IInstallableUnit, IArtifactFacade>();
    private Map<IArtifactFacade, IArtifactDescriptor> descriptorMap = new HashMap<IArtifactFacade, IArtifactDescriptor>();
    private ReactorProject project;
    private IProvisioningAgent agent;
    private final List<IArtifactDescriptor> fileDescriptors = new ArrayList<IArtifactDescriptor>();
    private FileRepositoryArtifactProvider fileRepositoryArtifactProvider;

    public PomDependencyCollectorImpl(MavenContext mavenContext, ReactorProject project) {
        this.project = project;
        this.logger = mavenContext.getLogger();
        this.bundlesPublisher = new TargetPlatformBundlePublisher(project, mavenContext);
        try {
            this.agent = Activator.createProvisioningAgent(project == null ? null : project.getBasedir().toURI());
        }
        catch (ProvisionException provisionException) {
            // empty catch block
        }
        this.fileRepositoryArtifactProvider = new FileRepositoryArtifactProvider(Collections.singletonList(new FileArtifactRepository(this.agent, () -> this.fileDescriptors.iterator())), ArtifactTransferPolicies.forLocalArtifacts());
    }

    public File getProjectLocation() {
        if (this.project != null) {
            return this.project.getBasedir();
        }
        return null;
    }

    public void addMavenArtifact(IArtifactFacade artifact, boolean allowGenerateOSGiBundle) {
        if (artifact instanceof ReactorProjectFacade) {
            File artifactFile;
            ReactorProjectFacade projectFacade = (ReactorProjectFacade)artifact;
            ReactorProject reactorProject = projectFacade.getReactorProject();
            String packaging = reactorProject.getPackaging();
            if (("bundle".equalsIgnoreCase(packaging) || "jar".equalsIgnoreCase(packaging)) && (artifactFile = reactorProject.getArtifact()) != null) {
                try {
                    BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)artifactFile);
                    if (bundleDescription != null && bundleDescription.getSymbolicName() != null) {
                        IArtifactKey key = BundlesAction.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
                        PublisherInfo publisherInfo = new PublisherInfo();
                        publisherInfo.setArtifactOptions(1);
                        IArtifactDescriptor descriptor = FileArtifactRepository.forFile(artifactFile, key);
                        this.fileDescriptors.add(descriptor);
                        IInstallableUnit iu = BundlesAction.createBundleIU((BundleDescription)bundleDescription, (IArtifactKey)key, (IPublisherInfo)publisherInfo);
                        this.mavenInstallableUnits.put(iu, (IArtifactFacade)projectFacade);
                        this.descriptorMap.put((IArtifactFacade)projectFacade, descriptor);
                    } else if (allowGenerateOSGiBundle) {
                        this.logger.warn("Referenced reactor project " + projectFacade + " has no valid OSGi metadata and allowGenerateOSGiBundle=true is not applicable for reactor projects, consider adding felix- or bnd-maven-plugin to this project to generate appropriate OSGi headers in the first place.");
                    }
                }
                catch (IOException | BundleException e) {
                    this.logger.warn("Referenced reactor project " + projectFacade + " could not be read!", e);
                }
            }
        } else {
            MavenBundleInfo bundleIU = this.bundlesPublisher.attemptToPublishBundle(artifact, allowGenerateOSGiBundle);
            if (bundleIU != null) {
                this.addMavenArtifact(bundleIU.getArtifact(), Collections.singleton(bundleIU.getUnit()));
                this.descriptorMap.put(bundleIU.getArtifact(), bundleIU.getDescriptor());
            }
        }
    }

    public void addArtifactWithExistingMetadata(IArtifactFacade artifact, IArtifactFacade p2MetadataFile) {
        try {
            this.addMavenArtifact(artifact, this.readUnits(p2MetadataFile));
        }
        catch (IOException e) {
            throw new RuntimeException("failed to read p2 metadata", e);
        }
    }

    private Set<IInstallableUnit> readUnits(IArtifactFacade p2MetadataFile) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream inputStream = new FileInputStream(p2MetadataFile.getLocation());){
            MetadataIO io = new MetadataIO();
            return io.readXML((InputStream)inputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void addMavenArtifact(IArtifactFacade artifact, Set<IInstallableUnit> units) {
        for (IInstallableUnit unit : units) {
            String classifier = unit.getProperty("maven-classifier");
            if (Objects.equals(classifier, artifact.getClassifier())) {
                this.mavenInstallableUnits.put(unit, artifact);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("P2Resolver: artifact " + new GAV(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()).toString() + " at location " + artifact.getLocation() + " resolves installable unit " + new VersionedId(unit.getId(), unit.getVersion()));
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("P2Resolver: artifact " + new GAV(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()).toString() + " for installable unit " + new VersionedId(unit.getId(), unit.getVersion()) + " is ignored because of classifier missmatch");
        }
    }

    LinkedHashSet<IInstallableUnit> gatherMavenInstallableUnits() {
        return new LinkedHashSet<IInstallableUnit>(this.getMavenInstallableUnits().keySet());
    }

    public Map<IInstallableUnit, IArtifactFacade> getMavenInstallableUnits() {
        return this.mavenInstallableUnits;
    }

    IRawArtifactFileProvider getArtifactRepoOfPublishedBundles() {
        return new CompositeArtifactProvider(new IRawArtifactFileProvider[]{this.bundlesPublisher.getArtifactRepoOfPublishedBundles(), this.fileRepositoryArtifactProvider});
    }

    public ArtifactKey getArtifactKey(IArtifactFacade facade) {
        IArtifactDescriptor artifactDescriptor = this.descriptorMap.get(facade);
        if (artifactDescriptor == null) {
            return new DefaultArtifactKey("eclipse-plugin", facade.getArtifactId(), facade.getVersion());
        }
        IArtifactKey artifactKey = artifactDescriptor.getArtifactKey();
        return new DefaultArtifactKey("eclipse-plugin", artifactKey.getId(), artifactKey.getVersion().toString());
    }
}

