/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.util.resolution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.Projector;
import org.eclipse.equinox.internal.p2.director.QueryableArray;
import org.eclipse.equinox.internal.p2.director.SimplePlanner;
import org.eclipse.equinox.internal.p2.director.Slicer;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.p2.util.resolution.AbstractSlicerResolutionStrategy;
import org.eclipse.tycho.p2.util.resolution.ResolverDebugUtils;
import org.eclipse.tycho.p2.util.resolution.ResolverException;
import org.eclipse.tycho.repository.util.StatusTool;

public class ProjectorResolutionStrategy
extends AbstractSlicerResolutionStrategy {
    private static final int MAX_ITERATIONS = Integer.getInteger("tycho.internal.ProjectorResolutionStrategy.maxIterations", 1000);

    public ProjectorResolutionStrategy(MavenLogger logger) {
        super(logger);
    }

    @Override
    protected Slicer newSlicer(IQueryable<IInstallableUnit> availableUnits, Map<String, String> properties) {
        final Predicate<IInstallableUnit> acceptor = this.data.getIInstallableUnitAcceptor();
        return new Slicer(availableUnits, properties, false){

            protected boolean isApplicable(IInstallableUnit iu) {
                if (acceptor != null) {
                    return acceptor.test(iu);
                }
                return super.isApplicable(iu);
            }
        };
    }

    @Override
    protected boolean isSlicerError(MultiStatus slicerStatus) {
        return slicerStatus.matches(12);
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    @Override
    public Collection<IInstallableUnit> resolve(Map<String, String> properties, IProgressMonitor monitor) throws ResolverException {
        Set explanation;
        IStatus s;
        Map selectionContext;
        block6: {
            ArrayList<IInstallableUnit> generatedUnits = new ArrayList<IInstallableUnit>();
            selectionContext = SimplePlanner.createSelectionContext(properties);
            LinkedHashSet<IInstallableUnit> seedUnits = new LinkedHashSet<IInstallableUnit>(this.data.getRootIUs());
            ArrayList<IRequirement> seedRequires = new ArrayList<IRequirement>();
            if (this.data.getAdditionalRequirements() != null) {
                seedRequires.addAll(this.data.getAdditionalRequirements());
            }
            seedUnits.addAll(this.data.getEEResolutionHints().getMandatoryUnits());
            seedRequires.addAll(this.data.getEEResolutionHints().getMandatoryRequires());
            int iteration = 0;
            do {
                IInstallableUnit providing;
                int newCapabilities;
                List<IRequirement> missingRequirements;
                Projector projector = new Projector(this.slice(properties, generatedUnits, monitor), selectionContext, new HashSet(), false);
                projector.encode(ProjectorResolutionStrategy.createUnitRequiring("tycho", seedUnits, seedRequires), EMPTY_IU_ARRAY, (IQueryable)new QueryableArray(EMPTY_IU_ARRAY), seedUnits, monitor);
                s = projector.invokeSolver(monitor);
                if (s.getSeverity() != 4) {
                    Collection newState = projector.extractSolution();
                    newState.removeAll(this.data.getEEResolutionHints().getTemporaryAdditions());
                    newState.removeAll(generatedUnits);
                    if (!this.logger.isExtendedDebugEnabled()) return newState;
                    this.logger.debug("Resolved IUs:\n" + ResolverDebugUtils.toDebugString(newState, false));
                    return newState;
                }
                explanation = projector.getExplanation((IProgressMonitor)new NullProgressMonitor());
                if (this.data.failOnMissingRequirements() || (missingRequirements = this.computeMissingRequirements(explanation)).size() <= 0) break block6;
                if (this.logger.isExtendedDebugEnabled()) {
                    this.logger.debug("At iteration " + iteration + " the following requirements are not yet satisfied:");
                    for (IRequirement requirement : missingRequirements) {
                        this.logger.debug("> " + requirement);
                    }
                }
                if ((newCapabilities = (providing = this.createUnitProviding("tycho.unresolved.requirements", missingRequirements)).getProvidedCapabilities().size()) <= 0) break block6;
                if (this.logger.isExtendedDebugEnabled()) {
                    this.logger.debug(String.valueOf(newCapabilities) + " new capabilities where created, starting next iteration...");
                }
                generatedUnits.add(providing);
            } while (++iteration < MAX_ITERATIONS);
            throw new ResolverException("Maximum iterations reached", new TimeoutException());
        }
        this.logger.debug(StatusTool.collectProblems((IStatus)s));
        this.explainProblems(explanation, MavenLogger::error);
        throw new ResolverException(explanation.stream().map(Object::toString).collect(Collectors.joining("\n")), selectionContext.toString(), StatusTool.findException((IStatus)s));
    }
}

